/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.ToString;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class Escape
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            String s;
            Object o1 = args[0];
            Object o2 = args[1];
            if (o1 instanceof String) {
                s = (String)o1;
            } else if (o1 == null) {
                s = "";
            } else {
                ToString toString = new ToString();
                s = toString.call(bindings, new Object[]{o1});
            }
            if (o2 instanceof String) {
                String mode;
                switch (mode = ((String)o2).toLowerCase(Locale.ENGLISH)) {
                    case "html": {
                        return StringEscapeUtils.escapeHtml((String)s);
                    }
                    case "xml": {
                        return StringEscapeUtils.escapeXml((String)s);
                    }
                    case "csv": {
                        return StringEscapeUtils.escapeCsv((String)s);
                    }
                    case "javascript": {
                        return StringEscapeUtils.escapeJavaScript((String)s);
                    }
                    case "url": {
                        try {
                            return URLEncoder.encode(s, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            break;
                        }
                    }
                    default: {
                        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " does not recognize mode '" + mode + "'.");
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Escape.DOCUMENTATION", "Escapes a string using the escaping mode specified. Supported modes are: html, xml, csv, url, javascript.").withParams("string s, string mode").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions");
    }
}

