/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines.overrides;

import com.dataiku.scoring.models.overrides.MLOverridesParamsBase;
import java.util.ArrayList;
import java.util.List;

public abstract class OverridesOutcomeComputer<T> {
    List<OutcomeCandidate<T>> candidates = new ArrayList<OutcomeCandidate<T>>();
    public boolean initialized = false;

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Outcome computer not initialized");
        }
    }

    public OutcomeCandidate<T> getOutcomeCandidate(T obs) {
        this.checkInitialized();
        for (OutcomeCandidate<T> candidate : this.candidates) {
            if (!candidate.filter.matches(obs).booleanValue()) continue;
            return candidate;
        }
        return null;
    }

    public void registerCandidate(String overrideName, MLOverridesParamsBase.MLOverride.Outcome outcome, OverrideFilter<T> filter) {
        this.candidates.add(new OutcomeCandidate<T>(overrideName, outcome, filter));
    }

    public abstract void init();

    public static class OutcomeCandidate<T> {
        public final MLOverridesParamsBase.MLOverride.Outcome outcome;
        public final String overrideName;
        private final OverrideFilter<T> filter;

        public OutcomeCandidate(String overrideName, MLOverridesParamsBase.MLOverride.Outcome outcome, OverrideFilter<T> filter) {
            this.overrideName = overrideName;
            this.outcome = outcome;
            this.filter = filter;
        }
    }

    public static interface OverrideFilter<T> {
        public Boolean matches(T var1);
    }
}

