/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.tokenexchange;

import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.GrantType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.OAuth2Error;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Audience;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.Token;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.TypelessToken;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public class TokenExchangeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.TOKEN_EXCHANGE;
    private final Token subjectToken;
    private final TokenTypeURI subjectTokenType;
    private final Token actorToken;
    private final TokenTypeURI actorTokenType;
    private final TokenTypeURI requestedTokenType;
    private final List<Audience> audience;

    public TokenExchangeGrant(Token subjectToken, TokenTypeURI subjectTokenType) {
        this(subjectToken, subjectTokenType, null, null, null, null);
    }

    public TokenExchangeGrant(Token subjectToken, TokenTypeURI subjectTokenType, Token actorToken, TokenTypeURI actorTokenType, TokenTypeURI requestedTokenType, List<Audience> audience) {
        super(GRANT_TYPE);
        this.subjectToken = Objects.requireNonNull(subjectToken);
        this.subjectTokenType = Objects.requireNonNull(subjectTokenType);
        this.actorToken = actorToken;
        if (actorToken != null && actorTokenType == null) {
            throw new IllegalArgumentException("If an actor token is specified the actor token type must not be null");
        }
        this.actorTokenType = actorTokenType;
        this.requestedTokenType = requestedTokenType;
        this.audience = audience;
    }

    public Token getSubjectToken() {
        return this.subjectToken;
    }

    public TokenTypeURI getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public Token getActorToken() {
        return this.actorToken;
    }

    public TokenTypeURI getActorTokenType() {
        return this.actorTokenType;
    }

    public TokenTypeURI getRequestedTokenType() {
        return this.requestedTokenType;
    }

    public List<Audience> getAudience() {
        return this.audience;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        if (CollectionUtils.isNotEmpty(this.audience)) {
            params.put("audience", Audience.toStringList(this.audience));
        }
        if (this.requestedTokenType != null) {
            params.put("requested_token_type", Collections.singletonList(this.requestedTokenType.getURI().toString()));
        }
        params.put("subject_token", Collections.singletonList(this.subjectToken.getValue()));
        params.put("subject_token_type", Collections.singletonList(this.subjectTokenType.getURI().toString()));
        if (this.actorToken != null) {
            params.put("actor_token", Collections.singletonList(this.actorToken.getValue()));
            params.put("actor_token_type", Collections.singletonList(this.actorTokenType.getURI().toString()));
        }
        return params;
    }

    private static List<Audience> parseAudience(Map<String, List<String>> params) {
        List<String> audienceList = params.get("audience");
        if (CollectionUtils.isEmpty(audienceList)) {
            return null;
        }
        return Audience.create(audienceList);
    }

    private static TokenTypeURI parseTokenType(Map<String, List<String>> params, String key, boolean mandatory) throws ParseException {
        String tokenTypeString = MultivaluedMapUtils.getFirstValue(params, key);
        if (StringUtils.isBlank(tokenTypeString)) {
            if (mandatory) {
                String msg = String.format("Missing or empty %s parameter", key);
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
            }
            return null;
        }
        try {
            return TokenTypeURI.parse(tokenTypeString);
        }
        catch (ParseException uriSyntaxException) {
            String msg = "Invalid " + key + " " + tokenTypeString;
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
    }

    private static TypelessToken parseToken(Map<String, List<String>> params, String key, boolean mandatory) throws ParseException {
        String tokenString = MultivaluedMapUtils.getFirstValue(params, key);
        if (StringUtils.isBlank(tokenString)) {
            if (mandatory) {
                String msg = String.format("Missing or empty %s parameter", key);
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
            }
            return null;
        }
        return new TypelessToken(tokenString);
    }

    public static TokenExchangeGrant parse(Map<String, List<String>> params) throws ParseException {
        GrantType.ensure(GRANT_TYPE, params);
        List<Audience> audience = TokenExchangeGrant.parseAudience(params);
        TokenTypeURI requestedTokenType = TokenExchangeGrant.parseTokenType(params, "requested_token_type", false);
        TypelessToken subjectToken = TokenExchangeGrant.parseToken(params, "subject_token", true);
        TokenTypeURI subjectTokenType = TokenExchangeGrant.parseTokenType(params, "subject_token_type", true);
        TypelessToken actorToken = TokenExchangeGrant.parseToken(params, "actor_token", false);
        TokenTypeURI actorTokenType = TokenExchangeGrant.parseTokenType(params, "actor_token_type", false);
        return new TokenExchangeGrant(subjectToken, subjectTokenType, actorToken, actorTokenType, requestedTokenType, audience);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenExchangeGrant)) {
            return false;
        }
        TokenExchangeGrant that = (TokenExchangeGrant)o;
        return this.getSubjectToken().equals(that.getSubjectToken()) && this.getSubjectTokenType().equals(that.getSubjectTokenType()) && Objects.equals(this.getActorToken(), that.getActorToken()) && Objects.equals(this.getActorTokenType(), that.getActorTokenType()) && Objects.equals(this.getRequestedTokenType(), that.getRequestedTokenType()) && Objects.equals(this.getAudience(), that.getAudience());
    }

    public int hashCode() {
        return Objects.hash(this.getSubjectToken(), this.getSubjectTokenType(), this.getActorToken(), this.getActorTokenType(), this.getRequestedTokenType(), this.getAudience());
    }
}

