/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.core;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Tokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenizerFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.core.UnicodeWhitespaceTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.core.WhitespaceTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.util.AttributeFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class WhitespaceTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "whitespace";
    public static final String RULE_JAVA = "java";
    public static final String RULE_UNICODE = "unicode";
    private static final Collection<String> RULE_NAMES = Arrays.asList("java", "unicode");
    private final String rule;
    private final int maxTokenLen;

    public WhitespaceTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.rule = this.get(args2, "rule", RULE_NAMES, RULE_JAVA);
        this.maxTokenLen = this.getInt(args2, "maxTokenLen", 255);
        if (this.maxTokenLen > 0x100000 || this.maxTokenLen <= 0) {
            throw new IllegalArgumentException("maxTokenLen must be greater than 0 and less than 1048576 passed: " + this.maxTokenLen);
        }
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public WhitespaceTokenizerFactory() {
        throw WhitespaceTokenizerFactory.defaultCtorException();
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        switch (this.rule) {
            case "java": {
                return new WhitespaceTokenizer(factory, this.maxTokenLen);
            }
            case "unicode": {
                return new UnicodeWhitespaceTokenizer(factory, this.maxTokenLen);
            }
        }
        throw new AssertionError();
    }
}

