/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene90.compressing;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.TermVectorsFormat;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.TermVectorsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.TermVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.compressing.CompressionMode;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingTermVectorsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingTermVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfos;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IOContext;
import java.io.IOException;

public class Lucene90CompressingTermVectorsFormat
extends TermVectorsFormat {
    private final String formatName;
    private final String segmentSuffix;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int blockSize;
    private final int maxDocsPerChunk;

    public Lucene90CompressingTermVectorsFormat(String formatName, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockSize) {
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (chunkSize < 1) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be >= 1");
        }
        this.blockSize = blockSize;
    }

    @Override
    public final TermVectorsReader vectorsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext context) throws IOException {
        return new Lucene90CompressingTermVectorsReader(directory, segmentInfo, this.segmentSuffix, fieldInfos, context, this.formatName, this.compressionMode);
    }

    @Override
    public final TermVectorsWriter vectorsWriter(Directory directory, SegmentInfo segmentInfo, IOContext context) throws IOException {
        return new Lucene90CompressingTermVectorsWriter(directory, segmentInfo, this.segmentSuffix, context, this.formatName, this.compressionMode, this.chunkSize, this.maxDocsPerChunk, this.blockSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + this.compressionMode + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockSize=" + this.blockSize + ")";
    }
}

