/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldTermIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.store.ByteBuffersDataInput;
import com.dataiku.dss.shadelib.org.apache.lucene.store.ByteBuffersDataOutput;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Accountable;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRefBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.StringHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;

public class PrefixCodedTerms
implements Accountable {
    private final List<ByteBuffer> content;
    private final long size;
    private long delGen;
    private int lazyHash;

    private PrefixCodedTerms(List<ByteBuffer> content, long size) {
        this.content = Objects.requireNonNull(content);
        this.size = size;
    }

    @Override
    public long ramBytesUsed() {
        return this.content.stream().mapToLong(buf -> buf.capacity()).sum() + 16L;
    }

    public void setDelGen(long delGen) {
        this.delGen = delGen;
    }

    public TermIterator iterator() {
        return new TermIterator(this.delGen, new ByteBuffersDataInput(this.content));
    }

    public long size() {
        return this.size;
    }

    public int hashCode() {
        if (this.lazyHash == 0) {
            int h2 = 1;
            for (ByteBuffer bb : this.content) {
                h2 += 31 * bb.hashCode();
            }
            this.lazyHash = h2 = 31 * h2 + (int)(this.delGen ^ this.delGen >>> 32);
        }
        return this.lazyHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixCodedTerms other = (PrefixCodedTerms)obj;
        return this.delGen == other.delGen && this.size() == other.size() && this.content.equals(other.content);
    }

    public static class TermIterator
    extends FieldTermIterator {
        final ByteBuffersDataInput input;
        final BytesRefBuilder builder = new BytesRefBuilder();
        final BytesRef bytes = this.builder.get();
        final long end;
        final long delGen;
        String field = "";

        private TermIterator(long delGen, ByteBuffersDataInput input) {
            this.input = input;
            this.end = input.size();
            this.delGen = delGen;
        }

        @Override
        public BytesRef next() {
            if (this.input.position() < this.end) {
                try {
                    boolean newField;
                    int code = this.input.readVInt();
                    boolean bl = newField = (code & 1) != 0;
                    if (newField) {
                        this.field = this.input.readString();
                    }
                    int prefix = code >>> 1;
                    int suffix = this.input.readVInt();
                    this.readTermBytes(prefix, suffix);
                    return this.bytes;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.field = null;
            return null;
        }

        private void readTermBytes(int prefix, int suffix) throws IOException {
            this.builder.grow(prefix + suffix);
            this.input.readBytes(this.builder.bytes(), prefix, suffix);
            this.builder.setLength(prefix + suffix);
        }

        @Override
        public String field() {
            return this.field;
        }

        @Override
        public long delGen() {
            return this.delGen;
        }
    }

    public static class Builder {
        private ByteBuffersDataOutput output = new ByteBuffersDataOutput();
        private Term lastTerm = new Term("");
        private BytesRefBuilder lastTermBytes = new BytesRefBuilder();
        private long size;

        public void add(Term term) {
            this.add(term.field(), term.bytes());
        }

        public void add(String field, BytesRef bytes) {
            assert (this.lastTerm.equals(new Term("")) || new Term(field, bytes).compareTo(this.lastTerm) > 0);
            try {
                int prefix;
                if (this.size > 0L && field.equals(this.lastTerm.field)) {
                    prefix = StringHelper.bytesDifference(this.lastTerm.bytes, bytes);
                    this.output.writeVInt(prefix << 1);
                } else {
                    prefix = 0;
                    this.output.writeVInt(1);
                    this.output.writeString(field);
                }
                int suffix = bytes.length - prefix;
                this.output.writeVInt(suffix);
                this.output.writeBytes(bytes.bytes, bytes.offset + prefix, suffix);
                this.lastTermBytes.copyBytes(bytes);
                this.lastTerm.bytes = this.lastTermBytes.get();
                this.lastTerm.field = field;
                ++this.size;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public PrefixCodedTerms finish() {
            return new PrefixCodedTerms(this.output.toBufferList(), this.size);
        }
    }
}

