/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.Codec;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.NormsProducer;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.TermVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ByteSliceReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInvertState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentWriteState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Sorter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermVectorsConsumerPerField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsHash;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsHashPerField;
import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.FlushInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IOContext;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Accountable;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ByteBlockPool;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Counter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IntBlockPool;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

class TermVectorsConsumer
extends TermsHash {
    protected final Directory directory;
    protected final SegmentInfo info;
    protected final Codec codec;
    TermVectorsWriter writer;
    final BytesRef flushTerm = new BytesRef();
    final ByteSliceReader vectorSliceReaderPos = new ByteSliceReader();
    final ByteSliceReader vectorSliceReaderOff = new ByteSliceReader();
    private boolean hasVectors;
    private int numVectorFields;
    int lastDocID;
    private TermVectorsConsumerPerField[] perFields = new TermVectorsConsumerPerField[1];
    Accountable accountable = Accountable.NULL_ACCOUNTABLE;

    TermVectorsConsumer(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Directory directory, SegmentInfo info, Codec codec) {
        super(intBlockAllocator, byteBlockAllocator, Counter.newCounter(), null);
        this.directory = directory;
        this.info = info;
        this.codec = codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        if (this.writer != null) {
            int numDocs = state.segmentInfo.maxDoc();
            assert (numDocs > 0);
            try {
                this.fill(numDocs);
                assert (state.segmentInfo != null);
                this.writer.finish(numDocs);
            }
            catch (Throwable throwable) {
                IOUtils.close(this.writer);
                throw throwable;
            }
            IOUtils.close(this.writer);
        }
    }

    void fill(int docID) throws IOException {
        while (this.lastDocID < docID) {
            this.writer.startDocument(0);
            this.writer.finishDocument();
            ++this.lastDocID;
        }
    }

    void initTermVectorsWriter() throws IOException {
        if (this.writer == null) {
            IOContext context = new IOContext(new FlushInfo(this.lastDocID, this.bytesUsed.get()));
            this.writer = this.codec.termVectorsFormat().vectorsWriter(this.directory, this.info, context);
            this.lastDocID = 0;
            this.accountable = this.writer;
        }
    }

    void setHasVectors() {
        this.hasVectors = true;
    }

    @Override
    void finishDocument(int docID) throws IOException {
        if (!this.hasVectors) {
            return;
        }
        ArrayUtil.introSort((Comparable[])this.perFields, (int)0, (int)this.numVectorFields);
        this.initTermVectorsWriter();
        this.fill(docID);
        this.writer.startDocument(this.numVectorFields);
        for (int i = 0; i < this.numVectorFields; ++i) {
            this.perFields[i].finishDocument();
        }
        this.writer.finishDocument();
        assert (this.lastDocID == docID) : "lastDocID=" + this.lastDocID + " docID=" + docID;
        ++this.lastDocID;
        super.reset();
        this.resetFields();
    }

    @Override
    public void abort() {
        try {
            super.abort();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this.writer);
            this.reset();
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.writer);
        this.reset();
    }

    void resetFields() {
        Arrays.fill(this.perFields, null);
        this.numVectorFields = 0;
    }

    @Override
    public TermsHashPerField addField(FieldInvertState invertState, FieldInfo fieldInfo) {
        return new TermVectorsConsumerPerField(invertState, this, fieldInfo);
    }

    void addFieldToFlush(TermVectorsConsumerPerField fieldToFlush) {
        if (this.numVectorFields == this.perFields.length) {
            int newSize = ArrayUtil.oversize(this.numVectorFields + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            TermVectorsConsumerPerField[] newArray = new TermVectorsConsumerPerField[newSize];
            System.arraycopy(this.perFields, 0, newArray, 0, this.numVectorFields);
            this.perFields = newArray;
        }
        this.perFields[this.numVectorFields++] = fieldToFlush;
    }

    @Override
    void startDocument() {
        this.resetFields();
        this.numVectorFields = 0;
    }
}

