/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight;

import com.dataiku.dss.shadelib.org.apache.lucene.index.FilterLeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

final class TermVectorFilteredLeafReader
extends FilterLeafReader {
    private final Terms filterTerms;
    private final String fieldFilter;

    TermVectorFilteredLeafReader(LeafReader baseLeafReader, Terms filterTerms, String fieldFilter) {
        super(baseLeafReader);
        this.filterTerms = filterTerms;
        this.fieldFilter = fieldFilter;
    }

    @Override
    public Terms terms(String field) throws IOException {
        if (!field.equals(this.fieldFilter)) {
            return super.terms(field);
        }
        Terms terms = this.in.terms(field);
        return terms == null ? null : new TermsFilteredTerms(terms, this.filterTerms);
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private static final class TermVectorFilteredTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private final TermsEnum baseTermsEnum;

        TermVectorFilteredTermsEnum(TermsEnum baseTermsEnum, TermsEnum filteredTermsEnum) {
            super(filteredTermsEnum);
            this.baseTermsEnum = baseTermsEnum;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            this.moveToCurrentTerm();
            return this.baseTermsEnum.postings(reuse, flags);
        }

        void moveToCurrentTerm() throws IOException {
            BytesRef currentTerm = this.in.term();
            boolean termInBothTermsEnum = this.baseTermsEnum.seekExact(currentTerm);
            if (!termInBothTermsEnum) {
                throw new IllegalStateException("Term vector term '" + currentTerm.utf8ToString() + "' does not appear in full index.");
            }
        }
    }

    private static final class TermsFilteredTerms
    extends FilterLeafReader.FilterTerms {
        private final Terms filterTerms;

        TermsFilteredTerms(Terms baseTerms, Terms filterTerms) {
            super(baseTerms);
            this.filterTerms = filterTerms;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new TermVectorFilteredTermsEnum(this.in.iterator(), this.filterTerms.iterator());
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new TermVectorFilteredTermsEnum(this.in.iterator(), this.filterTerms.intersect(compiled, startTerm));
        }
    }
}

