/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.http;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.BufferUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Index;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.URIUtil;
import java.nio.ByteBuffer;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https"),
    WS("ws"),
    WSS("wss");

    public static final Index<HttpScheme> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;
    private final int _defaultPort;

    private HttpScheme(String s2) {
        this._string = s2;
        this._buffer = BufferUtil.toBuffer(s2);
        this._defaultPort = URIUtil.getDefaultPortForScheme(s2);
    }

    public ByteBuffer asByteBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public boolean is(String s2) {
        return this._string.equalsIgnoreCase(s2);
    }

    public String asString() {
        return this._string;
    }

    public int getDefaultPort() {
        return this._defaultPort;
    }

    public int normalizePort(int port) {
        return port == this._defaultPort ? 0 : port;
    }

    public String toString() {
        return this._string;
    }

    @Deprecated
    public static int getDefaultPort(String scheme) {
        return URIUtil.getDefaultPortForScheme(scheme);
    }

    @Deprecated
    public static int normalizePort(String scheme, int port) {
        return URIUtil.normalizePortForScheme(scheme, port);
    }

    public static boolean isSecure(String scheme) {
        return HTTPS.is(scheme) || WSS.is(scheme);
    }

    static {
        CACHE = new Index.Builder().caseSensitive(false).withAll(HttpScheme.values(), HttpScheme::asString).build();
    }
}

