/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.io;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.AbstractRetainableByteBuffer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.Retainable;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.RetainableByteBuffer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface ByteBufferPool {
    public static final ByteBufferPool NON_POOLING = new NonPooling();
    public static final Sized SIZED_NON_POOLING = new Sized(NON_POOLING);

    public RetainableByteBuffer acquire(int var1, boolean var2);

    @Deprecated
    default public boolean removeAndRelease(RetainableByteBuffer buffer) {
        return buffer != null && buffer.release();
    }

    public void clear();

    public static class NonPooling
    implements ByteBufferPool {
        @Override
        public RetainableByteBuffer acquire(int size, boolean direct) {
            return new Buffer(BufferUtil.allocate(size, direct));
        }

        @Override
        public void clear() {
        }

        private static class Buffer
        extends AbstractRetainableByteBuffer {
            private Buffer(ByteBuffer byteBuffer) {
                super(byteBuffer);
                this.acquire();
            }
        }
    }

    public static class Sized
    extends Wrapper {
        private final boolean _direct;
        private final int _size;

        public Sized(ByteBufferPool wrapped) {
            this(wrapped, false, -1);
        }

        public Sized(ByteBufferPool wrapped, boolean direct, int size) {
            super(Objects.requireNonNullElse(wrapped, NON_POOLING));
            this._direct = direct;
            this._size = size > 0 ? size : 4096;
        }

        public boolean isDirect() {
            return this._direct;
        }

        public int getSize() {
            return this._size;
        }

        public RetainableByteBuffer acquire() {
            return this.getWrapped().acquire(this._size, this._direct);
        }
    }

    public static class Accumulator {
        private final List<RetainableByteBuffer> buffers = new ArrayList<RetainableByteBuffer>();
        private final List<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>();

        public void append(RetainableByteBuffer buffer) {
            this.buffers.add(buffer);
            this.byteBuffers.add(buffer.getByteBuffer());
        }

        public void insert(int index, RetainableByteBuffer buffer) {
            this.buffers.add(index, buffer);
            this.byteBuffers.add(index, buffer.getByteBuffer());
        }

        public List<ByteBuffer> getByteBuffers() {
            return this.byteBuffers;
        }

        public long getTotalLength() {
            long length = 0L;
            for (ByteBuffer buffer : this.byteBuffers) {
                length += (long)buffer.remaining();
            }
            return length;
        }

        public int getSize() {
            return this.byteBuffers.size();
        }

        public void release() {
            this.buffers.forEach(Retainable::release);
            this.buffers.clear();
            this.byteBuffers.clear();
        }
    }

    public static class Wrapper
    implements ByteBufferPool {
        private final ByteBufferPool wrapped;

        public Wrapper(ByteBufferPool wrapped) {
            this.wrapped = wrapped;
        }

        public ByteBufferPool getWrapped() {
            return this.wrapped;
        }

        @Override
        public RetainableByteBuffer acquire(int size, boolean direct) {
            return this.getWrapped().acquire(size, direct);
        }

        @Override
        public void clear() {
            this.getWrapped().clear();
        }
    }
}

