/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie;

import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.FormattedHeader;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.Header;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HeaderElement;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CommonCookieAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.Cookie;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CookieOrigin;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CookieSpec;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.MalformedCookieException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.SetCookie2;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.BasicCommentHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.BasicDomainHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.BasicExpiresHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.BasicMaxAgeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.BasicPathHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.BasicSecureHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.NetscapeDraftHeaderParser;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.NetscapeDraftSpec;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2109DomainHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2109Spec;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2109VersionHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2965DiscardAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2965DomainAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2965PortAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2965Spec;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.RFC2965VersionAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.message.ParserCursor;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.CharArrayBuffer;
import java.util.List;

@Contract(threading=ThreadingBehavior.SAFE)
public class DefaultCookieSpec
implements CookieSpec {
    private final RFC2965Spec strict;
    private final RFC2109Spec obsoleteStrict;
    private final NetscapeDraftSpec netscapeDraft;

    DefaultCookieSpec(RFC2965Spec strict, RFC2109Spec obsoleteStrict, NetscapeDraftSpec netscapeDraft) {
        this.strict = strict;
        this.obsoleteStrict = obsoleteStrict;
        this.netscapeDraft = netscapeDraft;
    }

    public DefaultCookieSpec(String[] datepatterns, boolean oneHeader) {
        String[] stringArray;
        this.strict = new RFC2965Spec(oneHeader, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), new RFC2965DomainAttributeHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
        this.obsoleteStrict = new RFC2109Spec(oneHeader, new RFC2109VersionHandler(), new BasicPathHandler(), new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler());
        CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
        commonCookieAttributeHandlerArray[0] = new BasicDomainHandler();
        commonCookieAttributeHandlerArray[1] = new BasicPathHandler();
        commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
        commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
        if (datepatterns != null) {
            stringArray = (String[])datepatterns.clone();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "EEE, dd-MMM-yy HH:mm:ss z";
        }
        commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray);
        this.netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
    }

    public DefaultCookieSpec() {
        this(null, false);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(origin, "Cookie origin");
        HeaderElement[] helems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        for (HeaderElement helem : helems) {
            if (helem.getParameterByName("version") != null) {
                versioned = true;
            }
            if (helem.getParameterByName("expires") == null) continue;
            netscape = true;
        }
        if (netscape || !versioned) {
            ParserCursor cursor;
            CharArrayBuffer buffer;
            NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String s2 = header.getValue();
                if (s2 == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                buffer = new CharArrayBuffer(s2.length());
                buffer.append(s2);
                cursor = new ParserCursor(0, buffer.length());
            }
            helems = new HeaderElement[]{parser.parseHeader(buffer, cursor)};
            return this.netscapeDraft.parse(helems, origin);
        }
        if ("Set-Cookie2".equals(header.getName())) {
            return this.strict.parse(helems, origin);
        }
        return this.obsoleteStrict.parse(helems, origin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                this.strict.validate(cookie, origin);
            } else {
                this.obsoleteStrict.validate(cookie, origin);
            }
        } else {
            this.netscapeDraft.validate(cookie, origin);
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                return this.strict.match(cookie, origin);
            }
            return this.obsoleteStrict.match(cookie, origin);
        }
        return this.netscapeDraft.match(cookie, origin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        Args.notNull(cookies, "List of cookies");
        int version = Integer.MAX_VALUE;
        boolean isSetCookie2 = true;
        for (Cookie cookie : cookies) {
            if (!(cookie instanceof SetCookie2)) {
                isSetCookie2 = false;
            }
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        if (version > 0) {
            if (isSetCookie2) {
                return this.strict.formatCookies(cookies);
            }
            return this.obsoleteStrict.formatCookies(cookies);
        }
        return this.netscapeDraft.formatCookies(cookies);
    }

    @Override
    public int getVersion() {
        return this.strict.getVersion();
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "default";
    }
}

