/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.execchain;

import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.Log;
import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.LogFactory;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.Header;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.ServiceUnavailableRetryStrategy;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.methods.HttpExecutionAware;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.methods.HttpRequestWrapper;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.protocol.HttpClientContext;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.routing.HttpRoute;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.execchain.ClientExecChain;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.execchain.RequestEntityProxy;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context) && RequestEntityProxy.isRepeatable(request)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

