#' In a R custom recipe, retrieve the input names for a given role.
#'
#' Please see documentation about how to write custom recipes
#' @param role the name of the role
#' @param as_full_names Whether to return fully-qualified dataset names (PROJECT_KEY.DATASET_NAME)
#' @return A character vector of the input names for this role
#'
#' @export
dkuCustomRecipeInputNamesForRole <- function(role, as_full_names=TRUE) {
    parsedRSpec <- getDkuFlowSpec()

	ret <- character()

	for(input in parsedRSpec[["in"]]) {
        if(input["role"] == role) {
        	if (as_full_names) {
            	ret <- c(ret, input[["fullName"]])
            } else {
            	ret <- c(ret, input[["smartName"]])
            }
        }
    }
    return(ret)
}

#' In a R custom recipe, retrieve the output names for a given role.
#'
#' Please see documentation about how to write custom recipes
#' @param role the name of the role
#' @param as_full_names Whether to return fully-qualified dataset names (PROJECT_KEY.DATASET_NAME)
#' @return A character vector of the output names for this role
#'
#' @export
dkuCustomRecipeOutputNamesForRole <- function(role, as_full_names=TRUE) {
    parsedRSpec <- getDkuFlowSpec()

	ret <- character()

	for(output in parsedRSpec[["out"]]) {
        if(output["role"] == role) {
        	if (as_full_names) {
            	ret <- c(ret, output[["fullName"]])
            } else {
            	ret <- c(ret, output[["smartName"]])
            }
        }
    }
    return(ret)
}

#' In a R custom recipe, retrieve the configuration of the recipe
#' as a dictionary
#'
#' Please see documentation about how to write custom recipes
#'
#' @export
dkuCustomRecipeConfig <- function(){
	rSpec <- dku_remoterun__get_env_var("DKU_CUSTOM_RECIPE_CONFIG")
	return(RJSONIO::fromJSON(rSpec))
}

#' In a R custom recipe, retrieve the general configuration of the
#' DSS instance as a dictionary
#'
#' Please see documentation about how to write custom recipes
#'
#' @export
dkuDSSSettings <- function(){
	backendPort = dku_remoterun__get_env_var("DKU_BACKEND_PORT")
	if(is.null(backendPort) || backendPort=="") {
        stop("DKU_BACKEND_PORT isn't defined")
	}
	getSettingsUrl = dku_intercom__get_jek_or_backend_url("/get-dss-settings")
    resp = POST(getSettingsUrl, encode="form", dku__get_auth_headers(), dku_intercom__get_httr_config())
    settings <- content(resp)
	return(settings)
}

#' In a R custom recipe, retrieve the global configuration of the 
#' plugin containing it, as a dictionary
#'
#' Please see documentation about how to write custom recipes
#'
#' @export
dkuPluginConfig <- function(){
	rSpec <- dku_remoterun__get_env_var("DKU_CUSTOM_RECIPE_PLUGIN_CONFIG")
	return(RJSONIO::fromJSON(rSpec))
}

#' In a R custom recipe, retrieve the path of the plugin resource folder
#'
#' Please see documentation about how to write custom recipes
#'
#' @export
dkuCustomRecipeResource <- function(){
	return(dku_remoterun__get_env_var("DKU_CUSTOM_RESOURCE_FOLDER"))
}
