(function () {
    'use strict';

    const app = angular.module('dataiku.admin.stories_themes', []);

    app.controller('StoriesThemesController', function ($scope, $timeout, DataikuAPI) {
        // Check that Stories has been enabled first
        $scope.checkDatastoryIntegration = function () {
            DataikuAPI.admin.datastory.check().success(function (data) {
                $scope.datastoryIntegrationCheckResult = data;

            }).error(setErrorInScope.bind($scope));
        };

        $scope.checkDatastoryIntegration();

        // Sync with GeneralSettings
        $scope.handleThemeDefaultIdChange = (themeId) => {
            $timeout(() => {
                $scope.generalSettings.dataikuStoriesSettings.themeDefaultId = themeId;
            });
        };
    });
}());
