(function () {
'use strict';

    const app = angular.module('dataiku.catalog');

    app.controller('ExternalTableSchemaController', function ($scope, $filter, _SummaryHelper, $element, $stateParams, DataikuAPI, Debounce) {
        _SummaryHelper.addEditBehaviour($scope, $element);

        $scope.query = {columnFilter: ""};
        $scope.$watch('query.columnFilter',
            Debounce().withDelay(10, 200).withScope($scope).wrap(function (nv) {
                if ($scope.summary) {
                    $scope.columnFiltered = $filter('filter')($scope.summary.table.columns, nv);
                }
            }));

        $scope.selectColumn = function (column) {
            $scope.selectedColumn = column;
            $scope.selectedColumn.comment = $scope.selectedColumn.remarks
            $scope.object = $scope.selectedColumn;
        };

        function onColumnUpdated() {
            const updatedColumn = $scope.summary.table.columns.find(col => col.name === $scope.selectedColumn.name);
            updatedColumn.remarks = $scope.selectedColumn.comment;
            $scope.$emit('summaryUpdated', $scope.summary);
        }

        $scope.$on("objectSummaryEdited", function () {
            $scope.saveExternalTable($scope.tableKey, {description: $scope.summary.table.description, tags : $scope.summary.table.tags},
                $scope.selectedColumn, $scope.summary.table.remarks, onColumnUpdated)
        });

        // autofocus selected column field when passed into the url
        if ($stateParams.selectedColumn && $scope.summary) {
            const selectedColumnName = $stateParams.selectedColumn;
            const selectedColumn = $scope.summary.table.columns.find(col => col.name === selectedColumnName)
            if (selectedColumn) {
                $scope.selectColumn(selectedColumn);
                $scope.startFieldEdit('comment');
            }
        }

        function refreshSummary() {
            DataikuAPI.externalTable.summary($scope.tableKey).success(function (data) {
                $scope.summary = data;
                $scope.columnFiltered = $filter('filter')($scope.summary.table.columns, $scope.query.columnFilter);
            }).error(setErrorInScope.bind($scope));
        }
        refreshSummary();
    });

    app.controller('ExternalTableController', function ($scope,$rootScope, $injector, $stateParams, $route, DataikuAPI, $location,
                                                        $compile, $state, $q, CreateModalFromTemplate, $filter, WT1, $timeout, TopNav, DatasetsService,
                                                        $controller, StateUtils, CatalogUtils, Navigator, DashboardUtils, ActivityIndicator,TaggingService) {
        $rootScope.activeProjectTagColor = TaggingService.getTagColor;

        function emptyToNull(string) {
            return string && string.length ? string : null;
        }

        $scope.tableKey = {
            connection: emptyToNull($stateParams.connection),
            catalog: emptyToNull($stateParams.catalog),
            schema: emptyToNull($stateParams.schema),
            table: emptyToNull($stateParams.table)
        };
        $scope.tableKeyJson = JSON.stringify($scope.tableKey);

        $scope.import = function () {
            CreateModalFromTemplate("/templates/datasets/tables-import-project-selection-modal.html", $scope, "TablesImportProjectSelectionModalController");
        };
        $scope.getImportData = function(){
            return {
                workflowType : "KEYS",
                tableKeys : [$scope.summary.table.key]
            };
        }

        $scope.saveExternalTable = function(tableKey, dssMetadata, updatedColumn, tableRemarks, refreshCallback) {
            DataikuAPI.externalTable.save(tableKey, dssMetadata, updatedColumn, tableRemarks).success(function (data) {
                if (data.error && data.messages.length > 0) {
                    ActivityIndicator.error(data.messages[0].message, 5000);
                } else {
                    ActivityIndicator.success("Saved!");
                }
                refreshCallback();
            }).error(setErrorInScope.bind($scope));
        }

        $scope.$on('summaryUpdated', function(event, data) {
            $scope.summary = data;
            $scope.object = $scope.summary.table;
            $scope.dataSchema = $scope.summary.table.columns;
        });

        $scope.$on("objectSummaryEdited", function () {
            // we have the same event listener on the schema handling page (child controller)
            if ($state.current.name === "external-table.schema") {
                return;
            }

           $scope.saveExternalTable($scope.tableKey, {description: $scope.summary.table.description, tags : $scope.summary.table.tags},
               null, $scope.summary.table.remarks, () => {})
        });

        $scope.reloadSample = function () {
            DataikuAPI.externalTable.sample($scope.tableKey).success(data => {
                $scope.sample = data;
                $scope.sampleColumnsWidths = Array.from(Array($scope.sample.columns.length).fill(0));
                $scope.sample.rows.forEach((r, rownum) => {
                    r.forEach((e, i) => {
                        let l = Math.max($scope.sample.columns[i].name.length, e && e.length || 0)*8+10;
                        $scope.sampleColumnsWidths[i] = Math.max($scope.sampleColumnsWidths[i], l);
                    });
                    return r;
                });
                $scope.sampleColumnsWidths = $scope.sampleColumnsWidths.map(e => e);
                $scope.schema = {
                    "schema": $scope.sample.querySchema
                };
            }).error(setErrorInScope.bind($scope));
        };

        function refreshSummary() {
            DataikuAPI.externalTable.summary($scope.tableKey).success(function (data) {
                $scope.summary = data;
                $scope.object = $scope.summary.table;
                $scope.dataSchema = $scope.summary.table.columns;

                $scope.grouppedDSSItems = [];
                if ($scope.summary.dssItems) {
                    $scope.summary.dssItems.projects.forEach(function (project) {
                        project.datasets.forEach(function (dataset) {
                            $scope.grouppedDSSItems.push({dataset: dataset, project: project, recipes: dataset.recipes})
                        })
                    });
                }
            }).error(setErrorInScope.bind($scope));
        }

        TaggingService.fetchGlobalTags();
        TopNav.setLocation(TopNav.DSS_HOME, "catalog");
        refreshSummary();
    });


    app.directive('externalTableSummary', function (_SummaryHelper) {
        return {
            link: function ($scope, element, attrs) {
                _SummaryHelper.addEditBehaviour($scope, element);
            },
            templateUrl: '/templates/catalog/external-table/summary.html'
        };
    });
})();