(function() {
    'use strict';

    /**
     * <number-formatting-subform
     *     multiplier="multiplier"
     *     decimalPlaces="decimalPlaces"
     *     prefix="prefix"
     *     suffix="suffix"
     *     computeMode="computeMode">
     * </number-formatting-subform>
     *
     * @param { string }                                                        multiplier
     * @param { number }                                                        decimalPlaces
     * @param { string }                                                        prefix
     * @param { string }                                                        suffix
     * @param { com.dataiku.dip.pivot.backend.model.Aggregation.ComputeMode }   computeMode
     */
    angular.module('dataiku.charts').component('numberFormattingSubform', {
        templateUrl: '/static/dataiku/js/simple_report/components/number-formatting-subform/number-formatting-subform.component.html',
        bindings: {
            shouldFormatInPercentage: '=',
            multiplier: '=',
            decimalPlaces: '=',
            hideTrailingZeros: '=',
            digitGrouping: '=',
            useParenthesesForNegativeValues: '=',
            prefix: '=',
            suffix: '=',
            computeMode: '<?'
        },
        controller: function(ChartsStaticData) {
            const ctrl = this;
            ctrl.availableMultipliers = ChartsStaticData.availableMultipliers;
            ctrl.availableDigitGrouping = ChartsStaticData.availableDigitGrouping;

            ctrl.isComputedAsPercentage = () => {
                return ctrl.computeMode === 'PERCENTAGE' || ctrl.computeMode === 'CUMULATIVE_PERCENTAGE';
            };

            ctrl.$onInit = function() {
                ctrl.multiplier = ctrl.multiplier || 'Auto';
            };
        }
    });
})();
