(function(){
    "use strict";

    const searchNotebookInitModalIndices = {
        bindings : {
            indicesScope: "<",
            connection: "<",
            cell: "<"
        },
        require: {
            apiErrorContext: "^apiErrorContext"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-init-modal-indices/search-notebook-init-modal-indices.component.html",
        controller: function($scope, DataikuAPI, MonoFuture, $stateParams) {
            const $ctrl = this;
            $scope.selection = {orderReversed: false, filterQuery: {}, orderQuery: "name", selection: [] };  // directives uses $scope...

            $ctrl.$onInit = () => {
                if (!$ctrl.indicesScope.indices) {
                    loadIndices();
                }
            };

            const loadIndices = () => {
                const endPoint = DataikuAPI.connections.listElasticSearchMassImportIndices;
                MonoFuture($ctrl).wrap(endPoint)($ctrl.connection).success((data) => {
                    data.result.tables.forEach( e => e.indexCount = (e.aliasesOrIndices && e.type === "ALIAS" && e.aliasesOrIndices.length) || 0);
                    if ($ctrl.cell && $ctrl.cell.searchScope.indices) {
                        for (const index of data.result.tables) {
                            for (const selectedIndex of $ctrl.cell.searchScope.indices) {
                                if (index.name === selectedIndex) {
                                    index.$selected = true;
                                }
                            }
                        }
                    }
                    $ctrl.indicesScope.indices = data.result.tables;
                })
                .error($ctrl.apiErrorContext.setError);
            };

            $ctrl.sortBy = function (columnName) {
                if ($scope.selection.orderQuery == columnName) {
                    $scope.selection.orderReversed = !$scope.selection.orderReversed;
                } else {
                    $scope.selection.orderQuery = columnName;
                }
            };

            $ctrl.isSortedBy = function (columnName, reversed) {
                if (!$scope.selection || !$scope.selection.orderQuery) {
                    return false;
                }
                return $scope.selection.orderQuery == columnName && $scope.selection.orderReversed === reversed;
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookInitModalIndices", searchNotebookInitModalIndices);
})();