from typing import List
from dataiku.eda.types import Literal

from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.filtering.filter import Filter
from dataiku.eda.types import AndFilterModel


class AndFilter(Filter):
    def __init__(self, filters: List[Filter]):
        self.filters = filters

    @staticmethod
    def get_type() -> Literal["and"]:
        return "and"

    @staticmethod
    def build(params: AndFilterModel) -> 'AndFilter':
        return AndFilter([Filter.build(f_params) for f_params in params['filters']])

    def apply(self, idf: ImmutableDataFrame, inverse: bool = False) -> ImmutableDataFrame:
        if inverse:
            current = idf[[]]
            for f in self.filters:
                current |= f.apply(idf, True)
        else:
            current = idf
            for f in self.filters:
                current &= f.apply(idf, False)

        return current

    def serialize(self) -> AndFilterModel:
        return {"type": self.get_type(), "filters": [f.serialize() for f in self.filters]}
