/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.GsonBuilder;
import com.dataiku.scoring.pipelines.Result;

public class OverrideInfo {
    public final String appliedRule;
    public final boolean ruleMatched;
    public final Result.RawResult rawResult;
    public final Boolean predictionChanged;
    public final RulePolicy rulePolicy;
    private static final Gson gson = new GsonBuilder().create();

    private OverrideInfo(String appliedRule, Boolean predictionChanged, RulePolicy rulePolicy, Result.RawResult rawResult) {
        this.appliedRule = appliedRule;
        this.predictionChanged = predictionChanged;
        this.rawResult = rawResult;
        this.rulePolicy = rulePolicy;
        this.ruleMatched = appliedRule != null;
    }

    public OverrideInfo(String appliedRule, Boolean predictionChanged, Result.RawResult rawResult) {
        this(appliedRule, predictionChanged, RulePolicy.ENFORCED, rawResult);
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static OverrideInfo noMatch() {
        return new OverrideInfo(null, null, null, null);
    }

    public static OverrideInfo declined(String appliedRule, Result.RawResult rawResult) {
        return new OverrideInfo(appliedRule, true, RulePolicy.DECLINED, rawResult);
    }

    public static enum RulePolicy {
        DECLINED,
        ENFORCED;

    }
}

