/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestResponse;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.connection.RequestBuilder;
import net.snowflake.ingest.connection.ServiceResponseHandler;
import net.snowflake.ingest.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.ingest.internal.apache.http.client.methods.HttpGet;
import net.snowflake.ingest.internal.apache.http.client.methods.HttpPost;
import net.snowflake.ingest.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.ingest.utils.HttpUtil;
import net.snowflake.ingest.utils.StagedFileWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIngestManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleIngestManager.class);
    private CloseableHttpClient httpClient;
    private String account;
    private String user;
    private String pipe;
    private KeyPair keyPair;
    private final RequestBuilder builder;

    @Deprecated
    public SimpleIngestManager(String account, String user, String pipe, KeyPair keyPair) {
        this.init(account, user, pipe, keyPair);
        this.builder = new RequestBuilder(account, user, keyPair);
    }

    @Deprecated
    public SimpleIngestManager(String account, String user, String pipe, KeyPair keyPair, String schemeName, String hostName, int port) {
        this.init(account, user, pipe, keyPair);
        this.builder = new RequestBuilder(account, user, keyPair, schemeName, hostName, port);
    }

    public SimpleIngestManager(String account, String user, String pipe, PrivateKey privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyPair keyPair = SimpleIngestManager.createKeyPairFromPrivateKey(privateKey);
        this.init(account, user, pipe, keyPair);
        this.builder = new RequestBuilder(account, user, keyPair);
    }

    public SimpleIngestManager(String account, String user, String pipe, String hostName, KeyPair keyPair, String userAgentSuffix) {
        this.init(account, user, pipe, keyPair);
        this.builder = new RequestBuilder(account, user, hostName, keyPair, userAgentSuffix);
    }

    public SimpleIngestManager(String account, String user, String pipe, PrivateKey privateKey, String schemeName, String hostName, int port) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyPair keyPair = SimpleIngestManager.createKeyPairFromPrivateKey(privateKey);
        this.init(account, user, pipe, keyPair);
        this.builder = new RequestBuilder(account, user, keyPair, schemeName, hostName, port);
    }

    public SimpleIngestManager(String account, String user, String pipe, PrivateKey privateKey, String schemeName, String hostName, int port, String userAgentSuffix) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyPair keyPair = SimpleIngestManager.createKeyPairFromPrivateKey(privateKey);
        this.init(account, user, pipe, keyPair);
        this.builder = new RequestBuilder(account, user, keyPair, schemeName, hostName, port, userAgentSuffix);
    }

    private void init(String account, String user, String pipe, KeyPair keyPair) {
        this.account = account;
        this.user = user;
        this.pipe = pipe;
        this.keyPair = keyPair;
        this.httpClient = HttpUtil.getHttpClient();
    }

    public static KeyPair createKeyPairFromPrivateKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            throw new IllegalArgumentException("Input private key is not a RSA private key");
        }
        KeyFactory kf = KeyFactory.getInstance("RSA");
        RSAPrivateCrtKey privk = (RSAPrivateCrtKey)privateKey;
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privk.getModulus(), privk.getPublicExponent());
        PublicKey publicK = kf.generatePublic(publicKeySpec);
        return new KeyPair(publicK, privateKey);
    }

    public String getAccount() {
        return this.account;
    }

    public String getUser() {
        return this.user;
    }

    public String getPipe() {
        return this.pipe;
    }

    public static List<StagedFileWrapper> wrapFilepaths(Set<String> filenames) {
        if (filenames == null) {
            throw new IllegalArgumentException();
        }
        return filenames.parallelStream().map(fname -> new StagedFileWrapper((String)fname, null)).collect(Collectors.toList());
    }

    public IngestResponse ingestFile(StagedFileWrapper file, UUID requestId) throws URISyntaxException, IOException, Exception {
        return this.ingestFiles(Collections.singletonList(file), requestId);
    }

    public IngestResponse ingestFile(StagedFileWrapper file, UUID requestId, boolean showSkippedFiles) throws URISyntaxException, IOException, Exception {
        return this.ingestFiles(Collections.singletonList(file), requestId, showSkippedFiles);
    }

    public IngestResponse ingestFiles(List<StagedFileWrapper> files, UUID requestId) throws URISyntaxException, IOException, IngestResponseException {
        return this.ingestFiles(files, requestId, false);
    }

    public IngestResponse ingestFiles(List<StagedFileWrapper> files, UUID requestId, boolean showSkippedFiles) throws URISyntaxException, IOException, IngestResponseException {
        UUID request = requestId == null ? UUID.randomUUID() : requestId;
        LOGGER.info("Sending Request UUID - {}", (Object)request);
        HttpPost httpPostForIngestFile = this.builder.generateInsertRequest(request, this.pipe, files, showSkippedFiles);
        try (CloseableHttpResponse response = this.httpClient.execute(httpPostForIngestFile);){
            LOGGER.info("Attempting to unmarshall insert response - {}", (Object)response);
            IngestResponse ingestResponse = ServiceResponseHandler.unmarshallIngestResponse(response);
            return ingestResponse;
        }
    }

    public HistoryResponse getHistory(UUID requestId, Integer recentSeconds, String beginMark) throws URISyntaxException, IOException, IngestResponseException {
        if (requestId == null) {
            requestId = UUID.randomUUID();
        }
        HttpGet httpGetHistory = this.builder.generateHistoryRequest(requestId, this.pipe, recentSeconds, beginMark);
        try (CloseableHttpResponse response = this.httpClient.execute(httpGetHistory);){
            LOGGER.info("Attempting to unmarshall history response - {}", (Object)response);
            HistoryResponse historyResponse = ServiceResponseHandler.unmarshallHistoryResponse(response);
            return historyResponse;
        }
    }

    public HistoryRangeResponse getHistoryRange(UUID requestId, String startTimeInclusive, String endTimeExclusive) throws URISyntaxException, IOException, IngestResponseException {
        if (requestId == null) {
            requestId = UUID.randomUUID();
        }
        try (CloseableHttpResponse response = this.httpClient.execute(this.builder.generateHistoryRangeRequest(requestId, this.pipe, startTimeInclusive, endTimeExclusive));){
            LOGGER.info("Attempting to unmarshall history range response - {}", (Object)response);
            HistoryRangeResponse historyRangeResponse = ServiceResponseHandler.unmarshallHistoryRangeResponse(response);
            return historyRangeResponse;
        }
    }

    @Override
    public void close() {
        this.builder.closeResources();
        HttpUtil.shutdownHttpConnectionManagerDaemonThread();
    }

    public RequestBuilder getRequestBuilder() {
        return this.builder;
    }

    public static class Builder {
        private String account;
        private String user;
        private String pipe;
        private KeyPair keypair;
        private String userAgentSuffix;
        private String hostName;
        private PrivateKey privateKey;

        public String getAccount() {
            return this.account;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public String getUser() {
            return this.user;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public String getPipe() {
            return this.pipe;
        }

        public Builder setPipe(String pipe) {
            this.pipe = pipe;
            return this;
        }

        public KeyPair getKeypair() {
            return this.keypair;
        }

        public Builder setKeypair(KeyPair keypair) {
            this.keypair = keypair;
            return this;
        }

        public String getUserAgentSuffix() {
            return this.userAgentSuffix;
        }

        public Builder setUserAgentSuffix(String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public String getHostName() {
            return this.hostName;
        }

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public SimpleIngestManager build() {
            if (Strings.isNullOrEmpty(this.hostName)) {
                return new SimpleIngestManager(this.account, this.user, this.pipe, "snowflakecomputing.com", this.keypair, this.userAgentSuffix);
            }
            return new SimpleIngestManager(this.account, this.user, this.pipe, this.hostName, this.keypair, this.userAgentSuffix);
        }
    }
}

