/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class StringOutputFormatter
implements OutputFormatter {
    protected WarningsContext warningsContext = new WarningsContext();
    private String charset;
    private BufferedWriter bwr;

    public StringOutputFormatter(String charset) {
        this.charset = charset;
    }

    @Override
    public void header(ColumnFactory cf, OutputStream os) throws Exception {
        assert (this.charset != null);
        assert (os != null);
        this.bwr = new BufferedWriter(new OutputStreamWriter(os, this.charset));
        this.header(cf, this.bwr);
    }

    public abstract void header(ColumnFactory var1, Writer var2) throws Exception;

    @Override
    public void format(Row row, ColumnFactory cf, OutputStream os) throws Exception {
        this.format(row, cf, this.bwr);
    }

    public abstract void format(Row var1, ColumnFactory var2, Writer var3) throws Exception;

    @Override
    public void footer(ColumnFactory cf, OutputStream os) throws Exception {
        if (this.bwr != null) {
            this.footer(cf, this.bwr);
            this.bwr.close();
        }
    }

    public abstract void footer(ColumnFactory var1, Writer var2) throws Exception;

    @Override
    public void setWarningsContext(WarningsContext warningsContext) {
        this.warningsContext = warningsContext;
    }
}

