/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeCRUDService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.savedmodels.SavedModelsAgentsService;
import com.dataiku.dip.savedmodels.SavedModelsRetrievalAugmentedLlmService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class PublicAPILLMMeshCRUDController
extends PublicAPIControllerBase {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private RetrievableKnowledgeCRUDService retrievableKnowledgeService;
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private SavedModelsRetrievalAugmentedLlmService augmentedLlmService;
    @Autowired
    private SavedModelsAgentsService agentsService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;

    @AuditedCall(value={"msgType", "llm-mesh-knowledge-banks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/knowledge-banks"}, method={RequestMethod.GET})
    @ResponseBody
    public List<RetrievableKnowledge> listRetrievableKnowledges(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List list = this.retrievableKnowledgeDAO.listUnsafe(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "llm-mesh-knowledge-banks-get", "projectKey", "${projectKey}", "knowledgeBankId", "${knowledgeBankId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/knowledge-banks/{knowledgeBankId}"}, method={RequestMethod.GET})
    @ResponseBody
    public RetrievableKnowledge getRetrievableKnowledge(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String knowledgeBankId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            RetrievableKnowledge retrievableKnowledge = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatoryUnsafe(projectKey, knowledgeBankId);
            return retrievableKnowledge;
        }
    }

    @AuditedCall(value={"msgType", "llm-mesh-knowledge-banks-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/knowledge-banks/"}, method={RequestMethod.POST})
    @ResponseBody
    public RetrievableKnowledge createRetrievableKnowledge(HttpServletRequest req, @PathVariable String projectKey, @RequestBody JsonObject json) throws IOException, CodedException, DKUSecurityException {
        CodeEnvSelection envSelection;
        RetrievableKnowledge rk;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        try {
            rk = (RetrievableKnowledge)JSON.parse((JsonElement)json, RetrievableKnowledge.class);
            envSelection = (CodeEnvSelection)JSON.parse((JsonElement)json.get("envSelection"), CodeEnvSelection.class);
        }
        catch (Exception e) {
            throw new DKUControllerBase.MalformedRequestException(e.getMessage(), (Throwable)e);
        }
        this.require(StringUtils.isNotBlank((CharSequence)rk.name), "Required field 'name' is missing.");
        this.require(rk.vectorStoreType != null, "Required field 'vectorStoreType' is missing.");
        this.require(StringUtils.isNotBlank((CharSequence)rk.embeddingLLMId), "Required field 'embeddingLLMId' is missing.");
        if (rk.vectorStoreType.hasConnection) {
            this.require(StringUtils.isNotBlank((CharSequence)rk.connection), "Required field 'connection' is missing.");
        }
        rk.projectKey = projectKey;
        rk.id = SecretKeyGenerator.generate((int)8);
        if (envSelection == null) {
            String defaultEnvName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.getDefaultRetrievableKnowledgeCodeEnv();
            if (!DSSInternalCodeEnvsService.getCodeEnvName((DSSInternalCodeEnvsService.DSSInternalCodeEnvType)DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV).equals(defaultEnvName) || this.dssInternalCodeEnvsService.getCodeEnv_NT(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV).isPresent()) {
                rk.envSelection = CodeEnvSelection.explicitEnv((String)defaultEnvName);
            }
        }
        if (rk.vectorStoreType.hasIndex) {
            rk.indexName = "${projectKey}_kb_" + rk.id;
        }
        if (rk.vectorStoreType == RetrievableKnowledge.VectorStoreType.PINECONE) {
            this.require(rk.pineconeIndexName != null, "Field 'pineconeIndexName' should be set when 'vectorStoreType' is set to PINECONE");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            RetrievableKnowledge savedRk = this.retrievableKnowledgeService.save(rk, false);
            this.neverBuiltComputablesCacheService.add(new TaggableObjectsService.TaggableObjectRef((TaggableObjectsService.TaggableObject)savedRk));
            t.commit("Saved knowledge bank %s (id: %s)".formatted(savedRk.getFullId(), savedRk.getId()));
            RetrievableKnowledge retrievableKnowledge = savedRk;
            return retrievableKnowledge;
        }
    }

    @AuditedCall(value={"msgType", "llm-mesh-knowledge-banks-update", "projectKey", "${projectKey}", "knowledgeBankId", "${knowledgeBankId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/knowledge-banks/{knowledgeBankId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public RetrievableKnowledge updateRetrievableKnowledge(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String knowledgeBankId, @RequestBody RetrievableKnowledge rk) throws IOException, CodedException, DKUSecurityException {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            RetrievableKnowledge existing = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatoryUnsafe(projectKey, knowledgeBankId);
            this.require(rk.projectKey == null || existing.projectKey.equals(rk.projectKey), "Field 'projectKey' cannot be updated");
            this.require(rk.id == null || existing.id.equals(rk.id), "Field 'id' cannot be updated");
            rk.projectKey = existing.projectKey;
            rk.id = existing.id;
            if (rk.vectorStoreType == null) {
                rk.vectorStoreType = existing.vectorStoreType;
            }
            if (rk.vectorStoreType.hasConnection) {
                if (StringUtils.isBlank((CharSequence)rk.connection)) {
                    rk.connection = existing.connection;
                }
                this.require(StringUtils.isNotBlank((CharSequence)rk.connection), "Required field 'connection' is missing.");
            }
            if (rk.vectorStoreType.hasIndex) {
                rk.indexName = "${projectKey}_kb_" + rk.id;
            }
            if (rk.vectorStoreType == RetrievableKnowledge.VectorStoreType.PINECONE) {
                this.require(rk.pineconeIndexName != null, "Field 'pineconeIndexName' should be set when 'vectorStoreType' is set to PINECONE");
            }
            this.retrievableKnowledgeService.save(rk, false);
            t.commit("Updated knowledge bank " + rk.projectKey + "." + rk.name + " (id: " + rk.id + ")");
            RetrievableKnowledge retrievableKnowledge = rk;
            return retrievableKnowledge;
        }
    }

    @AuditedCall(value={"msgType", "llm-mesh-knowledge-banks-delete", "projectKey", "${projectKey}", "knowledgeBankId", "${knowledgeBankId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/knowledge-banks/{knowledgeBankId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRetrievableKnowledge(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String knowledgeBankId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatoryUnsafe(projectKey, knowledgeBankId);
            this.retrievableKnowledgeService.delete(authCtx, projectKey, knowledgeBankId, new HashSet());
            this.flowGraphService.invalidateCache(projectKey);
            t.commit("Deleted knowledge bank %s (id: %s)".formatted(rk.getFullId(), rk.getId()));
        }
    }

    @AuditedCall(value={"msgType", "retrieval-augmented-llms-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/retrieval-augmented-llms"}, method={RequestMethod.GET})
    @ResponseBody
    public List<RetrievalAugmentedLLMDTO> listRetrievalAugmentedLLMs(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List<RetrievalAugmentedLLMDTO> list = this.savedModelsDAO.listUnsafe(projectKey).stream().filter(sm -> sm.savedModelType == SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM).map(RetrievalAugmentedLLMDTO::new).toList();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "retrieval-augmented-llm-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/retrieval-augmented-llms"}, method={RequestMethod.POST})
    @ResponseBody
    public Id createRetrievalAugmentedLLM(HttpServletRequest req, @PathVariable String projectKey, @RequestBody ProtoRetrievalAugmentedLLM proto) throws Exception, CodedException, DKUSecurityException {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        try {
            SavedModel sm = this.augmentedLlmService.createRetrievalAugmentedLlmAndVersion(authCtx, projectKey, proto.name, proto.knowledgeBankRef, proto.llmId);
            this.auditTrailService.generic("retrieval-augmented-llm-create").with("projectKey", projectKey).with("modelId", sm.id).with("name", proto.name).with("type", SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM.toString()).emit();
            return new Id(sm.id);
        }
        catch (Exception e) {
            this.auditTrailService.failure("retrieval-augmented-llm-create", (Throwable)e).with("projectKey", projectKey).with("name", proto.name).with("type", SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM.toString()).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "retrieval-augmented-llm-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/retrieval-augmented-llms/{retrievalAugmentedLLMId}"}, method={RequestMethod.GET})
    @ResponseBody
    public RetrievalAugmentedLLMDTO getRetrievalAugmentedLLM(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String retrievalAugmentedLLMId) throws Exception, CodedException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, retrievalAugmentedLLMId);
            if (sm.savedModelType != SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM) {
                throw new IllegalArgumentException("Not a retrieval-augmented LLM");
            }
            RetrievalAugmentedLLMDTO retrievalAugmentedLLMDTO = new RetrievalAugmentedLLMDTO(sm);
            return retrievalAugmentedLLMDTO;
        }
    }

    @AuditedCall(value={"msgType", "retrieval-augmented-llm-save", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/retrieval-augmented-llms/{retrievalAugmentedLLMId}"}, method={RequestMethod.PUT})
    public void saveRetrievalAugmentedLLM(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String retrievalAugmentedLLMId, @RequestBody RetrievalAugmentedLLMDTO llmDTO) throws Exception, CodedException, DKUSecurityException {
        try (RWTransaction rwt = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(rwt.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, retrievalAugmentedLLMId);
            if (sm.savedModelType != SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM) {
                throw new IllegalArgumentException("Not a retrieval-augmented LLM");
            }
            sm.inlineVersions = llmDTO.versions;
            this.savedModelsDAO.save(sm);
            rwt.commit("Saved retrieval-augmented LLM " + retrievalAugmentedLLMId);
        }
    }

    @AuditedCall(value={"msgType", "retrieval-augmented-llm-delete", "projectKey", "${projectKey}", "retrievalAugmentedLLMId", "${retrievalAugmentedLLMId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/retrieval-augmented-llms/{retrievalAugmentedLLMId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRetrievalAugmentedLLM(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String retrievalAugmentedLLMId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.savedModelsDAO.getMandatoryUnsafe(projectKey, retrievalAugmentedLLMId);
            this.savedModelsDAO.delete(projectKey, retrievalAugmentedLLMId);
            this.flowGraphService.invalidateCache(projectKey);
            t.commit("Deleted retrieval-augmented-llm " + retrievalAugmentedLLMId);
        }
    }

    @AuditedCall(value={"msgType", "agents-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AgentDTO> listAgents(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List<AgentDTO> list = this.savedModelsDAO.listUnsafe(projectKey).stream().filter(sm -> sm.savedModelType.isAgent()).map(AgentDTO::new).toList();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "agent-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents"}, method={RequestMethod.POST})
    @ResponseBody
    public Id createAgent(HttpServletRequest req, @PathVariable String projectKey, @RequestBody ProtoAgent proto) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        try {
            SavedModel sm = null;
            switch (proto.type) {
                case PYTHON_AGENT: {
                    sm = this.agentsService.createAgent(authCtx, projectKey, proto.type, proto.name, proto.zoneId);
                    SavedModel.SavedModelInlineVersion smiv = new SavedModel.SavedModelInlineVersion();
                    smiv.versionId = "v1";
                    smiv.creationTag = new VersionTag(authCtx.getIdentifier());
                    smiv.pythonAgentSettings = new SavedModel.PythonAgentSettings();
                    this.agentsService.createAgentVersion(authCtx, sm, smiv.versionId, smiv);
                    break;
                }
                case PLUGIN_AGENT: {
                    sm = this.agentsService.createPluginAgentAndVersion(authCtx, projectKey, proto.pluginAgentType, proto.name, proto.zoneId);
                    break;
                }
                case TOOLS_USING_AGENT: {
                    sm = this.agentsService.createToolsUsingAgentAndVersion(authCtx, projectKey, proto.name, proto.zoneId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid agent type");
                }
            }
            this.auditTrailService.generic("agent-create").with("projectKey", projectKey).with("id", sm.id).with("name", proto.name).with("type", proto.type.toString()).emit();
            return new Id(sm.id);
        }
        catch (Exception e) {
            this.auditTrailService.failure("agent-create", (Throwable)e).with("projectKey", projectKey).with("name", proto.name).with("type", proto.type.toString()).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "agent-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AgentDTO getAgent(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, agentId);
            if (!sm.savedModelType.isAgent()) {
                throw new IllegalArgumentException("Not an agent");
            }
            AgentDTO agentDTO = new AgentDTO(sm);
            return agentDTO;
        }
    }

    @AuditedCall(value={"msgType", "agent-save", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}"}, method={RequestMethod.PUT})
    public void saveAgent(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentId, @RequestBody AgentDTO agentDTO) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(rwt.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, agentId);
            if (!sm.savedModelType.isAgent()) {
                throw new IllegalArgumentException("Not an agent");
            }
            sm.inlineVersions = agentDTO.versions;
            this.savedModelsDAO.save(sm);
            rwt.commit("Saved agent  " + agentId);
        }
    }

    @AuditedCall(value={"msgType", "agent-delete", "projectKey", "${projectKey}", "agentId", "${agentId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAgent(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String agentId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.savedModelsDAO.getMandatoryUnsafe(projectKey, agentId);
            this.savedModelsDAO.delete(projectKey, agentId);
            this.flowGraphService.invalidateCache(projectKey);
            t.commit("Deleted agent " + agentId);
        }
    }

    class ProtoRetrievalAugmentedLLM {
        String name;
        String llmId;
        String knowledgeBankRef;

        ProtoRetrievalAugmentedLLM() {
        }
    }

    static class RetrievalAugmentedLLMDTO
    extends FakeTaggableObject {
        public String activeVersion;
        public List<SavedModel.SavedModelInlineVersion> versions = new ArrayList<SavedModel.SavedModelInlineVersion>();

        RetrievalAugmentedLLMDTO(SavedModel sm) {
            this.projectKey = sm.projectKey;
            this.id = sm.id;
            this.activeVersion = sm.activeVersion;
            this.versions = sm.inlineVersions;
        }
    }

    class ProtoAgent {
        String name;
        SavedModel.SavedModelType type;
        String pluginAgentType;
        String zoneId;

        ProtoAgent() {
        }
    }

    static class AgentDTO
    extends FakeTaggableObject {
        public String activeVersion;
        public String name;
        public SavedModel.SavedModelType type;
        public List<SavedModel.SavedModelInlineVersion> versions = new ArrayList<SavedModel.SavedModelInlineVersion>();

        AgentDTO(SavedModel sm) {
            this.projectKey = sm.projectKey;
            this.id = sm.id;
            this.name = sm.name;
            this.type = sm.savedModelType;
            this.activeVersion = sm.activeVersion;
            this.versions = sm.inlineVersions;
        }
    }

    private static abstract class FakeTaggableObject
    extends TaggableObjectsService.TaggableObject {
        public String projectKey;
        public String id;

        private FakeTaggableObject() {
        }

        public ITaggingService.TaggableType getTaggableType() {
            throw new Error("this is a fake TO");
        }

        public String getProjectKey() {
            throw new Error("this is a fake TO");
        }

        public String getId() {
            throw new Error("this is a fake TO");
        }

        public void setProjectKey(String projectKey) {
        }

        public void setId(String id) {
            throw new Error("this is a fake TO");
        }

        public String getDisplayName() {
            throw new Error("this is a fake TO");
        }
    }
}

