/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.docgen.ModelDocumentGenerationService;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.SMVersionHeader;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.LLMModelReader;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.llm.LLMModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesResiduals;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.externalml.mlflow.MLflowModelOperationsService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.savedmodels.SavedModelsAgentsService;
import com.dataiku.dip.savedmodels.SavedModelsService;
import com.dataiku.dip.savedmodels.proxymodels.ProxyModelConfiguration;
import com.dataiku.dip.savedmodels.proxymodelversions.ProxyModelVersionConfiguration;
import com.dataiku.dip.scoring.exports.ExportAndRegisterMLflowModelInFutureThread;
import com.dataiku.dip.scoring.exports.JarScoring;
import com.dataiku.dip.scoring.exports.MLflowScoring;
import com.dataiku.dip.scoring.exports.PMMLScoring;
import com.dataiku.dip.scoring.exports.PythonScoring;
import com.dataiku.dip.scoring.exports.ScoringExporter;
import com.dataiku.dip.scoring.exports.snowflake.SnowflakePermanentFunctionExportThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardService;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardSettings;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/savedmodels"})
public class PublicAPISavedModelsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private SavedModelsService savedModelsService;
    @Autowired
    private SavedModelsAgentsService savedModelsAgentsService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private PredictionSMMgmtService psmmService;
    @Autowired
    private ClusteringSMMgmtService csmmService;
    @Autowired
    private LLMSMMgmtService llmSMService;
    @Autowired
    private PredictionRecipesService predictionRecipesService;
    @Autowired
    private ClusteringRecipesService clusteringRecipesService;
    @Autowired
    private TaggableObjectsDeletionService taggableObjectsDeletionService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private ModelDocumentGenerationService modelDocumentGenerationService;
    @Autowired
    private MLflowModelOperationsService mlflowModelOperationsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeCodeEnvsService;
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeCodeEnvsService;
    @Autowired
    private AutomationBundlesService automationBundlesService;
    @Autowired
    private MonitoringWizardService monitoringWizardService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private LLMSMMgmtService llmSavedModelsService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.savedmodels.api");

    @AuditedCall(value={"msgType", "savedmodels-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SavedModel.SavedModelListItem> listJobs(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ArrayList ret = Lists.newArrayList();
            for (SavedModel sm : this.savedModelsDAO.list(projectKey)) {
                ret.add(new SavedModel.SavedModelListItem(sm));
            }
            ArrayList arrayList = ret;
            return arrayList;
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-get", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/{smId}"}, method={RequestMethod.GET})
    @ResponseBody
    public SavedModel getSavedModel(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            SavedModel savedModel = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
            return savedModel;
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-save-settings", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/{smId}"}, method={RequestMethod.PUT})
    public void save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId) throws Exception {
        SavedModel sm = (SavedModel)this.getRequestBodyAs(req, SavedModel.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
            sm.projectKey = projectKey;
            sm.id = smId;
            this.require(StringUtils.isNotBlank((String)sm.name), "Required field 'name' is empty.");
            this.savedModelsDAO.save(sm);
            t.commit("Updated settings of saved model " + sm.id);
        }
    }

    @ResponseBody
    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public PublicAPIControllerBase.ResponseMessageWithId create(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        ProtoExternalSavedModel pesm = (ProtoExternalSavedModel)this.getRequestBodyAs(req, ProtoExternalSavedModel.class);
        this.require(pesm.savedModelType != SavedModel.SavedModelType.DSS_MANAGED, "Cannot manually create DSS_MANAGED saved models. They can only be deployed from a ML task");
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getTicketOrKey(req);
                this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            }
            SavedModel sm = this.savedModelsService.createExternalSavedModel(authCtx, projectKey, pesm.savedModelType, pesm.predictionType, pesm.name, pesm.proxyModelConfiguration);
            this.auditTrailService.generic("savedmodel-create").with("projectKey", projectKey).with("modelId", sm.id).with("type", sm.savedModelType.toString()).emit();
            return new PublicAPIControllerBase.ResponseMessageWithId(sm.id, "Created external saved model " + sm.id);
        }
        catch (Exception e) {
            this.auditTrailService.failure("savedmodel-create", (Throwable)e).with("projectKey", projectKey).with("name", pesm.name).with("type", pesm.savedModelType.toString()).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-get-versions", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/{smId}/versions"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ModelVersionInfo> getVersions(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String smId) throws Exception {
        ClusteringSMMgmtService.ClusteringSMStatus smStatus;
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        switch (sm.getType()) {
            case PREDICTION: {
                PredictionSMMgmtService.PredictionSMStatus pSmStatus = this.psmmService.getStatus_NT(sm);
                return pSmStatus.versions.stream().map(ModelVersionInfo::fromPredictionVersionHeader).collect(Collectors.toList());
            }
            case CLUSTERING: {
                smStatus = this.csmmService.getStatus_NT(sm);
                break;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                smStatus = LLMSMMgmtService.getStatus_NT((SavedModel)sm);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown type %s", sm.getType()));
            }
        }
        return smStatus.versions.stream().map(ModelVersionInfo::fromVersionHeader).collect(Collectors.toList());
    }

    @AuditInline
    @RequestMapping(value={"/{smId}/versions/{versionId}"}, method={RequestMethod.POST})
    public void createVersion(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam(required=false, value="file") MultipartFile filePart, @RequestParam(required=false) String folderRef, @RequestParam(required=false) String path, @RequestParam(required=false) ProxyModelVersionConfiguration proxyModelVersionConfiguration, @RequestParam(required=false) String codeEnvName, @RequestParam(required=false) String containerExecConfigName, @RequestParam(defaultValue="0.5") double binaryClassificationThreshold, @RequestParam(required=false, defaultValue="true") boolean setActive) throws Exception {
        try {
            String resolvedCodeEnvName;
            SavedModel sm;
            AuthCtx authCtx;
            CodeEnvSelector selector = new CodeEnvSelector();
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
                sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
                if (sm.savedModelType == SavedModel.SavedModelType.MLFLOW_PYFUNC) {
                    if ("INHERIT".equals(codeEnvName)) {
                        resolvedCodeEnvName = selector.selectForPythonRecipe(projectKey, CodeEnvSelection.inherit());
                        if (StringUtils.isEmpty((String)resolvedCodeEnvName)) {
                            throw new IllegalArgumentException("Please specify a code environment or define a default code environment at the project or instance level.");
                        }
                    } else {
                        resolvedCodeEnvName = selector.selectForPythonRecipe(projectKey, CodeEnvSelection.explicitEnv((String)codeEnvName));
                    }
                } else if (sm.savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
                    resolvedCodeEnvName = DSSInternalCodeEnvsService.getCodeEnvName((DSSInternalCodeEnvsService.DSSInternalCodeEnvType)DSSInternalCodeEnvsService.DSSInternalCodeEnvType.PROXY_MODELS_CODE_ENV);
                } else {
                    throw new IllegalArgumentException("Unhandled saved model type " + String.valueOf(sm.savedModelType));
                }
                this.permissionsService.checkCodeEnvPrivileges(authCtx, CodeEnvModel.EnvLang.PYTHON, resolvedCodeEnvName, new Privileges.CodeEnvLevelPrivilegeType[]{Privileges.CodeEnvLevelPrivilegeType.USE});
            }
            this.checkMLflowProxyCodeEnvConfig(projectKey, codeEnvName, sm, resolvedCodeEnvName);
            if (sm.savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
                proxyModelVersionConfiguration.proxyModelConfiguration = sm.proxyModelConfiguration;
                this.savedModelsService.createProxySavedModelVersion_NT(authCtx, sm, projectKey, versionId, proxyModelVersionConfiguration, binaryClassificationThreshold, null, null);
            } else {
                ContainerExecSelection containerExecSelection = this.buildContainerExecSelection(containerExecConfigName);
                this.savedModelsService.createMLflowSavedModelVersion_NT(authCtx, sm, projectKey, versionId, filePart, folderRef, path, resolvedCodeEnvName, containerExecSelection, null, binaryClassificationThreshold, null, null);
            }
            if (setActive) {
                logger.info((Object)("Setting version " + versionId + " as active for saved model " + sm.id));
                t = this.transactionService.beginWriteForAPI(req);
                try {
                    sm = (SavedModel)this.savedModelsDAO.getMandatory(projectKey, smId);
                    this.psmmService.setActive(sm, versionId);
                    t.commit("Made version " + versionId + " of saved model " + sm.id + " active");
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            } else {
                logger.debug((Object)("Not setting version " + versionId + " as active for saved model " + sm.id));
            }
            this.auditTrailService.generic("savedmodel-version-create").with("projectKey", projectKey).with("modelId", sm.id).with("versionId", versionId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("savedmodel-version-create", (Throwable)e).with("projectKey", projectKey).with("modelId", smId).with("versionId", versionId).emit();
            throw e;
        }
    }

    private void checkMLflowProxyCodeEnvConfig(String projectKey, String codeEnvName, SavedModel sm, String resolvedCodeEnvName) throws Exception {
        CodeEnvModel.PythonEnvDesc desc;
        try {
            block1 : switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    CodeEnvModel.AutomationEnvRootDef envRootDef = this.automationNodeCodeEnvsService.getEnvRootDef(CodeEnvModel.EnvLang.PYTHON, resolvedCodeEnvName);
                    if (envRootDef == null || envRootDef.deploymentMode == null) {
                        throw new Error("Code environment not found: " + codeEnvName);
                    }
                    switch (envRootDef.deploymentMode) {
                        case AUTOMATION_SINGLE: 
                        case AUTOMATION_NON_MANAGED_PATH: 
                        case EXTERNAL_CONDA_NAMED: 
                        case PLUGIN_MANAGED: 
                        case PLUGIN_NON_MANAGED: {
                            File envRootDir = AutomationNodeManagedEnvUtils.getEnvDir((CodeEnvModel.EnvLang)CodeEnvModel.EnvLang.PYTHON, (String)resolvedCodeEnvName);
                            desc = (CodeEnvModel.PythonEnvDesc)AutomationNodeManagedEnvUtils.getEnvDesc((File)envRootDir, CodeEnvModel.PythonEnvDesc.class);
                            break block1;
                        }
                        case AUTOMATION_VERSIONED: {
                            CommonBundleUtils.BundleDetails bundle = this.automationBundlesService.getBundleDetails(projectKey, CommonBundleUtils.getActiveBundleId((String)projectKey));
                            CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink((CodeEnvModel.EnvLang)CodeEnvModel.EnvLang.PYTHON, (String)resolvedCodeEnvName, (String)projectKey, (String)bundle.bundleId);
                            if (versionRef == null) {
                                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Code environment: " + resolvedCodeEnvName + " is not referenced by the active project bundle. If this code environment is specific to another project bundle, it should not be used for this model.");
                            }
                            File envRootDir = AutomationNodeManagedEnvUtils.getEnvVersionDir((CodeEnvModel.EnvLang)CodeEnvModel.EnvLang.PYTHON, (String)resolvedCodeEnvName, (String)versionRef.envVersion);
                            desc = (CodeEnvModel.PythonEnvDesc)AutomationNodeManagedEnvUtils.getEnvDesc((File)envRootDir, CodeEnvModel.PythonEnvDesc.class);
                            break block1;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported deployment mode \"" + String.valueOf(envRootDef.deploymentMode) + "\" for code env \"" + resolvedCodeEnvName + "\"");
                }
                case DESIGN: {
                    desc = (CodeEnvModel.PythonEnvDesc)this.designNodeCodeEnvsService.getEnvDesc(CodeEnvModel.EnvLang.PYTHON, resolvedCodeEnvName);
                    if (desc == null || desc.deploymentMode == null) {
                        throw new Error("Code environment not found: " + codeEnvName);
                    }
                    switch (desc.deploymentMode) {
                        case EXTERNAL_CONDA_NAMED: 
                        case PLUGIN_MANAGED: 
                        case PLUGIN_NON_MANAGED: 
                        case DESIGN_MANAGED: 
                        case DESIGN_NON_MANAGED: 
                        case DSS_INTERNAL: {
                            break block1;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported deployment mode \"" + String.valueOf(desc.deploymentMode) + "\" for code env \"" + resolvedCodeEnvName + "\"");
                }
                default: {
                    throw new Error("Unsupported node type: " + String.valueOf(ApplicationConfigurator.getNodeType()));
                }
            }
        }
        catch (CodedIOException e) {
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)e);
            desc = null;
        }
        if (desc == null) {
            if (sm.savedModelType == SavedModel.SavedModelType.PROXY_MODEL) {
                throw new IllegalStateException("Code environment for External Models not installed. Contact an admin to create it.");
            }
            throw new IllegalArgumentException("Code environment not found: " + codeEnvName);
        }
    }

    @ResponseBody
    @AuditedCall(value={"msgType", "savedmodel-version-get-metadata", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/external-ml/metadata"}, method={RequestMethod.GET})
    public MLFlowModelVersionInfo externalMLGetMetadata(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        FullModelId fmi = null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
            if (sm.savedModelType == SavedModel.SavedModelType.DSS_MANAGED) {
                throw new IllegalArgumentException("Cannot manually get metadata on DSS-managed saved models");
            }
            fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        }
        return fmi.getMLflowImportedModelMetadata();
    }

    @AuditedCall(value={"msgType", "savedmodel-version-save-metadata", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/external-ml/metadata"}, method={RequestMethod.PUT})
    public void externalMLSetMetadata(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam String containerExecConfigName) throws Exception {
        FullModelId fmi;
        AuthCtx authCtx;
        MLFlowModelVersionInfo newMIM = (MLFlowModelVersionInfo)this.getRequestBodyAs(req, MLFlowModelVersionInfo.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
            if (sm.savedModelType == SavedModel.SavedModelType.DSS_MANAGED) {
                throw new IllegalArgumentException("Cannot manually set metadata on DSS-managed saved models");
            }
            fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        }
        ContainerExecSelection containerExecSelection = this.buildContainerExecSelection(containerExecConfigName);
        this.mlflowModelOperationsService.setSignatureAndFormats(authCtx, fmi, newMIM, containerExecSelection);
    }

    @AuditedCall(value={"msgType", "savedmodel-version-evaluate-external-model", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/external-ml/actions/evaluate"}, method={RequestMethod.POST})
    public void evaluateExternalModel(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam(defaultValue="false") boolean useOptimalThreshold, @RequestParam(defaultValue="false") boolean skipExpensiveReports) throws Exception {
        FullModelId fmi;
        SavedModel sm;
        AuthCtx authCtx;
        ExternalModelEvaluateRequest evaluateRequest = (ExternalModelEvaluateRequest)this.getRequestBodyAs(req, ExternalModelEvaluateRequest.class);
        AnyLoc datasetLoc = AnyLoc.resolveSmart((String)projectKey, (String)evaluateRequest.datasetRef);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (!StringUtils.equals((String)projectKey, (String)datasetLoc.getProjectKey())) {
                this.permissionsService.checkProjectPrivileges(authCtx, datasetLoc.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
            if (sm.savedModelType == SavedModel.SavedModelType.DSS_MANAGED) {
                throw new IllegalArgumentException("Cannot manually evaluate a DSS-managed saved models");
            }
            fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        }
        ContainerExecSelection containerExecSelection = this.buildContainerExecSelection(evaluateRequest.containerExecConfigName);
        this.mlflowModelOperationsService.evaluate(authCtx, fmi, evaluateRequest.datasetRef, containerExecSelection, evaluateRequest.samplingParam, useOptimalThreshold, skipExpensiveReports);
        HashMap metricValues = Maps.newHashMap();
        Partition partition = MetricsComputationService.fakeSMVersionPartition((String)fmi.getSavedModelVersionID());
        this.metricsComputationService.scoopSavedModelMetrics(sm, partition, (Map)metricValues);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.metricsComputationService.saveMetricsValues(authCtx, (Object)sm, MetricTargetType.SAVED_MODEL, partition, DateTime.now(), (Map)metricValues, this.buildMetricsEnvironment());
        }
    }

    private ContainerExecSelection buildContainerExecSelection(String containerExecConfigName) {
        ContainerExecSelection containerExecSelection = new ContainerExecSelection();
        if (StringUtils.isEmpty((String)containerExecConfigName) || "INHERIT".equals(containerExecConfigName)) {
            containerExecSelection.containerMode = ContainerExecSelection.ContainerExecMode.INHERIT;
        } else if ("NONE".equals(containerExecConfigName)) {
            containerExecSelection.containerMode = ContainerExecSelection.ContainerExecMode.NONE;
        } else {
            containerExecSelection.containerMode = ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER;
            containerExecSelection.containerConf = containerExecConfigName;
        }
        return containerExecSelection;
    }

    private MetricsComputationService.MetricsComputationEnvironment buildMetricsEnvironment() throws IOException {
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        return environment;
    }

    @AuditInline
    @RequestMapping(value={"/{smId}/actions/delete-versions"}, method={RequestMethod.POST})
    public void savedModelDeleteVersion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId) throws Exception {
        SavedModel sm;
        DeleteSavedModelVersionsParams params;
        block28: {
            params = (DeleteSavedModelVersionsParams)this.getRequestBodyAs(req, DeleteSavedModelVersionsParams.class);
            try {
                AuthCtx authCtx;
                try (Object t = this.transactionService.beginRead();){
                    authCtx = this.authService.getTicketOrKey(req);
                    this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
                    sm = (SavedModel)this.savedModelsDAO.getMandatory(projectKey, smId);
                }
                if (sm.savedModelType == SavedModel.SavedModelType.LLM_GENERIC) {
                    t = this.transactionService.beginWriteForAPI(req);
                    try {
                        for (String version : params.versions) {
                            this.llmSavedModelsService.deleteLLMGenericModelVersion(authCtx, sm, version, Boolean.valueOf(false));
                        }
                        t.commit("Deleted " + params.versions.size() + " versions from " + projectKey + "." + smId);
                        break block28;
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                }
                if (sm.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT || sm.savedModelType == SavedModel.SavedModelType.TOOLS_USING_AGENT) {
                    t = this.transactionService.beginWriteForAPI(req);
                    try {
                        for (String version : params.versions) {
                            this.savedModelsAgentsService.deleteAgentVersion(sm, version);
                        }
                        t.commit("Deleted " + params.versions.size() + " versions from " + projectKey + "." + smId);
                        break block28;
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                }
                if (sm.savedModelType == SavedModel.SavedModelType.PLUGIN_AGENT) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Version management is not supported on Plugin Agent");
                }
                if (sm.savedModelType == SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Version management is not supported on Retrieval-Augmented LLM");
                }
                for (String version : params.versions) {
                    this.psmmService.deleteVersion_NT(sm, version, params.removeIntermediate);
                }
            }
            catch (Exception e) {
                this.auditTrailService.failure("savedmodel-delete-versions", (Throwable)e).with("projectKey", projectKey).with("smId", smId).with("versions", StringUtils.join(params.versions, (String)",")).with("removeIntermediate", params.removeIntermediate).emit();
                throw e;
            }
        }
        this.auditTrailService.generic("savedmodel-delete-versions").with("projectKey", projectKey).with("smId", smId).with("versions", StringUtils.join(params.versions, (String)",")).with("removeIntermediate", params.removeIntermediate).emit();
        this.psmmService.cleanUnreferencedPartitionedModelsNoFail(sm);
    }

    @AuditedCall(value={"msgType", "savedmodel-get-version-details", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/snippet"}, method={RequestMethod.GET})
    public void getModelVersionSnippet(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        switch (sm.getType()) {
            case PREDICTION: {
                PredictionModelDetails modelDetails = PredictionResultsReader.makeModelDetails((FullModelId)fmi);
                MLTask task = fmi.getHeadMLTask();
                if (task instanceof PredictionMLTask.TabularPredictionMLTask) {
                    if (task instanceof PredictionMLTask.ClassicalPredictionMLTask) {
                        ((ClassicalPredictionModelDetails)modelDetails).headTaskCMW = ((PredictionMLTask.ClassicalPredictionMLTask)task).modeling.metrics.costMatrixWeights;
                    }
                    PredictionModelSnippetData snippet = PredictionResultsReader.makeSnippet((ModelDetailsBase)modelDetails);
                    snippet.sessionDate = snippet.trainInfo == null ? 0L : snippet.trainInfo.endTime;
                    PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)snippet);
                    break;
                }
                throw new IllegalArgumentException("Unsupported Prediction task: " + task.getClass().getSimpleName());
            }
            case CLUSTERING: {
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)ClusteringResultsReader.makeSnippet((ClusteringModelDetails)ClusteringResultsReader.makeDetails((FullModelId)fmi)));
                break;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                LLMModelDetails llmDetails = LLMModelReader.makeDetails((FullModelId)fmi);
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)LLMModelReader.makeSnippet((LLMModelDetails)llmDetails));
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-get-version-details", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/details"}, method={RequestMethod.GET})
    public void getModelVersionDetails(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        switch (sm.getType()) {
            case PREDICTION: {
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makeModelDetails((FullModelId)fmi));
                break;
            }
            case CLUSTERING: {
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)ClusteringResultsReader.makeDetails((FullModelId)fmi));
                break;
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)LLMModelReader.makeDetails((FullModelId)fmi));
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-version-compute-shapley-feature-importance", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/shapley-feature-importance"}, method={RequestMethod.POST})
    public void computeModelVersionShapleyFeatureImportance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        switch (sm.getType()) {
            case PREDICTION: {
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.globalExplanationsComputationStart(authCtx, (ModelLikeId)fmi));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot compute Shapley feature importance for clustering models");
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot compute Shapley feature importance for LLMs");
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-version-compute-subpop", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/subpopulation-analyses"}, method={RequestMethod.POST})
    public void computeModelVersionSubpopulationAnalyses(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        switch (sm.getType()) {
            case PREDICTION: {
                PosttrainComputationWithFeaturesReq computationReq = (PosttrainComputationWithFeaturesReq)this.getRequestBodyAs(req, PosttrainComputationWithFeaturesReq.class);
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.subpopulationComputationStart(authCtx, fmi, computationReq.features, computationReq.computationParams, true));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run subpopulation analysis computation for clustering models");
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run subpopulation analysis computation for LLMs");
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-version-get-subpop", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/subpopulation-analyses"}, method={RequestMethod.GET})
    public void getModelVersionSubpopulationAnalyses(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        switch (sm.getType()) {
            case PREDICTION: {
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makeSubpopulationResults((FullModelId)fmi));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get subpopulation analysis results for clustering models");
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get subpopulation analysis results for LLMs");
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-version-compute-pdp", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/partial-dependencies"}, method={RequestMethod.POST})
    public void computeModelVersionPartialDependencies(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        switch (sm.getType()) {
            case PREDICTION: {
                PosttrainComputationWithFeaturesReq computationReq = (PosttrainComputationWithFeaturesReq)this.getRequestBodyAs(req, PosttrainComputationWithFeaturesReq.class);
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.pdpComputationStart(authCtx, (ModelLikeId)fmi, computationReq.features, computationReq.computationParams));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run partial dependency computation for clustering models");
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run partial dependency computation for LLMs");
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-version-get-pdp", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/partial-dependencies"}, method={RequestMethod.GET})
    public void getModelVersionPartialDependencies(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        switch (sm.getType()) {
            case PREDICTION: {
                PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makePartialDependenceResults((File)fmi.getModelFolder()));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get partial dependencies results for clustering models");
            }
            case LLM_GENERIC_RAW: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_CLASSIFICATION: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get partial dependencies results for LLMs");
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-version-compute-timeseries-residuals", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/timeseries-residuals"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Map<String, TimeseriesResiduals>> computeModelVersionTimeseriesResiduals(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        if (!fmi.getPredictionType().equals((Object)PredictionMLTask.PredictionType.TIMESERIES_FORECAST)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Model is not a timeseries forecasting model. Cannot run residuals computation.");
        }
        return this.predictionService.computePerTimeseriesResiduals(authCtx, (ModelLikeId)fmi);
    }

    @AuditedCall(value={"msgType", "savedmodel-version-get-timeseries-residuals", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/timeseries-residuals"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, TimeseriesResiduals> getModelVersionTimeseriesResiduals(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        if (!fmi.getPredictionType().equals((Object)PredictionMLTask.PredictionType.TIMESERIES_FORECAST)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Model is not a timeseries forecasting model. Cannot fetch residuals.");
        }
        Optional residuals = fmi.parseTimeseriesResiduals((List)Lists.newArrayList());
        if (residuals.isEmpty()) {
            resp.setStatus(404);
            resp.getWriter().write("Residuals not found");
            return null;
        }
        return (Map)residuals.get();
    }

    @AuditedCall(value={"msgType", "savedmodel-version-get-per-timeseries-metrics", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/per-timeseries-metrics"}, method={RequestMethod.GET})
    public void getPerTimeseriesMetrics(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(projectKey);
        if (fmi.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch per time series metrics for time series forecasting models");
        }
        if (fmi.isPartitionedBaseModel()) {
            Map modelPerf = fmi.getPartitionedTimeseriesForecastingPerfs();
            PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, Map.of("perPartition", modelPerf));
        } else {
            TimeseriesForecastingModelPerf modelPerf = fmi.getTimeseriesForecastingPerf(true);
            PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, Map.of("perTimeseries", modelPerf.perTimeseriesMetrics));
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-version-get-per-timeseries-metrics", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/per-timeseries-evaluation-forecasts"}, method={RequestMethod.GET})
    public void getPerTimeseriesEvaluationForecasts(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(projectKey);
        if (fmi.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch per time series evaluation forecasts for time series forecasting models");
        }
        if (fmi.isPartitionedBaseModel()) {
            Map modelEvaluationForecasts = fmi.getPartitionedTimeseriesEvaluationForecasts();
            PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, Map.of("perPartition", modelEvaluationForecasts));
        } else {
            TimeseriesEvaluationForecasts modelForecasts = fmi.getTimeseriesEvaluationForecasts();
            PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, Map.of("perTimeseries", modelForecasts.perTimeseries));
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-set-active", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/actions/setActive"}, method={RequestMethod.POST})
    public void setModelActiveVersion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatory(projectKey, smId);
            switch (sm.getType()) {
                case PREDICTION: {
                    boolean schemaChanged = this.psmmService.setActive(sm, versionId) && this.predictionRecipesService.hasDownstreamRecipe(sm);
                    PublicAPISavedModelsController.writeJSONString((HttpServletResponse)resp, (String)("{\"schemaChanged\":" + schemaChanged + "}"));
                    break;
                }
                case CLUSTERING: {
                    boolean schemaChanged = this.csmmService.setActive(sm, versionId) && this.clusteringRecipesService.hasDownstreamRecipe(sm);
                    PublicAPISavedModelsController.writeJSONString((HttpServletResponse)resp, (String)("{\"schemaChanged\":" + schemaChanged + "}"));
                    break;
                }
                case LLM_GENERIC_RAW: 
                case LLM_GENERIC_PROMPTABLE_COMPLETION: 
                case LLM_CLASSIFICATION: {
                    if (sm.savedModelType.isAgent()) {
                        this.savedModelsAgentsService.setAgentVersionActive(sm, versionId);
                    }
                    if (sm.savedModelType == SavedModel.SavedModelType.LLM_GENERIC) {
                        this.llmSMService.setLLMGenericVersionActive(sm, versionId);
                    }
                    if (sm.savedModelType.isRetrievalAugmentedLlm()) {
                        logger.warn((Object)"Retrieval Augmented LLMs don't support versioning");
                    }
                    PublicAPISavedModelsController.writeJSONString((HttpServletResponse)resp, (String)"{\"schemaChanged\":false}");
                }
            }
            t.commit("Set active version of " + projectKey + "." + smId + " to " + versionId);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-set-content-type", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/actions/setContentType"}, method={RequestMethod.POST})
    public void setModelContentType(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @RequestParam String contentType) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatory(projectKey, smId);
            sm.contentType = contentType;
            this.savedModelsDAO.save(sm);
            t.commit("Set content type of " + projectKey + "." + smId + " to " + contentType);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-get-status", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/{smId}/metrics/{versionId:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsService.ComputedMetrics getLastValuesOnModel(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        MetricsService.ComputedMetrics list = this.metricsService.listComputedMetrics_NT((Object)sm, MetricTargetType.SAVED_MODEL, sm.metrics != null ? sm.metrics.displayedState : null, true);
        MetricsService.ComputedMetrics restricted = new MetricsService.ComputedMetrics();
        for (MetricsService.ComputedMetric computedMetric : list.metrics) {
            String matches = null;
            for (String computedMetricPartition : computedMetric.partitionsWithValue) {
                if (!versionId.equals(computedMetricPartition)) continue;
                matches = computedMetricPartition;
                break;
            }
            if (matches == null) continue;
            computedMetric.partitionsWithValue = Lists.newArrayList((Object[])new String[]{matches});
            restricted.metrics.add(computedMetric);
        }
        return restricted;
    }

    @AuditedCall(value={"msgType", "ml-model-save-meta", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/user-meta"}, method={RequestMethod.PUT})
    public void setModelMeta(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
        }
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        ModelUserMeta meta = (ModelUserMeta)this.getRequestBodyAs(req, ModelUserMeta.class);
        this.mlBaseService.saveModelUserMeta(fmi, meta);
    }

    @AuditedCall(value={"msgType", "savedmodel-delete", "projectKey", "${projectKey}", "modelId", "${smId}"})
    @RequestMapping(value={"/{smId:.+}"}, method={RequestMethod.DELETE})
    public void deleteSavedModel(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId) throws Exception {
        HashSet<TaggableObjectsDeletionService.DeletionRequestItem> items = new HashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        items.add(new TaggableObjectsDeletionService.DeletionRequestItem(projectKey, ITaggingService.TaggableType.SAVED_MODEL, smId));
        HashSet<TaggableObjectsService.TaggableObjectRef> ignored = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        HashSet<TaggableObjectsDeletionService.DeletionRequestItem> toDelete = new HashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        AuthCtx authCtx = null;
        HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject> taggableObjectsMap = new HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject>(items.size());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            for (TaggableObjectsDeletionService.DeletionRequestItem dr : items) {
                boolean isForeign = dr.id.contains(".") || projectKey != null && !projectKey.equals(dr.projectKey);
                TaggableObjectsService.TaggableObjectRef drAsTaggableObjectRef = new TaggableObjectsService.TaggableObjectRef(dr.projectKey, dr.type, dr.id);
                ignored.add(drAsTaggableObjectRef);
                if (!isForeign) {
                    toDelete.add(dr);
                    TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatoryUnsafe((TaggableObjectsService.TaggableObjectRef)dr);
                    taggableObjectsMap.put(dr, to);
                    continue;
                }
                throw new Exception(smId + " cannot be deleted because it is a foreign model.");
            }
        }
        TaggableObjectsDeletionService.DeletionResult result = this.taggableObjectsDeletionService.delete_NT(toDelete, taggableObjectsMap, projectKey, ignored, authCtx);
        PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditInline
    @RequestMapping(value={"/{smId}/versions/{versionId}/scoring-pmml"}, method={RequestMethod.GET})
    public void getModelPmml(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        try {
            ScoringExporter.checkExportLicenced();
            fmi.checkIdsValidity(projectKey);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            ScoringExporter exporter = new ScoringExporter((ScoringExporter.ScoringWriter)new PMMLScoring(fmi));
            exporter.exportTo(resp);
            this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", projectKey).with("fullModelId", fmi.toString()).with("format", "pmml").with("exportId", exporter.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-prediction-model-export", (Throwable)e).with("projectKey", projectKey).with("fullModelId", fmi.toString()).with("format", "pmml").emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/{smId}/versions/{versionId}/scoring-jar"}, method={RequestMethod.GET})
    public void getModelJar(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam(required=false, defaultValue="model.Model") String fullClassName, @RequestParam(required=false, defaultValue="false") boolean includeLibs) throws Exception {
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        try {
            ScoringExporter.checkExportLicenced();
            fmi.checkIdsValidity(projectKey);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            ScoringExporter exporter = new ScoringExporter((ScoringExporter.ScoringWriter)new JarScoring(includeLibs, fmi, fullClassName));
            exporter.exportTo(resp);
            this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", projectKey).with("fullModelId", fmi.toString()).with("format", "jar").with("exportId", exporter.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-prediction-model-export", (Throwable)e).with("projectKey", projectKey).with("fullModelId", fmi.toString()).with("format", "jar").emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/{smId}/versions/{versionId}/scoring-python"}, method={RequestMethod.GET})
    public void getModelPython(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam(required=false, defaultValue="false") boolean mlflowExport, @RequestParam(required=false, defaultValue="false") boolean useOriginalMLflowModel) throws Exception {
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        try {
            ScoringExporter.checkExportLicenced();
            fmi.checkIdsValidity(projectKey);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            ScoringExporter exporter = new ScoringExporter((ScoringExporter.ScoringWriter)(mlflowExport ? new MLflowScoring(fmi, useOriginalMLflowModel) : new PythonScoring(fmi)));
            exporter.exportTo(resp);
            this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", projectKey).with("fullModelId", fmi.toString()).with("format", mlflowExport ? "mlflow" : "python").with("exportId", exporter.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-prediction-model-export", (Throwable)e).with("projectKey", projectKey).with("fullModelId", fmi.toString()).with("format", mlflowExport ? "mlflow" : "python").emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "ml-model-export-to-snowflake-function", "projectKey", "${projectKey}", "smId", "${smId}", "versionId", "${versionId}", "functionName", "${functionName}", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/export-to-snowflake-function"})
    public FutureResponse<Void> exportModelToSnowflakeFunction(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam String connectionName, @RequestParam String functionName) throws Exception {
        SnowflakeConnection sfConn;
        AuthCtx authCtx;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            DSSConnection conn = ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
            if (!(conn instanceof SnowflakeConnection)) {
                throw new IllegalArgumentException("Connection is not a Snowflake connection");
            }
            if (!conn.isFreelyUsableBy(authCtx)) {
                throw new UnauthorizedException("Access to this connection is not authorized.", "connection-access-denied");
            }
            sfConn = (SnowflakeConnection)conn;
        }
        SnowflakePermanentFunctionExportThread thread = new SnowflakePermanentFunctionExportThread(authCtx, sfConn, fmi, functionName);
        return this.futureService.runFuture((FutureThreadBase)thread, 0L, (TypeToken)new TypeToken<FutureResponse<Void>>(){});
    }

    @AuditedCall(value={"msgType", "ml-model-export-to-databricks-registry", "projectKey", "${projectKey}", "smId", "${smId}", "versionId", "${versionId}", "connectionName", "${connectionName}", "useUnityCatalog", "${useUnityCatalog}", "modelName", "${modelName}", "experimentName", "${experimentName}"})
    @ResponseBody
    @RequestMapping(value={"/{smId}/versions/{versionId}/export-to-databricks-registry"})
    public FutureResponse<DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse> exportToDatabricksRegistry(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam String connectionName, @RequestParam(defaultValue="false") boolean useUnityCatalog, @RequestParam String modelName, @RequestParam String experimentName) throws Exception {
        DSSAuthCtx authCtx;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnectionAndCheckDetailsReadable((AuthCtx)authCtx, (String)connectionName);
        return this.futureService.runFuture((FutureThreadBase)new ExportAndRegisterMLflowModelInFutureThread((AuthCtx)authCtx, fmi, connection, useUnityCatalog, modelName, experimentName, List.of()), 0L, (TypeToken)new TypeToken<FutureResponse<DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse>>(){});
    }

    @AuditedCall(value={"msgType", "model-document-generation", "projectKey", "${projectKey}", "smId", "${smId}", "versionId", "${versionId}"}, transformer=FullModelIdTransformer.class)
    @RequestMapping(value={"/{smId}/versions/{versionId}/generate-documentation-from-custom-template"}, method={RequestMethod.POST})
    public void generateDocumentationFromCustomTemplate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam(value="file") MultipartFile customTemplate) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, customTemplate.getInputStream(), fmi));
    }

    @AuditedCall(value={"msgType", "model-document-generation", "projectKey", "${projectKey}", "smId", "${smId}", "versionId", "${versionId}"}, transformer=FullModelIdTransformer.class)
    @RequestMapping(value={"/{smId}/versions/{versionId}/generate-documentation-from-template-in-folder"}, method={RequestMethod.POST})
    public void generateDocumentationFromTemplateInFolder(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam String folderId, @RequestParam String path) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(projectKey);
        String fullModelId = fmi.toString();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        File template = this.modelDocumentGenerationService.getTemplate(false, fullModelId, (AuthCtx)authCtx, projectKey, folderId, path);
        PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, (InputStream)new FileInputStream(template), fmi));
    }

    @AuditedCall(value={"msgType", "model-document-generation", "projectKey", "${projectKey}", "smId", "${smId}", "versionId", "${versionId}"}, transformer=FullModelIdTransformer.class)
    @RequestMapping(value={"/{smId}/versions/{versionId}/generate-documentation-from-default-template"}, method={RequestMethod.POST})
    public void generateDocumentationFromDefaultTemplate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId, @PathVariable String versionId) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(projectKey);
        String fullModelId = fmi.toString();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        File template = this.modelDocumentGenerationService.getDefaultTemplate(fullModelId);
        PublicAPISavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, (InputStream)new FileInputStream(template), fmi));
    }

    @AuditedCall(value={"msgType", "model-document-download", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/documentations/{exportId}"}, method={RequestMethod.GET})
    public void downloadDocumentation(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
        }
        File modelDocumentation = this.modelDocumentGenerationService.getMdgFile(exportId);
        if (modelDocumentation == null) {
            throw new NotFoundException("Model Documentation with id '" + exportId + "' doesn't exist or hasn't finished exporting");
        }
        MDGFileUtil.sendDocxDownload((File)modelDocumentation, (HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "savedmodel-version-external-model-setup-monitoring", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @RequestMapping(value={"/{smId}/versions/{versionId}/external-ml/actions/setup-monitoring"}, method={RequestMethod.POST})
    public void setupExternalModelMonitoring(HttpServletRequest req, @RequestParam String projectKey, @PathVariable String smId, @PathVariable String versionId, @RequestParam String connection, @RequestParam MonitoringWizardSettings params) throws Exception {
        FullModelId fmi;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SavedModel sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
            if (sm.savedModelType != SavedModel.SavedModelType.PROXY_MODEL) {
                throw new IllegalArgumentException("Cannot create monitoring on non external (proxy) models");
            }
            fmi = new FullModelId(sm.projectKey, sm.id, versionId);
        }
        this.monitoringWizardService.setupExternalModelMonitoring(authCtx, projectKey, fmi, connection, params);
    }

    static class ProtoExternalSavedModel {
        SavedModel.SavedModelType savedModelType;
        PredictionMLTask.PredictionType predictionType;
        String name;
        @Nullable
        ProxyModelConfiguration proxyModelConfiguration;

        ProtoExternalSavedModel() {
        }
    }

    static class ExternalModelEvaluateRequest {
        String datasetRef;
        String containerExecConfigName;
        SamplingParam samplingParam;

        ExternalModelEvaluateRequest() {
        }
    }

    static class DeleteSavedModelVersionsParams {
        public List<String> versions;
        public boolean removeIntermediate = true;

        DeleteSavedModelVersionsParams() {
        }
    }

    static class PosttrainComputationWithFeaturesReq {
        List<String> features;
        JsonObject computationParams;

        PosttrainComputationWithFeaturesReq() {
        }
    }

    public static class FullModelIdTransformer
    implements AuditTransformer {
        public void transform(AuditObj obj) {
            if (obj.has(new String[]{"projectKey", "smId", "versionId"})) {
                FullModelId fmi = new FullModelId(obj.get().get("projectKey").getAsString(), obj.get().get("smId").getAsString(), obj.get().get("versionId").getAsString());
                obj.without(new String[]{"projectKey", "smId", "versionId"}).with("modelId", fmi.toString());
            }
        }
    }

    public static class ModelVersionInfo {
        public String id;
        public boolean active;
        public long trainDate;
        @Nullable
        public Long importedDate;
        @Nullable
        public Long createdDate;

        static ModelVersionInfo fromVersionHeader(SMVersionHeader<?> versionHeader) {
            ModelVersionInfo ret = new ModelVersionInfo();
            ret.id = versionHeader.versionId;
            ret.active = versionHeader.active;
            ret.trainDate = versionHeader.snippet != null ? versionHeader.snippet.getTrainInfo().endTime : 0L;
            return ret;
        }

        static ModelVersionInfo fromPredictionVersionHeader(PredictionSMMgmtService.PredictionSMVersionHeader versionHeader) {
            ModelVersionInfo mvi = new ModelVersionInfo();
            mvi.id = versionHeader.versionId;
            mvi.active = versionHeader.active;
            if (versionHeader.snippet == null) {
                return mvi;
            }
            switch (((PredictionModelSnippetData)versionHeader.snippet).savedModelType) {
                case MLFLOW_PYFUNC: {
                    mvi.importedDate = ((PredictionModelSnippetData)versionHeader.snippet).importedOn;
                    mvi.createdDate = ((PredictionModelSnippetData)versionHeader.snippet).timeCreated;
                    break;
                }
                case PROXY_MODEL: {
                    mvi.createdDate = ((PredictionModelSnippetData)versionHeader.snippet).timeCreated;
                    break;
                }
                default: {
                    mvi.trainDate = ((PredictionModelSnippetData)versionHeader.snippet).trainDate;
                }
            }
            return mvi;
        }
    }
}

