/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.opensearch;

import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScorerSupplier;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;
import javax.annotation.Nullable;

public class OpensearchUtils {
    public static String nameOrEmptyFunc(String functionName) {
        if (functionName != null && !functionName.isEmpty()) {
            return "(_name: " + functionName + ")";
        }
        return "";
    }

    public static Explanation explainWithName(Explanation explanation, String queryName) {
        if (queryName == null || queryName.isEmpty()) {
            return explanation;
        }
        String description = explanation.getDescription() + " " + OpensearchUtils.nameOrEmptyFunc(queryName);
        if (explanation.isMatch()) {
            return Explanation.match((Number)explanation.getValue(), (String)description, (Explanation[])explanation.getDetails());
        }
        return Explanation.noMatch((String)description, (Explanation[])explanation.getDetails());
    }

    public static Bits asSequentialAccessBits(int maxDoc, @Nullable ScorerSupplier scorerSupplier) throws IOException {
        return OpensearchUtils.asSequentialAccessBits(maxDoc, scorerSupplier, 0L);
    }

    public static Bits asSequentialAccessBits(final int maxDoc, @Nullable ScorerSupplier scorerSupplier, long estimatedGetCount) throws IOException {
        if (scorerSupplier == null) {
            return new Bits.MatchNoBits(maxDoc);
        }
        Scorer scorer = scorerSupplier.get(estimatedGetCount);
        final TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        final DocIdSetIterator iterator = twoPhase == null ? scorer.iterator() : twoPhase.approximation();
        return new Bits(){
            int previous = -1;
            boolean previousMatched = false;

            public boolean get(int index) {
                if (index < 0 || index >= maxDoc) {
                    throw new IndexOutOfBoundsException(index + " is out of bounds: [0-" + maxDoc + "[");
                }
                if (index < this.previous) {
                    throw new IllegalArgumentException("This Bits instance can only be consumed in order. Got called on [" + index + "] while previously called on [" + this.previous + "]");
                }
                if (index == this.previous) {
                    return this.previousMatched;
                }
                this.previous = index;
                int doc = iterator.docID();
                if (doc < index) {
                    try {
                        doc = iterator.advance(index);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot advance iterator", e);
                    }
                }
                if (index == doc) {
                    try {
                        this.previousMatched = twoPhase == null || twoPhase.matches();
                        return this.previousMatched;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot validate match", e);
                    }
                }
                this.previousMatched = false;
                return false;
            }

            public int length() {
                return maxDoc;
            }
        };
    }
}

