/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.AutoMLDataSource;

@SdkInternalApi
public class AutoMLDataSourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3DATASOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataSource").build();
    private static final AutoMLDataSourceMarshaller instance = new AutoMLDataSourceMarshaller();

    public static AutoMLDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(AutoMLDataSource autoMLDataSource, ProtocolMarshaller protocolMarshaller) {
        if (autoMLDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(autoMLDataSource.getS3DataSource(), S3DATASOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

