/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.jwt;

import com.dataiku.dip.security.jwt.BadTokenException;
import com.dataiku.dip.security.jwt.JWTError;
import com.dataiku.dip.security.sso.OpenIDErrorCode;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.BadJWTException;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.text.ParseException;

public class OpenIDClaimsSetVerifierFactory {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    public static JWTClaimsSetVerifier<SecurityContext> createNonceVerifier(String nonce) {
        return (jwtClaimsSet, securityContext) -> {
            try {
                if (!nonce.equals(jwtClaimsSet.getStringClaim("nonce"))) {
                    throw new BadTokenException(OpenIDErrorCode.ERR_OPENID_INVALID_NONCE, "");
                }
            }
            catch (BadJWTException | ParseException e) {
                throw new BadTokenException(JWTError.ERR_JWT_TOKEN_INVALID_FORMAT, "Invalid ID token format");
            }
        };
    }
}

