/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.j2ts.annotations.UIType;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@JsonAdapter(value=SecretStringAdapter.class)
@UIType(value="string")
public class SecretString {
    public final String secret;

    private SecretString(String secret) {
        this.secret = (String)Preconditions.checkNotNull((Object)secret);
    }

    public String toString() {
        return "*****";
    }

    public static Optional<SecretString> build(String secret) {
        if (secret == null) {
            return Optional.empty();
        }
        return Optional.of(new SecretString(secret));
    }

    public static SecretString buildOrNull(String secret) {
        return SecretString.build(secret).orElse(null);
    }

    public static String getSecretOrNull(SecretString s) {
        if (s == null) {
            return null;
        }
        return s.secret;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretString that = (SecretString)o;
        return Objects.equals(this.secret, that.secret);
    }

    public int hashCode() {
        return Objects.hashCode(this.secret);
    }

    static class SecretStringAdapter
    extends TypeAdapter<SecretString> {
        SecretStringAdapter() {
        }

        public void write(JsonWriter jsonWriter, SecretString secretString) throws IOException {
            if (secretString == null || secretString.secret == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(secretString.secret);
            }
        }

        public SecretString read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                return null;
            }
            return SecretString.buildOrNull(jsonReader.nextString());
        }
    }
}

