/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene99;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnVectorsFormat;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnVectorsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.KnnVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsFormat;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentReadState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentWriteState;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TaskExecutor;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public class Lucene99HnswScalarQuantizedVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "Lucene99HnswScalarQuantizedVectorsFormat";
    private final int maxConn;
    private final int beamWidth;
    private final FlatVectorsFormat flatVectorsFormat;
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;

    public Lucene99HnswScalarQuantizedVectorsFormat() {
        this(16, 100, 1, 7, false, null, null);
    }

    public Lucene99HnswScalarQuantizedVectorsFormat(int maxConn, int beamWidth) {
        this(maxConn, beamWidth, 1, 7, false, null, null);
    }

    public Lucene99HnswScalarQuantizedVectorsFormat(int maxConn, int beamWidth, int numMergeWorkers, int bits, boolean compress, Float confidenceInterval, ExecutorService mergeExec) {
        super(NAME);
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        if (numMergeWorkers == 1 && mergeExec != null) {
            throw new IllegalArgumentException("No executor service is needed as we'll use single thread to merge");
        }
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec != null ? new TaskExecutor(mergeExec) : null;
        this.flatVectorsFormat = new Lucene99ScalarQuantizedVectorsFormat(confidenceInterval, bits, compress);
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, this.flatVectorsFormat.fieldsWriter(state), this.numMergeWorkers, this.mergeExec);
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, this.flatVectorsFormat.fieldsReader(state));
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public String toString() {
        return "Lucene99HnswScalarQuantizedVectorsFormat(name=Lucene99HnswScalarQuantizedVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", flatVectorFormat=" + this.flatVectorsFormat + ")";
    }
}

