/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.search.ConjunctionUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorable;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

class ConjunctionScorer
extends Scorer {
    final DocIdSetIterator disi;
    final Scorer[] scorers;
    final Collection<Scorer> required;

    ConjunctionScorer(Weight weight, Collection<Scorer> required, Collection<Scorer> scorers) {
        super(weight);
        assert (required.containsAll(scorers));
        this.disi = ConjunctionUtils.intersectScorers(required);
        this.scorers = scorers.toArray(new Scorer[scorers.size()]);
        this.required = required;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return TwoPhaseIterator.unwrap(this.disi);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        double sum = 0.0;
        for (Scorer scorer : this.scorers) {
            sum += (double)scorer.score();
        }
        return (float)sum;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScore = 0.0;
        for (Scorer s2 : this.scorers) {
            if (s2.docID() > upTo) continue;
            maxScore += (double)s2.getMaxScore(upTo);
        }
        return (float)maxScore;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        if (this.scorers.length == 1) {
            return this.scorers[0].advanceShallow(target);
        }
        for (Scorer scorer : this.scorers) {
            scorer.advanceShallow(target);
        }
        return super.advanceShallow(target);
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        if (this.scorers.length == 1) {
            this.scorers[0].setMinCompetitiveScore(minScore);
        }
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
        for (Scorer scorer : this.required) {
            children.add(new Scorable.ChildScorable(scorer, "MUST"));
        }
        return children;
    }

    static final class DocsAndFreqs {
        final long cost;
        final DocIdSetIterator iterator;
        int doc = -1;

        DocsAndFreqs(DocIdSetIterator iterator2) {
            this.iterator = iterator2;
            this.cost = iterator2.cost();
        }
    }
}

