/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.plus.webapp;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.plus.jndi.Transaction;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.plus.webapp.EnvConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.plus.webapp.PlusDecorator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.plus.webapp.PlusDescriptorProcessor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.NanoTime;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(PlusConfiguration.class);
    private static final String LOCK_JNDI_KEY = "com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.plus.webapp.PlusConfiguration.jndiKey";

    public PlusConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(EnvConfiguration.class, WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class).addDependents(JettyWebXmlConfiguration.class));
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor(new PlusDescriptorProcessor());
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        context.setAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.injectionCollection", null);
        context.setAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindTransactionToENC(ServletContextHandler.ENVIRONMENT.getName());
        }
        catch (NameNotFoundException e) {
            try {
                com.dataiku.dss.shadelib.org.eclipse.jetty.plus.jndi.Transaction.bindTransactionToENC(ServletContextHandler.ENVIRONMENT.getName());
            }
            catch (NameNotFoundException x) {
                LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Integer key = (int)((long)this.hashCode() ^ NanoTime.now());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            wac.setAttribute(LOCK_JNDI_KEY, key);
            compCtx.addToEnvironment("com.dataiku.dss.shadelib.org.eclipse.jetty.jndi.lock", key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        Object o = wac.removeAttribute(LOCK_JNDI_KEY);
        if (o instanceof Integer) {
            Integer key = (Integer)o;
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("com.dataiku.dss.shadelib.org.eclipse.jetty.jndi.unlock", key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }
}

