/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.http;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.EtagUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpField;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.PreEncodedHttpField;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.StringUtil;
import java.util.Objects;

public class CompressedContentFormat {
    public static final CompressedContentFormat GZIP = new CompressedContentFormat("gzip", ".gz");
    public static final CompressedContentFormat BR = new CompressedContentFormat("br", ".br");
    public static final CompressedContentFormat[] NONE = new CompressedContentFormat[0];
    private final String _encoding;
    private final String _extension;
    private final String _etagSuffix;
    private final String _etagSuffixQuote;
    private final PreEncodedHttpField _contentEncoding;

    public CompressedContentFormat(String encoding, String extension) {
        this._encoding = StringUtil.asciiToLowerCase(encoding);
        this._extension = StringUtil.asciiToLowerCase(extension);
        this._etagSuffix = StringUtil.isEmpty(EtagUtils.ETAG_SEPARATOR) ? "" : EtagUtils.ETAG_SEPARATOR + this._encoding;
        this._etagSuffixQuote = this._etagSuffix + "\"";
        this._contentEncoding = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, this._encoding);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompressedContentFormat)) {
            return false;
        }
        CompressedContentFormat ccf = (CompressedContentFormat)o;
        return Objects.equals(this._encoding, ccf._encoding) && Objects.equals(this._extension, ccf._extension);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getExtension() {
        return this._extension;
    }

    public String getEtagSuffix() {
        return this._etagSuffix;
    }

    public HttpField getContentEncoding() {
        return this._contentEncoding;
    }

    public String etag(String etag) {
        if (StringUtil.isEmpty(EtagUtils.ETAG_SEPARATOR)) {
            return etag;
        }
        int end = etag.length() - 1;
        if (etag.charAt(end) == '\"') {
            return etag.substring(0, end) + this._etagSuffixQuote;
        }
        return etag + this._etagSuffix;
    }

    public int hashCode() {
        return Objects.hash(this._encoding, this._extension);
    }

    public String stripSuffixes(String etagsList) {
        if (StringUtil.isEmpty(EtagUtils.ETAG_SEPARATOR)) {
            return etagsList;
        }
        int i;
        while ((i = ((String)etagsList).lastIndexOf(this._etagSuffix)) >= 0) {
            etagsList = ((String)etagsList).substring(0, i) + ((String)etagsList).substring(i + this._etagSuffix.length());
        }
        return etagsList;
    }

    public String toString() {
        return this._encoding;
    }
}

