/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Utf8StringBuilder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.CoreSession;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.Frame;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.exception.BadPayloadException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;
import java.lang.invoke.MethodHandle;

public class PartialStringMessageSink
extends AbstractMessageSink {
    private Utf8StringBuilder accumulator;

    public PartialStringMessageSink(CoreSession session, MethodHandle methodHandle, boolean autoDemand) {
        super(session, methodHandle, autoDemand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (this.accumulator == null) {
                this.accumulator = new Utf8StringBuilder(this.getCoreSession().getInputBufferSize());
            }
            this.accumulator.append(frame.getPayload());
            if (frame.isFin()) {
                String complete = this.accumulator.takeCompleteString(BadPayloadException.InvalidUtf8::new);
                this.getMethodHandle().invoke(complete, true);
            } else {
                String partial = this.accumulator.takePartialString(BadPayloadException.InvalidUtf8::new);
                this.getMethodHandle().invoke(partial, false);
            }
            callback.succeeded();
            this.autoDemand();
        }
        catch (Throwable t2) {
            callback.failed(t2);
        }
        finally {
            if (frame.isFin()) {
                this.accumulator = null;
            }
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (this.accumulator != null) {
            this.accumulator.reset();
        }
    }
}

