/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.util.DKUDebugUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.Writer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DebugController
extends LambdaAPIControllerBase {
    private final ApiNodeAuthVerificationService authVerificationService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.debug.controller");

    @Autowired
    public DebugController(ApiNodeAuthVerificationService authVerificationService) {
        this.authVerificationService = authVerificationService;
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/dip/api/debugging/dump-backend-stacks"}, method={RequestMethod.GET})
    public void getBackendStacks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authVerificationService.verifyDebugAccess(req);
        DKUDebugUtils.printAllStacks((Writer)resp.getWriter());
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/dip/api/debugging/dump-metrics"}, method={RequestMethod.GET})
    public void dumpMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean gc) throws Exception {
        this.authVerificationService.verifyDebugAccess(req);
        logger.info((Object)"HTTP: requesting metrics dump");
        DKUDebugUtils.printMetrics((OutputStream)resp.getOutputStream(), (boolean)gc);
    }
}

