/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl;

import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.TimeStampSecHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.DateUtility;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public class NullableTimeStampSecHolderReaderImpl
extends AbstractFieldReader {
    private NullableTimeStampSecHolder holder;

    public NullableTimeStampSecHolderReaderImpl(NullableTimeStampSecHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPSEC;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(TimeStampSecHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeStampSecHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        if (!this.isSet()) {
            return null;
        }
        long millis = TimeUnit.SECONDS.toMillis(this.holder.value);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }
}

