/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.core;

import com.databricks.client.dsi.core.impl.DSIEnvironment;
import com.databricks.client.dsi.core.utilities.ConnSettingRequestMap;
import com.databricks.client.dsi.core.utilities.ConnSettingResponseMap;
import com.databricks.client.dsi.core.utilities.Variant;
import com.databricks.client.dsi.exceptions.BadAuthException;
import com.databricks.client.hivecommon.AuthMech;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.HiveServerType;
import com.databricks.client.hivecommon.HttpRetryType;
import com.databricks.client.hivecommon.ServiceDiscoveryMode;
import com.databricks.client.hivecommon.TransportMode;
import com.databricks.client.hivecommon.WholeNumberIntervalList;
import com.databricks.client.hivecommon.core.HiveJDBCCommonConnection;
import com.databricks.client.hivecommon.core.HiveJDBCCommonConnectionLogger;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.ProductInfoHandler;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.databricks.client.spark.core.SparkJDBCEnvironment;
import com.databricks.client.spark.core.SparkJDBCServerVersionUtils;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.Warning;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;

public class SparkJDBCConnection
extends HiveJDBCCommonConnection {
    private static final String DATABRICKS = "databricks";
    public static final int DEFAULT_TEMPORARILY_UNAVAILABLE_RETRY_TIMEOUT = 900;
    public static final int DEFAULT_RATE_LIMIT_RETRY_TIMEOUT = 120;
    private static final int USE_NATIVE_QUERY_TWO = 2;
    private String m_catalog;
    private boolean m_convertCatlogRestrictionToUpperCase = false;

    public SparkJDBCConnection(SparkJDBCEnvironment sparkJDBCEnvironment) throws ErrorException {
        super(sparkJDBCEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), sparkJDBCEnvironment);
    }

    public SparkJDBCConnection(DSIEnvironment dSIEnvironment, HiveJDBCCommonConnectionLogger hiveJDBCCommonConnectionLogger, String string, boolean bl) throws ErrorException {
        super(dSIEnvironment);
        LogUtilities.logFunctionEntrance(hiveJDBCCommonConnectionLogger, dSIEnvironment, hiveJDBCCommonConnectionLogger, string, bl);
        this.m_log = hiveJDBCCommonConnectionLogger;
        this.m_catalog = string;
        this.m_convertCatlogRestrictionToUpperCase = bl;
    }

    @Override
    public void establishConnection(ConnSettingRequestMap connSettingRequestMap, int n) throws ErrorException, BadAuthException {
        super.establishConnection(connSettingRequestMap, n);
    }

    @Override
    protected void connectToServer(int n, boolean bl) throws ErrorException {
        super.connectToServer(n, bl);
        if (DATABRICKS != null && DATABRICKS.toLowerCase().equals(DATABRICKS) && this.m_settings.m_protocolVersion.getValue() < TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue()) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.NON_DATABRICKS_SPARK_CONNECTION.name());
        }
    }

    @Override
    protected void configureSettingsAfterEstablishConnection(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super.configureSettingsAfterEstablishConnection(connSettingRequestMap);
        Variant variant = this.getOptionalSetting("ReportCharAndVarcharSupportForSpark", connSettingRequestMap);
        this.m_definedSettings.put("ReportCharAndVarcharSupportForSpark", true);
        this.m_settings.m_reportCharAndVarcharSupportForSpark = this.readOptionalBooleanSetting(connSettingRequestMap, "ReportCharAndVarcharSupportForSpark", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        if (2 == this.m_settings.m_useNativeQueryVal) {
            this.m_settings.m_useNativeQuery = this.m_settings.m_protocolVersion.getValue() >= TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V3.getValue();
        }
    }

    @Override
    protected void readDriverSpecificSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Variant variant;
        try {
            this.m_definedSettings.put("EnableQueryResultLZ4Compression", true);
            this.m_settings.m_isEnableQueryResultLZ4Compression = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableQueryResultLZ4Compression", this.m_settings.m_isEnableQueryResultLZ4Compression, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
            this.m_definedSettings.put("DisableCustomUseNativeQueryDefault", true);
            variant = this.getOptionalSetting("DisableCustomUseNativeQueryDefault", connSettingRequestMap);
            if (null == variant || 1 != variant.getInt()) {
                this.m_settings.m_useNativeQueryVal = 2;
            }
        }
        catch (Exception exception) {
            LogUtilities.logError("Error encountered while attempting to read the configuration: DisableCustomUseNativeQueryDefault", (ILogger)this.m_log);
            LogUtilities.logError(exception, (ILogger)this.m_log);
        }
        variant = this.getOptionalSetting("UseNativeQuery", connSettingRequestMap);
        if (null != variant) {
            try {
                this.m_settings.m_useNativeQueryVal = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_NATIVEMODE_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    @Override
    protected void setImplementationDefaultSettings() {
        this.m_settings.m_platformVersionUtils = new SparkJDBCServerVersionUtils();
        this.m_settings.m_platformDefaultUID = "Spark";
        this.m_settings.m_addApiCallToTTransportExceptionMessage = false;
        this.m_settings.m_platformCatalog = null == this.m_catalog ? "Spark" : this.m_catalog;
        this.m_settings.m_convertCatlogRestrictionToUpperCase = this.m_convertCatlogRestrictionToUpperCase;
        this.m_settings.m_platformDelegationUIDPropertyKey = "hive.server2.proxy.user";
        this.m_settings.m_dbmsName = "SparkSQL";
        this.m_settings.m_enableDirectResults = true;
        this.m_settings.m_thriftHTTPSettings.m_enableSessionTag = true;
        this.m_settings.m_cteQueryResultSet = true;
        this.m_settings.m_setKeyValueQueryResultSet = true;
        this.m_settings.m_supportsNumRowsModified = true;
        this.m_settings.m_unrecognizedStmtReturnsQueryResult = true;
        this.m_settings.m_isEnableQueryResultLZ4Compression = true;
        this.m_settings.m_downloadableResultSettings.m_isEnableQueryResultDownload = true;
        this.m_settings.m_downloadableResultSettings.m_isSslRequiredForQueryResultDownload = true;
        this.m_settings.m_isEnableHeartBeat = true;
        this.m_settings.m_enableNativeParameterizedQuery = true;
    }

    @Override
    protected void setSupportedHttpRetryType() {
        this.m_settings.m_supportedHttpRetryType = new ArrayList();
        WholeNumberIntervalList wholeNumberIntervalList = new WholeNumberIntervalList();
        wholeNumberIntervalList.AddInterval(503, 503);
        HttpRetryType httpRetryType = new HttpRetryType("TemporarilyUnavailableRetry", -1, -1, 900, false, false, wholeNumberIntervalList, null, null);
        httpRetryType.disableProperty("MaxRetryTime");
        httpRetryType.disableProperty("MinRetryInterval");
        httpRetryType.disableProperty("IncreaseRetryIntervalAfterEachRetry");
        httpRetryType.disableProperty("OverrideRetryAfterTime");
        httpRetryType.disableProperty("CodeRanges");
        this.m_settings.m_supportedHttpRetryType.add(httpRetryType);
        this.m_definedSettings.put("TemporarilyUnavailableRetry", true);
        for (String object2 : httpRetryType.getAllKeyPostfixes()) {
            this.m_definedSettings.put("TemporarilyUnavailableRetry" + object2, true);
        }
        WholeNumberIntervalList wholeNumberIntervalList2 = new WholeNumberIntervalList();
        wholeNumberIntervalList2.AddInterval(429, 429);
        HttpRetryType httpRetryType2 = new HttpRetryType("RateLimitRetry", -1, -1, 120, false, false, wholeNumberIntervalList2, null, null);
        httpRetryType2.disableProperty("MaxRetryTime");
        httpRetryType2.disableProperty("MinRetryInterval");
        httpRetryType2.disableProperty("IncreaseRetryIntervalAfterEachRetry");
        httpRetryType2.disableProperty("OverrideRetryAfterTime");
        httpRetryType2.disableProperty("CodeRanges");
        this.m_settings.m_supportedHttpRetryType.add(httpRetryType2);
        this.m_definedSettings.put("RateLimitRetry", true);
        for (String string : httpRetryType2.getAllKeyPostfixes()) {
            this.m_definedSettings.put("RateLimitRetry" + string, true);
        }
    }

    @Override
    protected ProductInfoHandler getProductInfoHandler() {
        String string = null;
        try {
            Variant variant = this.getProperty(170);
            string = variant.getString();
        }
        catch (Exception exception) {
            string = "";
        }
        if (DATABRICKS != null && DATABRICKS.toLowerCase().equals(DATABRICKS)) {
            return new ProductInfoHandler("SimbaDatabricksJDBCDriver.lic", "Simba Databricks JDBC Driver", string, HiveJDBCCommonDriver.class);
        }
        return new ProductInfoHandler("SimbaApacheSparkJDBCDriver.lic", "Simba Apache Spark JDBC Driver", string, HiveJDBCCommonDriver.class);
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            return ((DSIEnvironment)this.getParentEnvironment()).getLog();
        }
        return this.m_log;
    }

    @Override
    protected String getConnectionLogFileName() {
        if (null != "DatabricksJDBC_connection_") {
            return "DatabricksJDBC_connection_";
        }
        return "SparkJDBC_connection_";
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        boolean bl = false;
        this.verifyOptionalSetting("DecimalColumnScale", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("HiveServerType", connSettingRequestMap, connSettingResponseMap);
        if (hiveJDBCSettings.m_serviceDiscoveryMode == ServiceDiscoveryMode.AOSS) {
            hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer2;
        }
        if (null != hiveJDBCSettings.m_authMech) {
            bl = true;
        } else {
            hiveJDBCSettings.m_authMech = TransportMode.HTTP == hiveJDBCSettings.m_transportMode ? AuthMech.UIDPWD : AuthMech.SASL_PLAIN_UID;
        }
        if (HiveServerType.HiveServer2 == hiveJDBCSettings.m_hiveServerType) {
            if (AuthMech.NOAUTH_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
            }
            if (AuthMech.SASL_PLAIN_UIDPWD_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
                hiveJDBCSettings.m_authMech = AuthMech.UIDPWD;
            }
            if (AuthMech.UIDPWD == hiveJDBCSettings.m_authMech) {
                if (bl || TransportMode.HTTP == hiveJDBCSettings.m_transportMode) {
                    if (null != "token") {
                        this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    } else {
                        this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    }
                    this.verifyRequiredSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyOptionalSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech) {
                this.verifyOptionalSetting("KrbRealm", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbHostFQDN", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbServiceName", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("krbAuthType", connSettingRequestMap, connSettingResponseMap);
            }
            if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                this.verifyOptionalSetting("SSLKeyStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLKeyStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("AllowSelfSignedCerts", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("CAIssuedCertNamesMismatch", connSettingRequestMap, connSettingResponseMap);
            }
        }
        return connSettingResponseMap;
    }

    @Override
    protected void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(40, new Variant(0, "N"));
            super.setDefaultProperties();
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DEFAULT_PROP_SETTING_ERR.name(), exception.getMessage());
        }
    }

    @Override
    protected void doReset() throws ErrorException {
        this.setImplementationDefaultSettings();
    }

    @Override
    public IHiveCustomScalarFnFactory getScalarFnHelper() {
        return null;
    }

    @Override
    protected void setDefaultPort() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    @Override
    protected boolean readServiceDiscoverySettings(String string, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Variant variant = this.getOptionalSetting("AOSSStatusEndpoints", connSettingRequestMap);
        if ((null != variant || ServiceDiscoveryMode.AOSS.name().equalsIgnoreCase(string)) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.AOSS, this.getConnectionLog())) {
            this.setAOSSServiceDiscovery(connSettingRequestMap, variant);
            return true;
        }
        return super.readServiceDiscoverySettings(string, connSettingRequestMap);
    }

    protected void setAOSSServiceDiscovery(ConnSettingRequestMap connSettingRequestMap, Variant variant) throws ErrorException {
        Variant variant2;
        block17: {
            Object object;
            this.m_definedSettings.put("AOSSStatusEndpoints", true);
            this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.AOSS;
            String string = variant.getString();
            this.m_definedSettings.put("HiveServerType", true);
            this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
            try {
                object = string.split(",");
                this.m_settings.m_serviceDiscoveryEndpoints = object;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), exception.getMessage()});
                errorException.initCause(exception);
                throw errorException;
            }
            object = this.getOptionalSetting("AOSSStatusRequestTimeout", connSettingRequestMap);
            if (null != object) {
                try {
                    if (((Variant)object).getInt() >= 0) {
                        this.m_settings.m_AOSSSocketTimeout = ((Variant)object).getInt() * 1000;
                        break block17;
                    }
                    if (null != this.getWarningListener()) {
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{((Variant)object).getString(), "AOSSStatusRequestTimeout", String.valueOf(30000)}));
                    }
                    this.m_settings.m_AOSSSocketTimeout = 30000;
                }
                catch (Exception exception) {
                    if (null != this.getWarningListener()) {
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{((Variant)object).getString(), "AOSSStatusRequestTimeout", String.valueOf(30000)}));
                    }
                    this.m_settings.m_AOSSSocketTimeout = 30000;
                }
            } else {
                this.m_settings.m_AOSSSocketTimeout = 30000;
            }
        }
        if (null != (variant2 = this.getOptionalSetting("AOSS_AuthMech", connSettingRequestMap))) {
            int n;
            block18: {
                this.m_settings.m_AOSS_authMech = AuthMech.NOAUTH;
                n = -1;
                try {
                    n = variant2.getInt();
                }
                catch (Exception exception) {
                    if (null == this.getWarningListener()) break block18;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                }
            }
            if (n < AuthMech.values().length && n >= 0) {
                this.m_settings.m_AOSS_authMech = AuthMech.values()[n];
            }
            if (AuthMech.SASL_KERBEROS == this.m_settings.m_authMech) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), new String[]{"Authentication via Kerberos is not supported for AOSS endpoint."});
                throw errorException;
            }
            if (AuthMech.UIDPWD != this.m_settings.m_AOSS_authMech && AuthMech.NOAUTH != this.m_settings.m_AOSS_authMech) {
                if (null != this.getWarningListener()) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), new String[]{this.m_settings.m_authMech.toString()}));
                }
                this.m_settings.m_AOSS_authMech = AuthMech.NOAUTH;
                if (null != this.getWarningListener()) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_AOSS_authMech.toString()}));
                }
            }
        }
        this.m_definedSettings.put("AOSS_AuthMech", true);
    }
}

