/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.shaker.processors.transform.StringTransformationSettings;
import com.dataiku.dip.shaker.text.StringNormalizer;
import com.dataiku.dss.shadelib.com.google.common.base.CharMatcher;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum StringTransformation {
    TO_UPPER{

        @Override
        public String transform(String value, StringTransformationSettings parameter) {
            return value.toUpperCase();
        }
    }
    ,
    TO_LOWER{

        @Override
        public String transform(String value, StringTransformationSettings parameter) {
            return value.toLowerCase();
        }
    }
    ,
    URL_ENCODE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            return URLEncoder.encode(value, "utf8");
        }
    }
    ,
    URL_DECODE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            return URLDecoder.decode(value, "utf8");
        }
    }
    ,
    XML_ESCAPE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            return StringEscapeUtils.escapeXml((String)value);
        }
    }
    ,
    XML_UNESCAPE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            if (value.contains("&")) {
                return StringEscapeUtils.unescapeXml((String)value);
            }
            return value;
        }
    }
    ,
    UNICODE_ENCODE{

        @Override
        public String transform(String v, StringTransformationSettings parameter) throws Exception {
            boolean work = false;
            for (int i = 0; i < v.length(); ++i) {
                if (v.charAt(i) <= '\u007f') continue;
                work = true;
                break;
            }
            if (work) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < v.length(); ++i) {
                    if (v.charAt(i) > '\u007f') {
                        sb.append("\\u");
                        sb.append(String.format("%04x", v.charAt(i)));
                        continue;
                    }
                    sb.append(v.charAt(i));
                }
                return sb.toString();
            }
            return v;
        }
    }
    ,
    UNICODE_DECODE{

        @Override
        public String transform(String v, StringTransformationSettings parameter) throws Exception {
            if (v.contains("\\u")) {
                Matcher m = this.unicodePattern.matcher(v);
                StringBuilder sb = new StringBuilder();
                int prevStart = 0;
                while (m.find()) {
                    sb.append(v.substring(prevStart, m.start()));
                    String mv = m.group(1);
                    if (mv.length() > 0) {
                        int lv = Integer.valueOf(mv, 16);
                        sb.append((char)lv);
                    }
                    prevStart = m.end();
                }
                sb.append(v.substring(prevStart, v.length()));
                return sb.toString();
            }
            return v;
        }
    }
    ,
    TRIM{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            return CharMatcher.whitespace().or(CharMatcher.is((char)'\u0000')).trimFrom((CharSequence)value);
        }
    }
    ,
    CAPITALIZE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            if (value.isEmpty()) {
                return value;
            }
            String lowercased = value.toLowerCase();
            return lowercased.substring(0, 1).toUpperCase() + lowercased.substring(1);
        }
    }
    ,
    CAPITALIZE_FULLY{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            return WordUtils.capitalizeFully((String)value, null);
        }
    }
    ,
    NORMALIZE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            return StringNormalizer.normalize(value).toUpperCase().toLowerCase();
        }
    }
    ,
    NORMALIZE_SQLLIKE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            if (value == null) {
                return null;
            }
            return StringUtils.replaceChars((String)value.toLowerCase(), (String)StringTransformation.specials, (String)normalized).replaceAll("[ \\-'\"\u00a0]", "");
        }
    }
    ,
    TRUNCATE{

        @Override
        public String transform(String value, StringTransformationSettings parameter) throws Exception {
            return value.substring(0, Math.min(parameter.truncate_limit, value.length()));
        }
    };

    final Pattern unicodePattern = Pattern.compile("\\\\u([a-fA-F0-9]{8}|[a-fA-F0-9]{4})");
    public static final String accentuatedLower = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00e7\u0107\u0109\u010b\u010d\u00f0\u010f\u0111\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u0138\u013a\u013c\u013e\u0140\u0142\u00f1\u0144\u0146\u0148\u0149\u014b\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u017f\u0163\u0165\u0167\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u00fd\u00ff\u0177\u017a\u017c\u017e";
    public static final String unaccentuatedLower = "aaaaaaaaacccccdddeeeeeeeeegggghhiiiiiiiiijkklllllnnnnnnooooooooorrrssssstttuuuuuuuuuuwyyyzzz";
    public static final String specials = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00e7\u0107\u0109\u010b\u010d\u00f0\u010f\u0111\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u0138\u013a\u013c\u013e\u0140\u0142\u00f1\u0144\u0146\u0148\u0149\u014b\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u017f\u0163\u0165\u0167\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u00fd\u00ff\u0177\u017a\u017c\u017e-'\"\u00a0";
    public static final String normalized;

    public abstract String transform(String var1, StringTransformationSettings var2) throws Exception;

    static {
        normalized = StringUtils.rightPad((String)unaccentuatedLower, (int)specials.length());
    }
}

