/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.MeaningDetector;

public class FreeText
implements MeaningDetector {
    @Override
    public String getMeaningId() {
        return "FreeText";
    }

    @Override
    public final boolean isLong() {
        return false;
    }

    @Override
    public final boolean isDouble() {
        return false;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public final long longValue(String val) {
        return Long.MAX_VALUE;
    }

    @Override
    public final double doubleValue(String val) {
        return Double.NaN;
    }

    @Override
    public final boolean validates(String val) {
        return true;
    }

    @Override
    public double detects(String val) {
        if (val != null) {
            if (val.length() < 20) {
                return 0.001;
            }
            int length = Math.min(val.length(), 1000);
            int ntext_sympbols = 0;
            for (int i = 0; i < length; ++i) {
                char ch = val.charAt(i);
                if (ch != ' ' && ch != '\n' && ch != ',') continue;
                ++ntext_sympbols;
            }
            if (ntext_sympbols > 5) {
                return 0.5;
            }
            if (ntext_sympbols > 3) {
                return 0.15;
            }
            return 0.001;
        }
        return 0.001;
    }
}

