/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.ml;

import com.dataiku.dip.spark.ml.ModelResources;
import com.dataiku.dip.spark.ml.ModelResources$DssPipelineMeta$2$;
import com.dataiku.dip.spark.ml.h2o.RegressionH2OModel;
import com.dataiku.dip.spark.ml.prediction.MulticlassLogisticRegressionModel;
import com.dataiku.dip.spark.ml.prediction.WrappedDecisionTreeClassificationModel;
import com.dataiku.dip.spark.ml.prediction.WrappedGBTClassificationModel;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.utils.JsonConverters$;
import com.dataiku.scoring.builders.AlgorithmBuilding;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.Storage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.zip.GZIPOutputStream;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ModelResources$ {
    public static ModelResources$ MODULE$;

    static {
        new ModelResources$();
    }

    private void dumpModel(Product model, AlgorithmBuilding name, File folder, List<String> columns, Option<List<String>> classes) {
        LazyRef DssPipelineMeta$module = new LazyRef();
        FileOutputStream fos = new FileOutputStream(new File(folder, "dss_pipeline_model.gz"));
        GZIPOutputStream gz = new GZIPOutputStream(fos);
        OutputStreamWriter os = new OutputStreamWriter(gz);
        os.write(JsonConverters$.MODULE$.toJson(model).toString());
        os.close();
        gz.close();
        fos.close();
        public class Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1
        implements Product,
        scala.Serializable {
            private final String algorithm_name;
            private final List<String> columns;
            private final List<String> classes;
            private final String backend;

            public String algorithm_name() {
                return this.algorithm_name;
            }

            public List<String> columns() {
                return this.columns;
            }

            public List<String> classes() {
                return this.classes;
            }

            public String backend() {
                return this.backend;
            }

            public Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1 copy(String algorithm_name, List<String> columns, List<String> classes, String backend) {
                return new Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1(algorithm_name, columns, classes, backend);
            }

            public String copy$default$1() {
                return this.algorithm_name();
            }

            public List<String> copy$default$2() {
                return this.columns();
            }

            public List<String> copy$default$3() {
                return this.classes();
            }

            public String copy$default$4() {
                return this.backend();
            }

            public String productPrefix() {
                return "DssPipelineMeta";
            }

            public int productArity() {
                return 4;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return this.algorithm_name();
                    }
                    case 1: {
                        return this.columns();
                    }
                    case 2: {
                        return this.classes();
                    }
                    case 3: {
                        return this.backend();
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1 var4_3 = (Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1)x$1;
                String string = this.algorithm_name();
                String string2 = var4_3.algorithm_name();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                List<String> list = this.columns();
                List<String> list2 = var4_3.columns();
                if (list == null) {
                    if (list2 != null) {
                        return false;
                    }
                } else if (!list.equals(list2)) return false;
                List<String> list3 = this.classes();
                List<String> list4 = var4_3.classes();
                if (list3 == null) {
                    if (list4 != null) {
                        return false;
                    }
                } else if (!list3.equals(list4)) return false;
                String string3 = this.backend();
                String string4 = var4_3.backend();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
                if (!var4_3.canEqual(this)) return false;
                return true;
            }

            public Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1(String algorithm_name, List<String> columns, List<String> classes, String backend) {
                this.algorithm_name = algorithm_name;
                this.columns = columns;
                this.classes = classes;
                this.backend = backend;
                Product.$init$((Product)this);
            }
        }
        Com_dataiku_dip_spark_ml_ModelResources$DssPipelineMeta$1 meta = this.DssPipelineMeta$3(DssPipelineMeta$module).apply(name.toString(), columns, (List<String>)((List)classes.getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), this.DssPipelineMeta$3(DssPipelineMeta$module).apply$default$4());
        package$.MODULE$.printToFile(new File(folder, "dss_pipeline_meta.json"), (Function1<PrintWriter, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            ModelResources$.$anonfun$dumpModel$2(meta, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void dump(File file, Model<?> model, List<String> featureNames, Option<List<String>> classes) {
        File folder = file;
        List<String> names = featureNames;
        Option<List<String>> clazzes = classes;
        Model<?> model2 = model;
        if (model2 instanceof LinearRegressionModel) {
            LinearRegressionModel linearRegressionModel = (LinearRegressionModel)model2;
            this.dumpModel(this.linearRegressionData(linearRegressionModel), AlgorithmBuilding.LINEAR, folder, names, clazzes);
            return;
        }
        if (model2 instanceof DecisionTreeRegressionModel) {
            DecisionTreeRegressionModel decisionTreeRegressionModel = (DecisionTreeRegressionModel)model2;
            this.dumpModel(this.decisionTreeRegressorData(decisionTreeRegressionModel), AlgorithmBuilding.DECISION_TREE, folder, names, clazzes);
            return;
        }
        if (model2 instanceof WrappedDecisionTreeClassificationModel) {
            WrappedDecisionTreeClassificationModel wrappedDecisionTreeClassificationModel = (WrappedDecisionTreeClassificationModel)model2;
            this.dumpModel(this.decisionTreeClassifierData(wrappedDecisionTreeClassificationModel.treeModel()), AlgorithmBuilding.DECISION_TREE, folder, names, clazzes);
            return;
        }
        if (model2 instanceof RandomForestRegressionModel) {
            RandomForestRegressionModel randomForestRegressionModel = (RandomForestRegressionModel)model2;
            this.dumpModel(this.forestRegressorData(randomForestRegressionModel), AlgorithmBuilding.FOREST_REGRESSOR, folder, names, clazzes);
            return;
        }
        if (model2 instanceof RandomForestClassificationModel) {
            RandomForestClassificationModel randomForestClassificationModel = (RandomForestClassificationModel)model2;
            this.dumpModel(this.forestClassifierData(randomForestClassificationModel), AlgorithmBuilding.FOREST_CLASSIFIER, folder, names, clazzes);
            return;
        }
        if (model2 instanceof GBTRegressionModel) {
            GBTRegressionModel gBTRegressionModel = (GBTRegressionModel)model2;
            this.dumpModel(this.gbtRegressionData(gBTRegressionModel), AlgorithmBuilding.GRADIENT_BOOSTING_REGRESSOR, folder, names, clazzes);
            return;
        }
        if (model2 instanceof WrappedGBTClassificationModel) {
            WrappedGBTClassificationModel wrappedGBTClassificationModel = (WrappedGBTClassificationModel)model2;
            this.dumpModel(this.gbtClassifierData(wrappedGBTClassificationModel.gbtModel()), AlgorithmBuilding.GRADIENT_BOOSTING_CLASSIFIER, folder, names, clazzes);
            return;
        }
        if (model2 instanceof LogisticRegressionModel) {
            LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)model2;
            this.dumpModel(this.binaryLogisticRegressionData(logisticRegressionModel), AlgorithmBuilding.LOGISTIC, folder, names, clazzes);
            return;
        }
        if (model2 instanceof MulticlassLogisticRegressionModel) {
            MulticlassLogisticRegressionModel multiclassLogisticRegressionModel = (MulticlassLogisticRegressionModel)model2;
            this.dumpModel(this.multiclassLogisticRegressionData(multiclassLogisticRegressionModel), AlgorithmBuilding.LOGISTIC, folder, names, clazzes);
            return;
        }
        if (model2 instanceof RegressionH2OModel) {
            RegressionH2OModel regressionH2OModel = (RegressionH2OModel)model2;
            this.dumpH2ORegressor(regressionH2OModel, folder, (Seq<String>)names, clazzes);
            return;
        }
    }

    private void dumpH2ORegressor(RegressionH2OModel<?> model, File folder, Seq<String> featureNames, Option<List<String>> classes) {
        Object obj = model.serializableModel().getModel();
    }

    public <T> Object getField(T o, String name, ClassTag<T> evidence$1) {
        Object r;
        block0: {
            Field field = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getField(name);
            r = null;
            if (field.isAccessible()) break block0;
            field.setAccessible(true);
            r = field.get(o);
            field.setAccessible(false);
        }
        return r;
    }

    private ModelResources.DeepLearningInfo deepLearningData(DeepLearningModel model) {
        DeepLearningModelInfo info = model.model_info();
        String activation = info.parameters._activation.toString();
        String lossType = info.parameters._loss.toString();
        List biases = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Storage.DenseVector[])this.getField(info, "biases", ClassTag$.MODULE$.apply(DeepLearningModelInfo.class))))).map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$2.raw())).toList(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class))))).toList();
        List weights = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Storage.DenseRowMatrix[])this.getField(info, "dense_row_weights", ClassTag$.MODULE$.apply(DeepLearningModelInfo.class))))).map((Function1 & Serializable & scala.Serializable)mat -> (List)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(mat.raw())).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$3 -> x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).grouped(mat.rows()).toList().map((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$4)).toList(), List$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class))))).toList();
        return new ModelResources.DeepLearningInfo(activation, lossType, (List<List<Object>>)biases, (List<List<List<Object>>>)weights);
    }

    private ModelResources.LinearRegressionData linearRegressionData(LinearRegressionModel l) {
        return new ModelResources.LinearRegressionData(l.intercept(), (List<Object>)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(com.dataiku.dip.spark.compat.package$.MODULE$.getLinregCoefficients(l).toArray())).toList());
    }

    private Map<Object, Node> nodeMap(long index, Node n) {
        Node node = n;
        if (node instanceof InternalNode) {
            InternalNode internalNode = (InternalNode)node;
            return this.nodeMap(2L * index + 1L, internalNode.leftChild()).$plus$plus(this.nodeMap(2L * index + 2L, internalNode.rightChild())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)index)), (Object)internalNode));
        }
        if (node instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)node;
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)index)), (Object)leafNode)}));
        }
        throw new MatchError((Object)node);
    }

    private Map<Object, Object> buildThresholdRemapper(List<Node> allNodes) {
        List thresholds = (List)((SeqLike)((SeqLike)allNodes.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Node, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof InternalNode) {
                    InternalNode internalNode = (InternalNode)A1;
                    return (B1)BoxesRunTime.boxToDouble((double)((ContinuousSplit)internalNode.split()).threshold());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Node x1) {
                Node node = x1;
                return node instanceof InternalNode;
            }
        }, List$.MODULE$.canBuildFrom())).distinct()).sorted((Ordering)Ordering.Double$.MODULE$);
        if (thresholds.isEmpty()) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        if (thresholds.size() == 1) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(thresholds.head()), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)thresholds.head()) + 1.0E-4)))}));
        }
        return thresholds.sliding(2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list = x0$1;
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                double x = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(0));
                double y = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(1));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)x)), (Object)BoxesRunTime.boxToDouble((double)(x + scala.math.package$.MODULE$.min(y - x, 1.0E-4))));
            }
            throw new MatchError((Object)list);
        }).toMap(Predef$.MODULE$.$conforms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(thresholds.last()), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)thresholds.last()) + 1.0E-4))));
    }

    private ModelResources.DecisionTreeRegressorData decisionTreeRegressorData(DecisionTreeRegressionModel d) {
        Map<Object, Node> map = this.nodeMap(0L, d.rootNode());
        Map<Object, Object> thresholdRemapper = this.buildThresholdRemapper((List<Node>)map.values().toList());
        List nodes = ((TraversableOnce)map.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Node>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    long u = A1._1$mcJ$sp();
                    Node i = (Node)A1._2();
                    if (i instanceof InternalNode) {
                        InternalNode internalNode = (InternalNode)i;
                        return (B1)new Tuple2((Object)BoxesRunTime.boxToLong((long)u), (Object)internalNode);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Node> x1) {
                Node i;
                Tuple2<Object, Node> tuple2 = x1;
                return tuple2 != null && (i = (Node)tuple2._2()) instanceof InternalNode;
            }
        }, Map$.MODULE$.canBuildFrom())).toList();
        List leaves = ((TraversableOnce)map.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Node>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null) {
                    long u = A1._1$mcJ$sp();
                    Node l = (Node)A1._2();
                    if (l instanceof LeafNode) {
                        LeafNode leafNode = (LeafNode)l;
                        return (B1)new Tuple2((Object)BoxesRunTime.boxToLong((long)u), (Object)leafNode);
                    }
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Tuple2<Object, Node> x2) {
                Node l;
                Tuple2<Object, Node> tuple2 = x2;
                return tuple2 != null && (l = (Node)tuple2._2()) instanceof LeafNode;
            }
        }, Map$.MODULE$.canBuildFrom())).toList();
        List node_id = (List)nodes.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5._1$mcJ$sp()), List$.MODULE$.canBuildFrom());
        List leaf_id = (List)leaves.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6._1$mcJ$sp()), List$.MODULE$.canBuildFrom());
        List feature = (List)nodes.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ModelResources$.$anonfun$decisionTreeRegressorData$3(x$7)), List$.MODULE$.canBuildFrom());
        List threshold = (List)nodes.map((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToDouble((double)ModelResources$.$anonfun$decisionTreeRegressorData$4(thresholdRemapper, n)), List$.MODULE$.canBuildFrom());
        List label = (List)leaves.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)ModelResources$.$anonfun$decisionTreeRegressorData$5(x$8)), List$.MODULE$.canBuildFrom());
        return new ModelResources.DecisionTreeRegressorData((List<Object>)node_id, (List<Object>)feature, (List<Object>)threshold, (List<Object>)leaf_id, (List<Object>)label);
    }

    private ModelResources.ForestRegressorData forestRegressorData(RandomForestRegressionModel d) {
        return new ModelResources.ForestRegressorData((List<ModelResources.DecisionTreeRegressorData>)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])d.trees())).toList().map((Function1 & Serializable & scala.Serializable)t -> MODULE$.decisionTreeRegressorData((DecisionTreeRegressionModel)t), List$.MODULE$.canBuildFrom())));
    }

    private ModelResources.DecisionTreeClassifierData decisionTreeClassifierData(DecisionTreeClassificationModel t2) {
        Map<Object, Node> map = this.nodeMap(0L, t2.rootNode());
        Map<Object, Object> thresholdRemapper = this.buildThresholdRemapper((List<Node>)map.values().toList());
        List nodes = ((TraversableOnce)map.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Node>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    long u = A1._1$mcJ$sp();
                    Node i = (Node)A1._2();
                    if (i instanceof InternalNode) {
                        InternalNode internalNode = (InternalNode)i;
                        return (B1)new Tuple2((Object)BoxesRunTime.boxToLong((long)u), (Object)internalNode);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Node> x1) {
                Node i;
                Tuple2<Object, Node> tuple2 = x1;
                return tuple2 != null && (i = (Node)tuple2._2()) instanceof InternalNode;
            }
        }, Map$.MODULE$.canBuildFrom())).toList();
        List leaves = ((TraversableOnce)map.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Node>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null) {
                    long u = A1._1$mcJ$sp();
                    Node l = (Node)A1._2();
                    if (l instanceof LeafNode) {
                        LeafNode leafNode = (LeafNode)l;
                        return (B1)new Tuple2((Object)BoxesRunTime.boxToLong((long)u), (Object)leafNode);
                    }
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Tuple2<Object, Node> x2) {
                Node l;
                Tuple2<Object, Node> tuple2 = x2;
                return tuple2 != null && (l = (Node)tuple2._2()) instanceof LeafNode;
            }
        }, Map$.MODULE$.canBuildFrom())).toList();
        List node_id = (List)nodes.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9._1$mcJ$sp()), List$.MODULE$.canBuildFrom());
        List leaf_id = (List)leaves.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10._1$mcJ$sp()), List$.MODULE$.canBuildFrom());
        List feature = (List)nodes.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ModelResources$.$anonfun$decisionTreeClassifierData$3(x$11)), List$.MODULE$.canBuildFrom());
        List threshold = (List)nodes.map((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToDouble((double)ModelResources$.$anonfun$decisionTreeClassifierData$4(thresholdRemapper, n)), List$.MODULE$.canBuildFrom());
        List label = (List)leaves.map((Function1 & Serializable & scala.Serializable)t -> ModelResources$.getProbas$1((LeafNode)t._2()), List$.MODULE$.canBuildFrom());
        return new ModelResources.DecisionTreeClassifierData((List<Object>)node_id, (List<Object>)feature, (List<Object>)threshold, (List<Object>)leaf_id, (List<List<Object>>)label);
    }

    private ModelResources.ForestClassifierData forestClassifierData(RandomForestClassificationModel d) {
        return new ModelResources.ForestClassifierData((List<ModelResources.DecisionTreeClassifierData>)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])d.trees())).toList().map((Function1 & Serializable & scala.Serializable)t -> MODULE$.decisionTreeClassifierData((DecisionTreeClassificationModel)t), List$.MODULE$.canBuildFrom())));
    }

    private ModelResources.GradientBoostingData gbtRegressionData(GBTRegressionModel d) {
        List trees = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])d.trees())).toList().map((Function1 & Serializable & scala.Serializable)t -> MODULE$.decisionTreeRegressorData((DecisionTreeRegressionModel)t), List$.MODULE$.canBuildFrom());
        List treesRemapped = (List)((List)trees.zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(d.treeWeights()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ModelResources.DecisionTreeRegressorData t = (ModelResources.DecisionTreeRegressorData)tuple2._1();
                double w = tuple2._2$mcD$sp();
                return new ModelResources.DecisionTreeRegressorData(t.node_id(), t.feature(), t.threshold(), t.leaf_id(), (List<Object>)((List)t.label().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$15 -> x$15 * w, List$.MODULE$.canBuildFrom())));
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        return new ModelResources.GradientBoostingData(0.0, 1.0, (List<ModelResources.DecisionTreeRegressorData>)treesRemapped);
    }

    private ModelResources.GBTClassifierData gbtClassifierData(GBTClassificationModel d) {
        List trees = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])d.trees())).toList().map((Function1 & Serializable & scala.Serializable)t -> MODULE$.decisionTreeRegressorData((DecisionTreeRegressionModel)t), List$.MODULE$.canBuildFrom());
        List treesRemapped = (List)((List)trees.zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(d.treeWeights()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ModelResources.DecisionTreeRegressorData t = (ModelResources.DecisionTreeRegressorData)tuple2._1();
                double w = tuple2._2$mcD$sp();
                return new ModelResources.DecisionTreeRegressorData(t.node_id(), t.feature(), t.threshold(), t.leaf_id(), (List<Object>)((List)t.label().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$16 -> x$16 * w, List$.MODULE$.canBuildFrom())));
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        return new ModelResources.GBTClassifierData(1.0, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List<List<ModelResources.DecisionTreeRegressorData>>)((List)treesRemapped.map((Function1 & Serializable & scala.Serializable)t -> new .colon.colon(t, (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom())));
    }

    private ModelResources.LogisticRegressionData binaryLogisticRegressionData(LogisticRegressionModel model) {
        List modelCoef = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(com.dataiku.dip.spark.compat.package$.MODULE$.getLogitCoefficients(model).toArray())).toList();
        List dummyCoef = (List)modelCoef.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$17 -> 0.0, List$.MODULE$.canBuildFrom());
        return new ModelResources.LogisticRegressionData("MULTINOMIAL", (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, model.intercept()})), (List<List<Object>>)new .colon.colon((Object)dummyCoef, (List)new .colon.colon((Object)modelCoef, (List)Nil$.MODULE$)));
    }

    private ModelResources.LogisticRegressionData multiclassLogisticRegressionData(MulticlassLogisticRegressionModel model) {
        List dummyCoefs;
        int groupSize = model.weights().size() / (model.getNumClasses() - 1);
        List coefsGrouped = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(model.weights().toArray())).toList().grouped(groupSize).toList();
        List list = dummyCoefs = (List)((List)coefsGrouped.head()).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$18 -> 0.0, List$.MODULE$.canBuildFrom());
        List coefs = coefsGrouped.$colon$colon((Object)list);
        List intercepts = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), model.getNumClasses()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$20 -> 0.0, IndexedSeq$.MODULE$.canBuildFrom())).toList();
        return new ModelResources.LogisticRegressionData("MULTINOMIAL", (List<Object>)intercepts, (List<List<Object>>)coefs);
    }

    private static final /* synthetic */ ModelResources$DssPipelineMeta$2$ DssPipelineMeta$lzycompute$1(LazyRef DssPipelineMeta$module$1) {
        ModelResources$DssPipelineMeta$2$ modelResources$DssPipelineMeta$2$;
        LazyRef lazyRef = DssPipelineMeta$module$1;
        synchronized (lazyRef) {
            modelResources$DssPipelineMeta$2$ = DssPipelineMeta$module$1.initialized() ? (ModelResources$DssPipelineMeta$2$)((Object)DssPipelineMeta$module$1.value()) : (ModelResources$DssPipelineMeta$2$)((Object)DssPipelineMeta$module$1.initialize((Object)new ModelResources$DssPipelineMeta$2$()));
        }
        return modelResources$DssPipelineMeta$2$;
    }

    private final ModelResources$DssPipelineMeta$2$ DssPipelineMeta$3(LazyRef DssPipelineMeta$module$1) {
        if (DssPipelineMeta$module$1.initialized()) {
            return (ModelResources$DssPipelineMeta$2$)((Object)DssPipelineMeta$module$1.value());
        }
        return ModelResources$.DssPipelineMeta$lzycompute$1(DssPipelineMeta$module$1);
    }

    public static final /* synthetic */ void $anonfun$dumpModel$2(ModelResources.DssPipelineMeta.1 meta$1, PrintWriter x$1) {
        x$1.write(JsonConverters$.MODULE$.toJson(meta$1).toString());
    }

    public static final /* synthetic */ int $anonfun$decisionTreeRegressorData$3(Tuple2 x$7) {
        return ((InternalNode)x$7._2()).split().featureIndex();
    }

    public static final /* synthetic */ double $anonfun$decisionTreeRegressorData$4(Map thresholdRemapper$1, Tuple2 n) {
        return BoxesRunTime.unboxToDouble((Object)thresholdRemapper$1.apply((Object)BoxesRunTime.boxToDouble((double)((ContinuousSplit)((InternalNode)n._2()).split()).threshold())));
    }

    public static final /* synthetic */ double $anonfun$decisionTreeRegressorData$5(Tuple2 x$8) {
        return ((LeafNode)x$8._2()).prediction();
    }

    public static final /* synthetic */ int $anonfun$decisionTreeClassifierData$3(Tuple2 x$11) {
        return ((InternalNode)x$11._2()).split().featureIndex();
    }

    public static final /* synthetic */ double $anonfun$decisionTreeClassifierData$4(Map thresholdRemapper$2, Tuple2 n) {
        return BoxesRunTime.unboxToDouble((Object)thresholdRemapper$2.apply((Object)BoxesRunTime.boxToDouble((double)((ContinuousSplit)((InternalNode)n._2()).split()).threshold())));
    }

    public static final /* synthetic */ boolean $anonfun$decisionTreeClassifierData$5(Method x$12) {
        String string = x$12.getName();
        String string2 = "impurityStats";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$decisionTreeClassifierData$6(Method x$13) {
        String string = x$13.getName();
        String string2 = "stats";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final List getProbas$1(LeafNode leaf) {
        Object impurityStats = ((Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaf.getClass().getMethods())).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ModelResources$.$anonfun$decisionTreeClassifierData$5(x$12))).get()).invoke((Object)leaf, new Object[0]);
        List raw = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])((Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])impurityStats.getClass().getMethods())).find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ModelResources$.$anonfun$decisionTreeClassifierData$6(x$13))).get()).invoke(impurityStats, new Object[0]))).toList();
        double norm = BoxesRunTime.unboxToDouble((Object)raw.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (List)raw.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$14 -> x$14 / norm, List$.MODULE$.canBuildFrom());
    }

    private ModelResources$() {
        MODULE$ = this;
    }
}

