/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.LongDataMatrix;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;

public interface IDSSUsageStatsInternalDB {
    public void storeCommitsAnalysis(String var1, List<CommitAnalysis> var2, long var3) throws SQLException;

    public long getFirstDataTime(String var1) throws SQLException;

    public long getLastAnalyzedHour(String var1) throws SQLException;

    public void storeConnectionTask(ConnectionTask var1) throws SQLException;

    public void storeUserPresences(List<UserPresenceItem> var1) throws SQLException;

    public void storeProjectSave(String var1, String var2, long var3) throws SQLException;

    public ContributorsChartData getContributorsChart(String var1) throws Exception;

    public TimeSeries getGlobalProjectHoursWithWrites(String var1, long var2) throws SQLException, ParseException;

    public TimeSeries getGlobalCommits(String var1, long var2) throws SQLException, ParseException;

    public LongDataMatrix getTotalCommitsPerHour(String var1, long var2) throws SQLException, ParseException;

    public CommitsSummary getCommitsSummary(String var1, long var2) throws SQLException;

    public List<ProjectContributor> getPerContributorSummary(String var1, long var2) throws SQLException;

    public TimeSeries getProjectPresenceData(String var1, long var2) throws SQLException, ParseException;

    public long getFirstDataTime_cached(String var1) throws ExecutionException;

    public TimeSeries getGlobalCommits_cached(String var1, long var2) throws ExecutionException;

    public static class CommitsSummary {
        public int nbAuthors;
        public int nbCommits;
        public int added;
        public int removed;
    }

    public static class ProjectContributor {
        public String user;
        public int commits;
        public int addedLines;
        public int removedLines;
        public int writeHours;
        public long totalPresence;
    }

    public static class UserTimeSeries
    extends TimeSeries {
        public String user;

        public UserTimeSeries() {
        }

        public UserTimeSeries(String user, int nbBuckets) {
            super(nbBuckets);
            this.user = user;
        }
    }

    public static class TimeSeries
    implements Comparable<TimeSeries> {
        public LongDataList dayTS;
        public LongDataList value;
        public long totalValue;

        public TimeSeries() {
        }

        public TimeSeries(int nbBuckets) {
            this.dayTS = LongDataList.createNoMinMax(nbBuckets);
            this.value = LongDataList.createNoMinMax(nbBuckets);
        }

        public void compileTotalValue() {
            for (long _time : this.value.data) {
                this.totalValue += _time;
            }
        }

        @Override
        public int compareTo(TimeSeries o) {
            return -Long.compare(this.totalValue, o.totalValue);
        }

        public static TimeSeries interval(long start, int nbBuckets, int field, int amount) {
            TimeSeries ts = new TimeSeries(nbBuckets);
            Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            c2.setTimeInMillis(start);
            for (int i = 0; i < nbBuckets; ++i) {
                ts.dayTS.data[i] = c2.getTimeInMillis();
                c2.add(field, amount);
            }
            return ts;
        }

        public static TimeSeries daily(long start, int nbBuckets) {
            return TimeSeries.interval(start, nbBuckets, 5, 1);
        }

        public static TimeSeries hourly(long start, int nbBuckets) {
            return TimeSeries.interval(start, nbBuckets, 10, 1);
        }
    }

    public static class ContributorsChartData {
        public ContributorData global;
        public Map<String, ContributorData> perContributor = new HashMap<String, ContributorData>();
        public long minTS;
        public long maxTS;
        public LongDataList bucketsTS;
    }

    public static class ContributorData {
        public String contributor;
        public LongDataList commits;
        public LongDataList added;
        public LongDataList removed;
    }

    public static class CommitAnalysis {
        String projectKey;
        String author;
        String commitId;
        long timestamp;
        int addedFiles = 0;
        int removedFiles = 0;
        int changedFiles = 0;
        int addedLines = 0;
        int removedLines = 0;
    }

    public static class UserPresenceItem {
        public String user;
        public String projectKey;
        public long hourTimestamp;
        public long presenceTime;
    }

    public static class ConnectionTask {
        String projectKey;
        String connectionId;
        ConnectionTasksService.ConnectionTaskType taskType;
        JsonObject taskData = new JsonObject();
        String initiator;
        Long startTime;
        Long endTime;
    }
}

