/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AIVstack
extends AIRecipe {
    public static final String type = "vstack";
    public Params params;

    public VStackRecipePayloadParams.SchemaMergeMode getVstackMode() {
        if (this.params.stack_mode.equals((Object)StackMode.INTERSECTION)) {
            return VStackRecipePayloadParams.SchemaMergeMode.INTERSECT;
        }
        if (this.params.stack_mode.equals((Object)StackMode.USE_SCHEMA_FROM_DATASET)) {
            return VStackRecipePayloadParams.SchemaMergeMode.FROM_DATASET;
        }
        return VStackRecipePayloadParams.SchemaMergeMode.UNION;
    }

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkMultipleInputDatasets(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.stack_mode == null) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.VSTACK.UNABLE_TO_DETERMINE_COLUMN", "We were unable to determine what is the best suited column selection to stack your datasets, default will be union of input schemas", new Object[0])));
            this.params.stack_mode = StackMode.UNION;
        }
        if (this.params.stack_mode.equals((Object)StackMode.USE_SCHEMA_FROM_DATASET)) {
            if (StringUtils.isBlank((CharSequence)this.params.dataset_schema)) {
                creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.VSTACK.UNABLE_TO_DETERMINE_DATASET_SCHEMA", "We were unable to determine what dataset schema we should use to stack your datasets", new Object[0])));
            } else {
                boolean datasetExists = false;
                for (String dataset : AIRecipe.AIRecipeParams.getValidDatasetNames(datasets, this.params.input_datasets, contextProjectKey)) {
                    if (!dataset.equals(this.params.dataset_schema)) continue;
                    datasetExists = true;
                    break;
                }
                if (!datasetExists) {
                    creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translateNoContext(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.VSTACK.NOT_PART_OF_INPUT_DATASET", String.format("The dataset suggested to be used as a schema reference - %s - is not part of the input datasets", this.params.dataset_schema), "datasetSchema", this.params.dataset_schema)));
                    this.params.dataset_schema = null;
                }
            }
        }
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        List<String> inputDatasetNames = AIRecipe.AIRecipeParams.getValidDatasetNames(recipeGenerationContext.datasets, this.params.input_datasets, recipeGenerationContext.contextProjectKey);
        VStackRecipePayloadParams vStackRecipePayloadParams = new VStackRecipePayloadParams();
        vStackRecipePayloadParams.addOriginColumn = this.params.include_origin_column;
        vStackRecipePayloadParams.originColumnName = "original_dataset";
        vStackRecipePayloadParams.mode = this.getVstackMode();
        if (vStackRecipePayloadParams.mode.equals((Object)VStackRecipePayloadParams.SchemaMergeMode.FROM_DATASET)) {
            vStackRecipePayloadParams.copySchemaFromDatasetWithName = this.params.dataset_schema;
        }
        int index = 0;
        for (String d : inputDatasetNames) {
            VStackRecipePayloadParams.InputDesc input = new VStackRecipePayloadParams.InputDesc();
            input.name = d;
            input.index = index++;
            input.originLabel = d;
            vStackRecipePayloadParams.virtualInputs.add(input);
        }
        metaCreation.datasetInputNames = inputDatasetNames;
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)vStackRecipePayloadParams);
        return metaCreation;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public boolean include_origin_column = false;
        public StackMode stack_mode;
        public String dataset_schema;
    }

    public static enum StackMode {
        UNION,
        INTERSECTION,
        USE_SCHEMA_FROM_DATASET;

    }
}

