/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class ExtractToPrecision
implements ModelExtractor<String> {
    private final JsonPath compiled;
    private final String jsonPath;
    private final int precision;

    public static String toPrecision(double number, int digits) {
        return String.format("%." + (digits > 0 ? digits : 16) + "g", number).replace("e+0", "e+").replace("e-0", "e-");
    }

    public ExtractToPrecision(String jsonPath, int precision) {
        this.compiled = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        this.jsonPath = jsonPath;
        this.precision = precision;
    }

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            Object out = documentContext.read(this.compiled);
            if (out instanceof Number) {
                return ExtractToPrecision.toPrecision(((Number)out).doubleValue(), this.precision);
            }
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
        catch (PathNotFoundException e) {
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
    }
}

