/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.PackagedFullModelId;
import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDataModelBuilder;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentLocalSummary;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentRemoteSummary;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksEndpointDetailsComparator;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.DatabricksDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.AbstractFullyManagedAPIServiceDeploymentManager;
import com.dataiku.dip.apideployer.deployments.DatabricksDeploymentConfigManager;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksInputValidator;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModelVersion;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointState;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksEndpoint;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksModelVersion;
import com.dataiku.dip.externalinfras.databricks.http.get.DatabricksExperimentMetadataResponse;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.scoring.exports.ExportAndRegisterMLflowModelInFutureThread;
import com.dataiku.dip.scoring.exports.MLflowScoring;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.client.DatabricksLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DatabricksDeploymentManager
extends AbstractFullyManagedAPIServiceDeploymentManager {
    private static final PythonCodeEnvPackagesUtils.PythonPackageVersion MINIMUM_NON_DEPRECATED_PYTHON_VERSION = PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString("3.8.0");
    private final DatabricksAPIDeployment deployment;
    private final DatabricksAPIDeploymentInfra infra;
    private final DatabricksDeploymentConfigManager deploymentConfigManager;
    private final DatabricksDeploymentStatusReporter deploymentStatusReporter;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.databricks.manager");

    public DatabricksDeploymentManager(AuthCtx authCtx, DatabricksAPIDeployment deployment, DatabricksAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.deployment = deployment;
        this.deployment.overrideSettings.applyToDeployment(this.deployment, infra);
        this.infra = infra;
        this.deploymentConfigManager = new DatabricksDeploymentConfigManager(deployment, infra, this.getVariablesContext());
        this.deploymentStatusReporter = new DatabricksDeploymentStatusReporter(deployment.id, infra.id);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected DatabricksAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected DatabricksAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    protected DatabricksDeploymentHeavyStatus createNewHeavyStatus(String deploymentId, String infraId) {
        return new DatabricksDeploymentHeavyStatus(deploymentId, infraId);
    }

    @Override
    protected int numberOfDeploymentSteps() {
        return this.deployment.enabled ? 7 : 1;
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"sync_databricks_api_deployment", (String)("Sync Databricks deployment: " + this.deployment.id));
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "Databricks";
    }

    @Override
    @Nonnull
    protected InfoMessage.InfoMessages doDeployment(DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        logger.infoV("Prepare sync of deployment %s", new Object[]{this.deployment.id});
        logger.info((Object)"Summary of the DSS resources used to update the deployment:");
        logger.infoV("Databricks infra: %s", new Object[]{JSON.json((Object)this.infra)});
        logger.infoV("Databricks deployment: %s", new Object[]{JSON.json((Object)this.deployment)});
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"api_deployer", (String)this.deployment.id, (boolean)true);){
            FutureProgress.AutocloseableFutureProgressState ignored;
            DatabricksServingEndpointDetails endpointDetails;
            FutureProgress.AutocloseableFutureProgressState ignored2;
            DatabricksRegisteredModelVersion modelVersion;
            DatabricksModelDeploymentConnection connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
            if (connection == null || this.infra.authConnection == null) {
                throw ErrorContext.ice((String)"No connection defined in the infrastructure.");
            }
            DatabricksDeploymentInfo previousDeploymentInfo = this.getDeploymentInfo();
            if (!this.deployment.enabled) {
                this.disableDeployment(connection, previousDeploymentInfo, logTailBuilder);
                FutureProgress.incrementState((double)1.0);
                InfoMessage.InfoMessages infoMessages = ret;
                return infoMessages;
            }
            PublishedApiServicePackageInfo packageInfo = this.getPackageInfo_NT();
            this.deployment.verifyPackageCompatibility(packageInfo);
            DatabricksDeploymentLocalSummary localSummary = DatabricksDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), previousDeploymentInfo);
            DatabricksDeploymentRemoteSummary remoteSummary = DatabricksDeploymentRemoteSummary.buildFromRemoteConfig_NT(previousDeploymentInfo, this.authCtx, this.infra.authConnection);
            String experimentName = this.deploymentConfigManager.generateExperimentName();
            DatabricksInputValidator.validateExperimentName(experimentName);
            FutureProgress.incrementState((double)1.0);
            boolean usesUnityCatalog = this.deployment.usesUnityCatalog(this.infra);
            try (FutureProgress.AutocloseableFutureProgressState ignored3 = FutureProgress.pushAutoCloseableState((String)"Exporting and registering model in Databricks");){
                logTailBuilder.appendLine("Exporting and registering model in Databricks...");
                BundledSMVersion smv = this.getSMVersion(packageInfo);
                PackagedFullModelId fullModelId = this.getFullModelId(smv, (File)tmpDir);
                ret.mergeFrom(this.verifyModelIsCompatible(fullModelId));
                String modelName = this.deploymentConfigManager.generateModelName(smv, usesUnityCatalog, this.infra.defaultCatalogName, this.infra.defaultSchemaName);
                modelVersion = this.exportAndRegisterMLflowModel(fullModelId, experimentName, usesUnityCatalog, modelName, connection);
                logTailBuilder.appendLine(String.format("Databricks model registered with name '%s', version '%s'", modelVersion.name, modelVersion.version));
            }
            FutureProgress.incrementState((double)1.0);
            try {
                ignored2 = FutureProgress.pushAutoCloseableState((String)"Serving model via a Databricks endpoint");
                try {
                    logTailBuilder.appendLine("Serving model via a Databricks endpoint...");
                    endpointDetails = this.createOrUpdateEndpoint(connection, modelVersion, localSummary.endpoint, remoteSummary.endpoint, logTailBuilder);
                    logTailBuilder.appendLine(String.format("Databricks serving endpoint creation/update started: '%s'", endpointDetails.name));
                }
                finally {
                    if (ignored2 != null) {
                        ignored2.close();
                    }
                }
            }
            catch (Exception e) {
                this.deleteNewModelVersionAfterFailure(connection, modelVersion, localSummary.modelVersion, usesUnityCatalog);
                throw e;
            }
            FutureProgress.incrementState((double)1.0);
            ignored2 = FutureProgress.pushAutoCloseableState((String)"Waiting for Databricks serving endpoint to be ready");
            try {
                logTailBuilder.appendLine("Waiting for Databricks serving endpoint to be ready...");
                DatabricksServingEndpointDetails finalEndpointDetails = DatabricksUtils.awaitEndpointCreationResult_NT(this.authCtx, this.infra.authConnection, endpointDetails.name, this.connectTimeout, this.socketTimeout);
                ret.mergeFrom(this.verifyEndpointReadiness(endpointDetails.name, finalEndpointDetails));
                logTailBuilder.appendLine(String.format("Databricks serving endpoint creation/update finished: '%s'", endpointDetails.name));
            }
            finally {
                if (ignored2 != null) {
                    ignored2.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
            String experimentId = null;
            try {
                ignored = FutureProgress.pushAutoCloseableState((String)"Fetching Databricks experiment metadata");
                try {
                    logTailBuilder.appendLine("Fetching Databricks experiment metadata...");
                    DatabricksExperimentMetadataResponse response = DatabricksUtils.getExperimentByName(this.authCtx, connection, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout(), experimentName);
                    experimentId = response == null ? null : response.experiment.experimentId;
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Failed to fetch metadata of the '%s' experiment", new Object[]{experimentName});
            }
            FutureProgress.incrementState((double)1.0);
            ignored = FutureProgress.pushAutoCloseableState((String)"Saving changes");
            try {
                logTailBuilder.appendLine("Updating deployment changes...");
                String hostBaseUrl = connection.params.host;
                DatabricksDeploymentInfo newDeploymentInfo = new DatabricksDeploymentInfo(this.infra, this.deployment, hostBaseUrl, modelVersion, experimentName, experimentId, endpointDetails);
                this.deploymentInfoCRUDService.save(newDeploymentInfo);
                logTailBuilder.appendLine(String.format("Changes saved for deployment with id %s.", this.deployment.id));
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
            ignored = FutureProgress.pushAutoCloseableState((String)"Delete previous Databricks resources");
            try {
                logTailBuilder.appendLine("Deleting previous Databricks resources...");
                if (previousDeploymentInfo.dbxExperimentRunId != null) {
                    try {
                        this.deleteExperimentRun(connection, previousDeploymentInfo.dbxExperimentRunId, logTailBuilder);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while deleting a Databricks experiment run", (Throwable)e);
                    }
                }
                if (previousDeploymentInfo.dbxModelName != null && previousDeploymentInfo.dbxModelVersion != null) {
                    try {
                        this.deleteModelVersion(connection, previousDeploymentInfo.dbxModelName, previousDeploymentInfo.dbxModelVersion, previousDeploymentInfo.usesUnityCatalog, logTailBuilder);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while deleting a Databricks model version", (Throwable)e);
                    }
                }
                logTailBuilder.appendLine("Previous Databricks resources deleted.");
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
        }
        return ret;
    }

    @Override
    public DatabricksDeploymentHeavyStatus getStatus_Unsafe_NT(boolean withPackageExtraInfo, @Nullable String overridingConnectionName) throws IOException, InterruptedException, DKUSecurityException, URISyntaxException, AzureMLUtils.AzureAuthenticationException, SQLException {
        String usedConnectionName;
        DatabricksDeploymentHeavyStatus status = new DatabricksDeploymentHeavyStatus(this.deployment.id, this.deployment.infraId);
        status.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(this.deployment.publishedServiceId, this.authCtx);
        String string = usedConnectionName = overridingConnectionName != null ? overridingConnectionName : this.infra.authConnection;
        if (StringUtils.isEmpty((CharSequence)usedConnectionName)) {
            throw ErrorContext.ice((String)"Databricks model deployment connection is not defined");
        }
        DatabricksDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        DatabricksDeploymentLocalSummary localSummary = DatabricksDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        DatabricksServingEndpointDetails endpoint = DatabricksUtils.getEndpointOrNull(this.authCtx, usedConnectionName, deploymentInfo.dbxEndpointName, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        status.endpoints = status.summarizeEndpoints_NT(this.deployment, withPackageExtraInfo);
        status.checkEndpointHealth(localSummary, endpoint, this.deployment.enabled);
        return status;
    }

    @Override
    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean forTest) throws IOException, DKUSecurityException, URISyntaxException, InterruptedException, AzureMLUtils.AzureAuthenticationException, SQLException {
        DatabricksDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        return DatabricksLambdaAPIClient.runQueries_NT(this.authCtx, this.infra, deploymentInfo.dbxEndpointName, allQueries, forTest);
    }

    @Override
    protected DatabricksDeploymentConfigManager getConfigManager() {
        return this.deploymentConfigManager;
    }

    @Override
    protected DatabricksDeploymentStatusReporter getDeploymentStatusReporter() {
        return this.deploymentStatusReporter;
    }

    @Override
    public DeploymentStatusReport getFullCheckReport_NT() throws Exception {
        String usedConnectionName = this.infra.authConnection;
        if (StringUtils.isEmpty((CharSequence)usedConnectionName)) {
            throw ErrorContext.ice((String)"Databricks model deployment connection is not defined");
        }
        DatabricksDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        DatabricksDeploymentLocalSummary localSummary = DatabricksDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        DatabricksDeploymentRemoteSummary remoteSummary = DatabricksDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, this.authCtx, usedConnectionName);
        return this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
    }

    @Override
    public void deleteResources_NT() throws CodedException, IOException {
        DatabricksModelDeploymentConnection connection;
        DatabricksDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        try {
            connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
        }
        catch (DKUSecurityException e) {
            String message = "Error while accessing connection details";
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)(e.getCode() != null ? e.getCode() : DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_INVALID_CONNECTION), message, (Throwable)e);
        }
        this.deleteResources(connection, deploymentInfo, null);
        this.deploymentInfoCRUDService.delete(this.deployment.infraId, this.deployment.id);
    }

    @Override
    protected String diagnosisInternal(File tmpDir, String fileFriendlyLocalNow, FutureThreadBase<?> future) throws Exception {
        logger.infoV("Generating diagnostic of  %s...", new Object[]{this.deployment.id});
        DatabricksDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        if (StringUtils.isEmpty((CharSequence)this.infra.authConnection)) {
            throw ErrorContext.ice((String)"Databricks model deployment connection is not defined");
        }
        JSON.prettyToFile((Object)this.deployment, (File)new File(tmpDir, "deployment.json"));
        JSON.prettyToFile((Object)deploymentInfo, (File)new File(tmpDir, "deployment-info.json"));
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.infoV("Diagnosis requested by a user with admin permissions on infra. Including %s configuration file.", new Object[]{"infra.json"});
            JSON.prettyToFile((Object)this.infra, (File)new File(tmpDir, "infra.json"));
        } else {
            logger.infoV("Diagnosis requested by a user without admin permissions on infra. Not including configuration file %s.", new Object[]{"infra.json"});
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch summaries of Databricks resources");
        DatabricksDeploymentLocalSummary localSummary = DatabricksDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        DatabricksDeploymentRemoteSummary remoteSummary = DatabricksDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, this.authCtx, this.infra.authConnection);
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"Diagnosis requested by a user with admin permissions on infra. Including local and remote summary files.");
            JSON.prettyToFile((Object)localSummary, (File)new File(tmpDir, "local-summary.json"));
            JSON.prettyToFile((Object)remoteSummary, (File)new File(tmpDir, "remote-summary.json"));
        } else {
            logger.info((Object)"Diagnosis requested by a user without admin permissions on infra. Not including local and remote summary files.");
        }
        DeploymentStatusReport statusReport = this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
        JSON.prettyToFile((Object)statusReport, (File)new File(tmpDir, "status-report.json"));
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch versions");
        JsonObject versions = new JsonObject();
        versions.addProperty("dss-version", DKUApp.getDSSVersion().product_version);
        JSON.prettyToFile((Object)versions, (File)new File(tmpDir, "versions.json"));
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"User has infra admin permissions ; adding deployment logs");
            File logsDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"deployment-logs"});
            DKUFileUtils.mkdirs((File)logsDir);
            for (Path path : this.apiServiceDeploymentsService.listLogFiles(this.deployment)) {
                FileUtils.copyFileToDirectory((File)path.toFile(), (File)logsDir);
            }
        } else {
            logger.info((Object)"User does not have infra admin permissions ; not adding deployment logs");
        }
        return tmpDir.getName();
    }

    @Nonnull
    private DatabricksDeploymentInfo getDeploymentInfo() throws IOException {
        DatabricksDeploymentInfo deploymentInfo = this.deploymentInfoCRUDService.get(this.infra.id, this.deployment.id, DatabricksDeploymentInfo.class);
        return (DatabricksDeploymentInfo)ObjectUtils.defaultIfNull((Object)deploymentInfo, (Object)new DatabricksDeploymentInfo(this.infra, this.deployment));
    }

    @Nonnull
    private PackagedFullModelId getFullModelId(@Nonnull BundledSMVersion smv, @Nonnull File tmpDir) throws IOException {
        File zippedPackageFile = this.publishedAPIServicesService.getPublishedPackageFileMandatory(this.deployment.publishedServiceId, this.deployment.getActiveGeneration());
        File unzippedPackageDir = new File(tmpDir, "published-package-version");
        ZipUnzipDir.extractFolder(zippedPackageFile, unzippedPackageDir, false);
        File modelFolder = DKUFileUtils.getWithin((File)unzippedPackageDir, (String[])new String[]{"models", smv.id});
        return new PackagedFullModelId(smv.originalProjectKey, smv.originalSavedModelId, smv.originalSavedModelVersion, modelFolder);
    }

    @Nonnull
    BundledSMVersion getSMVersion(@Nonnull PublishedApiServicePackageInfo packageInfo) throws UnsupportedOperationException {
        PredictionEndpointConfig predictionEndpointConfig = this.getPredictionEndpointConfig(packageInfo);
        return packageInfo.stdModels.stream().filter(modelVersion -> modelVersion.id.equals(predictionEndpointConfig.modelId)).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("Model '%s' not found in version '%s'.", predictionEndpointConfig.modelId, packageInfo.id)));
    }

    @Nonnull
    private PredictionEndpointConfig getPredictionEndpointConfig(@Nonnull PublishedApiServicePackageInfo packageInfo) throws UnsupportedOperationException {
        LambdaEndpointConfig lambdaEndpointConfig = packageInfo.endpoints.stream().filter(endpoint -> endpoint.id.equals(this.deployment.endpointId)).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("DSS endpoint %s not found in version %s.", this.deployment.endpointId, packageInfo.id)));
        if (!(lambdaEndpointConfig instanceof PredictionEndpointConfig)) {
            throw new UnsupportedOperationException("Databricks deployments only support DSS Prediction endpoints.");
        }
        return (PredictionEndpointConfig)lambdaEndpointConfig;
    }

    private InfoMessage.InfoMessages verifyModelIsCompatible(FullModelId fmi) throws UnsupportedOperationException, IOException {
        MLflowScoring mlflowScoring = new MLflowScoring(fmi, true);
        CompatibilityWithReason compatibility = mlflowScoring.getCompatibility();
        if (!compatibility.compatible) {
            throw new UnsupportedOperationException(compatibility.reason);
        }
        return DatabricksDeploymentManager.checkPythonVersion(mlflowScoring.getPythonVersion());
    }

    private InfoMessage.InfoMessages verifyEndpointReadiness(String name, DatabricksServingEndpointDetails details) throws UnsupportedOperationException {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (details == null) {
            return messages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_ENDPOINT_NON_EXISTENT, "Cannot verify serving endpoint's state: '%s'", new Object[]{name});
        }
        DatabricksServingEndpointState.ConfigUpdate configUpdateState = details.state.configUpdate;
        if (configUpdateState == DatabricksServingEndpointState.ConfigUpdate.IN_PROGRESS) {
            return messages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_IN_PROGRESS, "");
        }
        if (configUpdateState == DatabricksServingEndpointState.ConfigUpdate.UPDATE_CANCELED) {
            return messages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_CANCELED, "");
        }
        if (configUpdateState == DatabricksServingEndpointState.ConfigUpdate.UPDATE_FAILED) {
            return messages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_FAILURE, "Check deployment and Databricks serving endpoint logs");
        }
        return messages;
    }

    private static InfoMessage.InfoMessages checkPythonVersion(@Nullable String pythonVersion) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (pythonVersion == null) {
            return messages;
        }
        PythonCodeEnvPackagesUtils.PythonPackageVersion pythonPackageVersion = PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString(pythonVersion);
        if (pythonPackageVersion.lt(MINIMUM_NON_DEPRECATED_PYTHON_VERSION)) {
            messages.withWarningV((InfoMessage.MessageCode)DeployerCodes.WARN_API_DEPLOYER_DATABRICKS_DEPRECATED_PYTHON_VERSION, "Exporting to MLflow a model using a python version < 3.8 (%s) is deprecated by Databricks. This may cause errors when creating the serving endpoint.", new Object[]{pythonVersion});
        }
        return messages;
    }

    private DatabricksRegisteredModelVersion exportAndRegisterMLflowModel(FullModelId fmi, String experimentName, boolean useUnityCatalog, String externalModelName, DatabricksModelDeploymentConnection connection) throws Exception {
        ArrayList<File> logFiles = new ArrayList<File>();
        logFiles.add(this.getDeploymentsService().getDeploymentLogFile(this.deployment));
        logFiles.add(this.deploymentUpdateService.getLastUpdateLogsFile(this.getInfra(), this.getDeployment()));
        DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse response = this.startExportAndRegisterMLflowModel(fmi, experimentName, useUnityCatalog, externalModelName, connection, logFiles);
        logger.infoV("Waiting until registered model '%s', version '%s', is ready", new Object[]{response.name, response.version});
        return DatabricksUtils.getRegisteredModelVersionWhenReady(this.authCtx, connection, useUnityCatalog, response.name, response.version, logFiles);
    }

    private DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse startExportAndRegisterMLflowModel(FullModelId fmi, String experimentName, boolean useUnityCatalog, String externalModelName, DatabricksModelDeploymentConnection connection, List<File> logFiles) throws Exception {
        logger.infoV("Registering model '%s' as a new Databricks model named '%s' in experiment '%s'", new Object[]{fmi, externalModelName, experimentName});
        ExportAndRegisterMLflowModelInFutureThread exportAndRegisterMLflowModelInFutureThread = new ExportAndRegisterMLflowModelInFutureThread(this.authCtx, fmi, connection, useUnityCatalog, externalModelName, experimentName, logFiles);
        exportAndRegisterMLflowModelInFutureThread.execute();
        return (DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse)exportAndRegisterMLflowModelInFutureThread.getResult();
    }

    private DatabricksServingEndpointDetails createOrUpdateEndpoint(@Nonnull DatabricksModelDeploymentConnection connection, @Nonnull DatabricksRegisteredModelVersion registeredModelVersion, @Nullable DatabricksEndpoint localEndpoint, @Nullable DatabricksServingEndpointDetails remoteEndpoint, @Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        DatabricksModelVersion modelVersion = DatabricksDataModelBuilder.buildModelVersion(registeredModelVersion);
        if (localEndpoint == null) {
            String endpointName = this.deploymentConfigManager.generateEndpointName();
            logger.infoV("Creating a new Databricks serving endpoint with name '%s'.", new Object[]{endpointName});
            DatabricksEndpoint endpoint = DatabricksDataModelBuilder.buildEndpoint(endpointName, this.deployment, this.infra, this.getVariablesContext());
            return DatabricksUtils.createEndpoint(this.authCtx, connection, this.connectTimeout, this.socketTimeout, modelVersion, endpoint);
        }
        String endpointName = localEndpoint.name;
        if (remoteEndpoint == null) {
            logger.warnV("Endpoint %s is not present on Databricks. It must have been deleted manually. Recreating a new one with same name.", new Object[]{endpointName});
            return DatabricksUtils.createEndpoint(this.authCtx, connection, this.connectTimeout, this.socketTimeout, modelVersion, localEndpoint);
        }
        DatabricksEndpointDetailsComparator endpointDetailsComparator = new DatabricksEndpointDetailsComparator(localEndpoint, modelVersion);
        if (endpointDetailsComparator.isOutOfSyncUnrecoverable(remoteEndpoint)) {
            logger.infoV("Endpoint %s is out of sync but can't be updated. Deleting the old one then recreating a new one with same name.", new Object[]{endpointName});
            this.deleteServingEndpoint(connection, endpointName, logTailBuilder);
            return DatabricksUtils.createEndpoint(this.authCtx, connection, this.connectTimeout, this.socketTimeout, modelVersion, localEndpoint);
        }
        if (endpointDetailsComparator.isOutOfSyncRecoverable(remoteEndpoint)) {
            logger.infoV("Endpoint %s is out of sync. Updating it.", new Object[]{endpointName});
            return DatabricksUtils.updateEndpoint(this.authCtx, connection, this.connectTimeout, this.socketTimeout, modelVersion, localEndpoint, remoteEndpoint);
        }
        logger.infoV("Endpoint %s doesn't seem out of sync, let's update it anyway.", new Object[]{endpointName});
        return DatabricksUtils.updateEndpoint(this.authCtx, connection, this.connectTimeout, this.socketTimeout, modelVersion, localEndpoint, remoteEndpoint);
    }

    private void disableDeployment(DatabricksModelDeploymentConnection connection, DatabricksDeploymentInfo deploymentInfo, DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        String disablingMessage = String.format("Deployment '%s' disabled, deleting deployed serving endpoint, exported model version and experiment run.", this.deployment.id);
        logger.info((Object)disablingMessage);
        logTailBuilder.appendLine(disablingMessage);
        this.deleteResources(connection, deploymentInfo, logTailBuilder);
        logTailBuilder.appendLine("Saving deployment changes...");
        deploymentInfo.dbxModelVersion = null;
        deploymentInfo.dbxExperimentRunId = null;
        this.deploymentInfoCRUDService.save(deploymentInfo);
        logTailBuilder.appendLine(String.format("Changes saved for deployment '%s'.", this.deployment.id));
    }

    private void deleteResources(DatabricksModelDeploymentConnection connection, DatabricksDeploymentInfo deploymentInfo, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        if (deploymentInfo.dbxEndpointName != null) {
            this.deleteServingEndpoint(connection, deploymentInfo.dbxEndpointName, logTailBuilder);
        }
        if (deploymentInfo.dbxModelVersion != null && deploymentInfo.dbxModelName != null) {
            this.deleteModelVersion(connection, deploymentInfo.dbxModelName, deploymentInfo.dbxModelVersion, deploymentInfo.usesUnityCatalog, logTailBuilder);
        }
        if (deploymentInfo.dbxExperimentRunId != null) {
            this.deleteExperimentRun(connection, deploymentInfo.dbxExperimentRunId, logTailBuilder);
        }
    }

    private void deleteServingEndpoint(DatabricksModelDeploymentConnection connection, @Nonnull String endpointName, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        String message = String.format("Deleting Databricks serving endpoint '%s'", endpointName);
        logger.info((Object)message);
        if (logTailBuilder != null) {
            logTailBuilder.appendLine(message);
        }
        try {
            DatabricksUtils.deleteEndpoint(this.authCtx, connection, this.connectTimeout, this.socketTimeout, endpointName);
        }
        catch (Exception e) {
            String errorMessage = String.format("Error deleting Databricks serving endpoint '%s' associated to the deployment '%s'.", endpointName, this.deployment.id);
            logger.error((Object)errorMessage, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, errorMessage + " " + e.getMessage());
        }
    }

    private void deleteModelVersion(DatabricksModelDeploymentConnection connection, @Nonnull String modelName, @Nonnull String modelVersion, boolean isInUnityCatalog, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        String message = String.format("Deleting Databricks model version. Model name '%s', version '%s'.", modelName, modelVersion);
        logger.info((Object)message);
        if (logTailBuilder != null) {
            logTailBuilder.appendLine(message);
        }
        try {
            DatabricksUtils.deleteModelVersion(this.authCtx, connection, this.connectTimeout, this.socketTimeout, modelName, modelVersion, isInUnityCatalog);
        }
        catch (Exception e) {
            String errorMessage = String.format("Error deleting version '%s' of Databricks model '%s' associated to the deployment '%s'.", modelVersion, modelName, this.deployment.id);
            logger.error((Object)errorMessage, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, errorMessage + " " + e.getMessage());
        }
    }

    private void deleteNewModelVersionAfterFailure(DatabricksModelDeploymentConnection connection, @Nonnull DatabricksRegisteredModelVersion newModelVersion, @Nullable DatabricksModelVersion oldModelVersion, boolean isInUnityCatalog) {
        if (oldModelVersion == null || !oldModelVersion.equalsToRegisteredModelVersion(newModelVersion)) {
            logger.debugV("Rolling back to previously created model version. Deleting unused model version. Model name '%s', version '%s'.", new Object[]{newModelVersion.name, newModelVersion.version});
            try {
                this.deleteModelVersion(connection, newModelVersion.name, newModelVersion.version, isInUnityCatalog, null);
                logger.debug((Object)"Databricks model version rollback successful.");
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Error deleting model version. Model name '%s', version '%s'.", new Object[]{newModelVersion.name, newModelVersion.version});
            }
        }
    }

    private void deleteExperimentRun(DatabricksModelDeploymentConnection connection, @Nonnull String runId, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        String message = String.format("Deleting Databricks experiment run with id '%s'.", runId);
        logger.info((Object)message);
        if (logTailBuilder != null) {
            logTailBuilder.appendLine(message);
        }
        try {
            DatabricksUtils.deleteExperimentRun(this.authCtx, connection, this.connectTimeout, this.socketTimeout, runId);
        }
        catch (Exception e) {
            String errorMessage = String.format("Error deleting Databricks experiment run with id '%s' associated to the deployment '%s'.", runId, this.deployment.id);
            logger.error((Object)errorMessage, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, errorMessage + " " + e.getMessage());
        }
    }
}

