/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.K8SDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.k8s.K8SDeploymentHealthReporter;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.apideployer.deployments.APINodeDeploymentQuerier;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentManager;
import com.dataiku.dip.apideployer.engine.DeploymentException;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.exposition.AbstractExposedEndpointCollector;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionRegistry;
import com.dataiku.dip.externalinfras.k8s.cli.GetDeploymentResponse;
import com.dataiku.dip.futures.AutoSmartLogTailRedirect;
import com.dataiku.dip.futures.ExtraLogFileAppender;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.futures.StateLabelAggregator;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class SingleK8SDeploymentManager
extends AbstractAPIServiceDockerDeploymentManager {
    private final K8SAPIServiceDeployment deployment;
    private final K8SAPIDeploymentInfra infra;
    private ClusterSettings clusterSettings;
    private ContainerExecRuntimeConfig k8sConfig;
    private List<String> k8sBaseCommand;
    private Map<String, String> k8sBaseEnv;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.k8s.manager");

    SingleK8SDeploymentManager(AuthCtx authCtx, K8SAPIServiceDeployment deployment, K8SAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.deployment = (K8SAPIServiceDeployment)JSON.deepCopy((Object)deployment);
        this.deployment.overrideSettings.applyToDeployment(this.deployment, infra);
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected K8SAPIServiceDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected K8SAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    protected K8SDeploymentHeavyStatus createNewHeavyStatus(String deploymentId, String infraId) {
        return new K8SDeploymentHeavyStatus(deploymentId, infraId);
    }

    @Override
    protected int numberOfDeploymentSteps() {
        if (!this.deployment.enabled) {
            return 5;
        }
        return DKUApp.isDataikuCloud() ? 6 : 7;
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"sync_k8s_api_deployment", (String)("Sync Kubernetes deployment: " + this.deployment.id));
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "Kubernetes";
    }

    @Override
    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean forTest) throws IOException {
        return new APINodeDeploymentQuerier().runQueries_NT(deployedServiceId, endpoint, lightStatus, heavyStatus, allQueries, this.infra.shouldTrustAllCertificates(), forTest);
    }

    private String k8sDeploymentId() {
        return "dku-mad-" + this.k8sExecutionId();
    }

    private String k8sExecutionId() {
        return APIDeployerImageBuilderService.sanitizeDeploymentId(this.deployment.id);
    }

    private List<String> getBaseK8SCommand() throws IOException, DKUSecurityException, InterruptedException {
        this.ensureK8SBases();
        return Lists.newArrayList(this.k8sBaseCommand);
    }

    private List<String> getK8SCommand(List<String> args) throws IOException, DKUSecurityException, InterruptedException {
        List<String> command = this.getBaseK8SCommand();
        command.addAll(args);
        return command;
    }

    private Map<String, String> getBaseK8SEnv() throws IOException, DKUSecurityException, InterruptedException {
        this.ensureK8SBases();
        return this.k8sBaseEnv;
    }

    private void ensureK8SBases() throws IOException, DKUSecurityException, InterruptedException {
        if (this.k8sBaseCommand == null) {
            this.clusterSettings = new ClusterSelector().selectForAPIDeployer(this.authCtx, this.infra.id);
            ContainerExecRuntimeConfig inlineConfig = new ContainerExecRuntimeConfig();
            inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
            inlineConfig.kubeCtlContext = this.infra.k8sContext;
            inlineConfig.kubeConfigPath = this.infra.k8sConfigPath;
            inlineConfig.kubernetesNamespace = this.infra.getK8sNamespace();
            inlineConfig.prePushMode = this.infra.prePushMode;
            inlineConfig.prePushScript = this.infra.prePushScript;
            inlineConfig.baseImage = this.infra.baseImageTag;
            inlineConfig.repositoryURL = this.infra.getRegistryHost();
            inlineConfig.pullRepositoryURL = this.infra.getPullRegistryHost();
            inlineConfig.imagePullSecretName = this.infra.imagePullSecretName;
            inlineConfig.kubernetesResources = this.deployment.containerLimits;
            inlineConfig.properties = this.infra.k8sProperties;
            inlineConfig.noImplicitK8sClusterAndNoDefaultClusterId = this.clusterSettings.isNoImplicitK8sClusterAndNoDefaultClusterId();
            inlineConfig.serviceAccountName = this.deployment.getServiceAccountName(this.infra);
            ContainerExecRuntimeConfig configOverrides = this.clusterSettings.getContainerSettings().executionConfigsGenericOverrides;
            this.k8sConfig = ContainerOverrideMask.getOverriden(inlineConfig, configOverrides);
            String requestTimeout = null;
            if (this.socketTimeout > 0) {
                requestTimeout = this.socketTimeout + "ms";
            }
            this.k8sBaseCommand = Lists.newArrayList((Object[])KubernetesExecUtils.getKubeCtlCommand(this.authCtx, null, requestTimeout, this.k8sConfig, true, new String[0]));
            this.k8sBaseEnv = KubernetesExecUtils.getKubeCtlEnv(this.k8sConfig);
        }
    }

    private boolean canI(String ... args) throws IOException, DKUSecurityException, InterruptedException {
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add("auth");
        commandArgs.add("can-i");
        commandArgs.addAll(Arrays.asList(args));
        List<String> canIK8sCommand = this.getK8SCommand(commandArgs);
        DKUtils.ExecutionResults canIResults = this.executeKubectlCommand(canIK8sCommand);
        return canIResults.rv == 0 && StringUtils.startsWithIgnoreCase((String)canIResults.out, (String)"Yes");
    }

    @Override
    public K8SDeploymentHeavyStatus getStatus_Unsafe_NT(boolean withPackageExtraInfo, @Nullable String overridingConnectionName) throws IOException, InterruptedException, DKUSecurityException {
        GetDeploymentResponse deploymentResponse;
        K8SDeploymentHeavyStatus status = new K8SDeploymentHeavyStatus(this.deployment.id, this.deployment.infraId);
        if (!this.apiServiceDeploymentsService.isDeployed(this.deployment)) {
            status.setMessageAndHealthWithSeverity(InfoMessage.warning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_K8S_INCOMPLETE, (String)""), DeploymentHealth.OUT_OF_SYNC);
            return status;
        }
        String k8sDeploymentId = this.k8sDeploymentId();
        status.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(this.deployment.publishedServiceId, this.authCtx);
        status.endpoints = status.summarizeEndpoints_NT(this.deployment, withPackageExtraInfo);
        status.k8sDeploymentName = k8sDeploymentId;
        status.k8sServiceName = "dku-mad-service-" + this.k8sExecutionId();
        if (!this.deployment.enabled) {
            status.setHealthWithSeverity(DeploymentHealth.DISABLED);
            return status;
        }
        DKUtils.ExecutionResults deleteDeploymentEr = this.executeKubectlCommand(this.getK8SCommand(List.of("version")));
        if (deleteDeploymentEr.rv != 0) {
            status.setMessageAndHealthWithSeverity(InfoMessage.fatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_COMMUNICATION_ERROR, (String)("kubectl version failed with " + deleteDeploymentEr.err)), DeploymentHealth.ERROR);
            return status;
        }
        DKUtils.ExecutionResults getDeploymentEr = this.executeKubectlCommand(this.getK8SCommand(List.of("get", "deployment", k8sDeploymentId, "-o", "json")));
        if (getDeploymentEr.rv != 0) {
            status.setMessageAndHealthWithSeverity(InfoMessage.fatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_INCOMPLETE, (String)("'get deployment' failed with " + getDeploymentEr.err)), DeploymentHealth.UNHEALTHY);
            return status;
        }
        try {
            deploymentResponse = (GetDeploymentResponse)JSON.parse((String)getDeploymentEr.out, GetDeploymentResponse.class);
            NullChecker.checkObject((Object)deploymentResponse);
            status.availableReplicas = deploymentResponse.status.availableReplicas;
            status.rawDeploymentDescribe = JSON.toJsonObject((Object)deploymentResponse);
        }
        catch (Exception e) {
            status.setMessageAndHealthWithSeverity(InfoMessage.fatalV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_INVALID_KUBECTL_RESPONSE, (String)"Couldn't parse \"kubectl get deployment\" command's output, message: %s", (Object[])new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)}), DeploymentHealth.UNHEALTHY);
            return status;
        }
        this.ensureK8SBases();
        AbstractExposedEndpointCollector deployed = new AbstractExposedEndpointCollector(){

            @Override
            protected void endpointsChanged(List<ExposedEndpointConsumer.ExposedEndpoint> endpoints) {
            }
        };
        VariablesContext variablesContext = this.buildVariablesContext();
        Exposition deploymentServiceExposition = (Exposition)JSON.deepCopy((Object)this.deployment.serviceExposition);
        ExpositionMeta expositionMeta = ExpositionRegistry.getMeta(deploymentServiceExposition);
        expositionMeta.expandParametersInPlace(variablesContext, deploymentServiceExposition);
        ExpositionHandler expositionHandler = expositionMeta.buildHandler(this.authCtx, null, this.k8sConfig, deploymentServiceExposition, deployed);
        File expositionTmpDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer", "service-expositions", this.deployment.id});
        DKUtils.LoggingLineSubscription mainLog = new DKUtils.LoggingLineSubscription(Level.INFO);
        DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        try {
            expositionHandler.init(new SingleK8SDeploymentExposable(expositionTmpDir, this.authCtx), (IStateLabelAggregator)new StateLabelAggregator());
            ExpositionHandler.ExpositionStatus expStatus = expositionHandler.getStatus((DKUtils.LineSubscriptionAttacher)mainLog, smartLogTailBuilder);
            status.rawServiceDescribe = expStatus.raw;
            if (!expStatus.endpoints.isEmpty()) {
                ExposedEndpointConsumer.ExposedEndpoint endpoint = expStatus.endpoints.get(0);
                status.publicURL = endpoint.getUrl();
                status.shouldAddPublicApiPath = endpoint.shouldAddPublicApiPath;
                status.setHealthWithSeverity(expStatus.isHealthy ? DeploymentHealth.HEALTHY : DeploymentHealth.UNHEALTHY);
                status.publicURLIsClusterOnly = endpoint.availability != ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC;
            } else {
                status.setMessageAndHealthWithSeverity(InfoMessage.fatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_NOIP, (String)"Public IP not found for deployment. It may still be initializing"), DeploymentHealth.UNHEALTHY);
            }
        }
        catch (Exception e) {
            status.setMessageAndHealthWithSeverity(InfoMessage.fatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_INCOMPLETE, (String)("Service inspection failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e))), DeploymentHealth.UNHEALTHY);
            return status;
        }
        K8SDeploymentHealthReporter deploymentHealthReporter = new K8SDeploymentHealthReporter(k8sDeploymentId, this.deployment, deploymentResponse);
        DKUtils.ExecutionResults rolloutCommandResults = this.executeKubectlCommand(this.getK8SCommand(List.of("rollout", "status", "deployment/" + k8sDeploymentId, "--watch=false")));
        Pair<DeploymentHealth, InfoMessage.InfoMessages> deploymentHealthReport = deploymentHealthReporter.getDeploymentHealthReport(rolloutCommandResults);
        status.mergeMessagesAndHealthWithSeverity((InfoMessage.InfoMessages)deploymentHealthReport.second, (DeploymentHealth)((Object)deploymentHealthReport.first));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected InfoMessage.InfoMessages doDeployment(@Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        logger.infoV("Prepare sync of deployment %s", new Object[]{this.deployment.id});
        logger.info((Object)"Summary of the DSS resources used to update the deployment:");
        logger.infoV("Kubernetes infra: %s", new Object[]{JSON.json((Object)this.infra)});
        logger.infoV("Kubernetes deployment: %s", new Object[]{JSON.json((Object)this.deployment)});
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        VariablesContext variablesContext = this.buildVariablesContext();
        Exposition deploymentServiceExposition = (Exposition)JSON.deepCopy((Object)this.deployment.serviceExposition);
        ExpositionMeta expositionMeta = ExpositionRegistry.getMeta(deploymentServiceExposition);
        expositionMeta.expandParametersInPlace(variablesContext, deploymentServiceExposition);
        String targetServiceId = this.deployment.getTargetId();
        String k8sDeploymentId = this.k8sDeploymentId();
        this.ensureK8SBases();
        DKUtils.LoggingLineSubscription mainLog = new DKUtils.LoggingLineSubscription(Level.INFO);
        File tmpDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer", this.deployment.id});
        try {
            FutureProgress.AutocloseableFutureProgressState ignored;
            FutureProgress.AutocloseableFutureProgressState ignored2;
            String finalImageTag;
            File contextDir;
            AbstractExposedEndpointCollector deployed = new AbstractExposedEndpointCollector(){

                @Override
                protected void endpointsChanged(List<ExposedEndpointConsumer.ExposedEndpoint> endpoints) throws Exception {
                }
            };
            File serviceExpositionTmpDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer", "service-expositions", this.deployment.id});
            SingleK8SDeploymentExposable exposable = new SingleK8SDeploymentExposable(serviceExpositionTmpDir, this.authCtx);
            if (!this.deployment.enabled) {
                FutureProgress.AutocloseableFutureProgressState ignored3;
                logger.info((Object)"Deployment disabled, removing");
                try {
                    ignored3 = FutureProgress.pushAutoCloseableState((String)"Deleting exposition");
                    try {
                        ExpositionHandler expositionHandler = expositionMeta.buildHandler(this.authCtx, null, this.k8sConfig, deploymentServiceExposition, deployed);
                        expositionHandler.init(exposable, (IStateLabelAggregator)new StateLabelAggregator());
                        expositionHandler.cleanup();
                    }
                    finally {
                        if (ignored3 != null) {
                            ignored3.close();
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to remove service", (Throwable)e);
                }
                FutureProgress.incrementState((double)1.0);
                try {
                    ignored3 = FutureProgress.pushAutoCloseableState((String)"Deleting HPA, if any");
                    try {
                        if (this.canI("delete", "hpa")) {
                            logger.info((Object)"Attempt to delete HPA");
                            List<String> deleteHpaCommand = this.getK8SCommand(List.of("delete", "hpa", k8sDeploymentId, "--ignore-not-found=true"));
                            this.handleDeploymentActionResults(deleteHpaCommand, this.executeKubectlCommand(deleteHpaCommand, logTailBuilder));
                        } else {
                            logger.debug((Object)"Current service account lacks permission to delete hpa. Not trying.");
                        }
                    }
                    finally {
                        if (ignored3 != null) {
                            ignored3.close();
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to remove HPA", (Throwable)e);
                }
                FutureProgress.incrementState((double)1.0);
                ignored3 = FutureProgress.pushAutoCloseableState((String)"Deleting deployment");
                try {
                    List<String> deleteDeploymentCommand = this.getK8SCommand(List.of("delete", "deployment", k8sDeploymentId, "--ignore-not-found=true"));
                    this.handleDeploymentActionResults(deleteDeploymentCommand, this.executeKubectlCommand(deleteDeploymentCommand, logTailBuilder));
                }
                finally {
                    if (ignored3 != null) {
                        ignored3.close();
                    }
                }
                FutureProgress.incrementState((double)1.0);
                try {
                    ignored3 = FutureProgress.pushAutoCloseableState((String)"Deleting PDB, if any");
                    try {
                        if (this.canI("delete", "pdb")) {
                            logger.info((Object)"Attempt to delete PDB");
                            List<String> deletePdbCommand = this.getK8SCommand(List.of("delete", "pdb", k8sDeploymentId, "--ignore-not-found=true"));
                            this.handleDeploymentActionResults(deletePdbCommand, this.executeKubectlCommand(deletePdbCommand, logTailBuilder));
                        } else {
                            logger.debug((Object)"Current service account lacks permission to delete pdb. Not trying.");
                        }
                    }
                    finally {
                        if (ignored3 != null) {
                            ignored3.close();
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to remove PDB", (Throwable)e);
                }
                FutureProgress.incrementState((double)1.0);
                try {
                    ignored3 = FutureProgress.pushAutoCloseableState((String)"Deleting secret, if any");
                    try {
                        if (this.canI("delete", "secret")) {
                            logger.info((Object)"Attempt to delete secret");
                            List<String> deleteSecretCommand = this.getK8SCommand(List.of("delete", "secret", k8sDeploymentId, "--ignore-not-found=true"));
                            this.handleDeploymentActionResults(deleteSecretCommand, this.executeKubectlCommand(deleteSecretCommand, logTailBuilder));
                        } else {
                            logger.debug((Object)"Current service account lacks permission to delete secret. Not trying.");
                        }
                    }
                    finally {
                        if (ignored3 != null) {
                            ignored3.close();
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to remove secret", (Throwable)e);
                }
                FutureProgress.incrementState((double)1.0);
                InfoMessage.InfoMessages e = ret;
                return e;
            }
            this.createDeployerKeyIfAuthorizationToQueryThroughDeployer(this.deployment, ret);
            try (FutureProgress.AutocloseableFutureProgressState ignored4 = FutureProgress.pushAutoCloseableState((String)"Preparing Docker image context");){
                contextDir = this.apiDeployerImageBuilderService.prepareDockerImageContext(this.authCtx, this.infra, this.deployment, targetServiceId, tmpDir);
            }
            FutureProgress.incrementState((double)1.0);
            APIDeployerImageBuilderService.ImageNameTags imageNameTags = new APIDeployerImageBuilderService.ImageNameTags(this.infra, this.deployment, null);
            try (FutureProgress.AutocloseableFutureProgressState ignored5 = FutureProgress.pushAutoCloseableState((String)"Building Docker image");){
                HashMap<String, String> buildVariables = new HashMap<String, String>();
                if (DKUApp.isDataikuCloud()) {
                    this.infra.prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.ECR;
                    this.apiDeployerImageBuilderService.executePrePushScript(this.authCtx, this.infra, imageNameTags, new ProxySettings(), new HashMap<String, String>(), logTailBuilder);
                    buildVariables.putAll(this.apiDeployerImageBuilderService.getCraneAuthToken(this.infra.getRegistryHost(), new HashMap<String, String>()));
                }
                this.apiDeployerImageBuilderService.buildDockerImage(this.infra, imageNameTags, logTailBuilder, this.rebuildCodeEnv, contextDir, buildVariables);
            }
            FutureProgress.incrementState((double)1.0);
            if (DKUApp.isDataikuCloud()) {
                finalImageTag = this.infra.getImageAliasInRegistryHost(imageNameTags.imageName, imageNameTags.imageVersion);
            } else {
                ignored2 = FutureProgress.pushAutoCloseableState((String)"Pushing Docker image to repository");
                try {
                    finalImageTag = this.apiDeployerImageBuilderService.tagAndPushImage(this.authCtx, this.infra, logTailBuilder, imageNameTags, new ProxySettings(), new HashMap<String, String>());
                }
                finally {
                    if (ignored2 != null) {
                        ignored2.close();
                    }
                }
                FutureProgress.incrementState((double)1.0);
            }
            try {
                ignored2 = FutureProgress.pushAutoCloseableState((String)"Updating Kube deployment");
                try {
                    GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings.AuditLoggingContainerSettings cloudAuditLoggingContainerSettings;
                    String deploymentTemplateFileName = "deployment.yaml.template";
                    AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging apiNodeLogging = this.getDeployment().getNodeLogging(this.getInfra());
                    boolean isCloudAuditLoggingEnabled = DKUApp.isDataikuCloud() && apiNodeLogging.auditLog.logQueries;
                    GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings cloudSettings = ApplicationConfigurator.getGeneralSettings().dataikuCloudK8SApiDeploymentSettings;
                    GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings.AuditLoggingContainerSettings auditLoggingContainerSettings = cloudAuditLoggingContainerSettings = cloudSettings == null ? null : cloudSettings.auditLoggingContainerSettings;
                    if (isCloudAuditLoggingEnabled) {
                        boolean isMissingSettings;
                        boolean bl = isMissingSettings = cloudAuditLoggingContainerSettings == null || StringUtils.isBlank((String)cloudAuditLoggingContainerSettings.dockerImageName);
                        if (isMissingSettings) {
                            String reason = cloudAuditLoggingContainerSettings == null ? "Audit logging container settings are not defined" : "Audit logging container Docker image is not specified";
                            logger.warnV("%s. Audit logging cannot be enabled for deployment '%s'. Falling back to using the default 'deployment.yaml.template' configuration.", new Object[]{reason, this.deployment.id});
                            String message = AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx) ? "Audit logging could not be enabled. See deployment logs for more information." : "Audit logging could not be enabled. Please contact an administrator.";
                            ret.withWarning((InfoMessage.MessageCode)DeployerCodes.WARN_API_DEPLOYER_AUDIT_LOGGING_SETUP_FAILURE, message);
                        } else {
                            deploymentTemplateFileName = "dataiku-cloud-deployment.yaml.template";
                            logger.infoV("Configuring audit logging container for deployment '%s' on Dataiku Cloud.", new Object[]{this.deployment.id});
                        }
                    }
                    File deploymentSpec = DKUApp.getResourceFile((String[])new String[]{"api-deployer", "kubernetes", deploymentTemplateFileName});
                    File expandedDeploymentSpec = new File(tmpDir, "deployment-" + imageNameTags.deploymentVersion + ".yaml");
                    ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forAPIDeployerDeployment((AuthCtx)this.authCtx, (String)this.infra.id, (String)this.deployment.publishedServiceId, (String)this.deployment.id);
                    CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
                    String executionId = SecretKeyGenerator.generateSmall();
                    K8SAPIDeploymentInfra.K8SContainerLimits k8sContainerLimits = this.k8sConfig.kubernetesResources;
                    ComputeResourceUsage.forSingleK8SJob((String)this.clusterSettings.overridenFromK8SClusterId, (String)executionId, (IK8SContainerLimits)k8sContainerLimits, (String)this.k8sConfig.name).reportStartNoFail();
                    KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.authCtx, executionId, this.k8sConfig);
                    VariablesContext globalContext = this.buildVariablesContext();
                    for (SimpleKeyValue kv : this.deployment.getAdditionalLabels(this.infra)) {
                        laa.putLabel(kv.key, globalContext.expandEmptyIfUnresolved(kv.value));
                    }
                    for (SimpleKeyValue kv : this.deployment.getAdditionalAnnotations(this.infra)) {
                        laa.putAnnotation(kv.key, globalContext.expandEmptyIfUnresolved(kv.value));
                    }
                    K8SAPIDeploymentInfra.K8SContainerLimits containerLimits = this.deployment.containerLimits;
                    logger.info((Object)("Deploying with limits " + JSON.json((Object)containerLimits)));
                    String resourceSection = SingleK8SDeploymentManager.buildResourceSection(containerLimits);
                    String sanitizedInfraId = KubernetesExecUtils.sanitizeLabelValue(this.infra.id, false);
                    String sanitizedDeploymentId = KubernetesExecUtils.sanitizeLabelValue(this.deployment.id, false);
                    String deploymentApiVersion = KubernetesExecUtils.getDeploymentApiVersion(this.k8sConfig);
                    String sanitizedK8sDeploymentId = KubernetesExecUtils.sanitizeName(k8sDeploymentId, false);
                    logger.info((Object)("deploymentVersion: " + deploymentApiVersion));
                    String spec = DKUFileUtils.readFileToStringUTF8((File)deploymentSpec).replace("__API_VERSION__", deploymentApiVersion).replace("__INFRA_ID__", sanitizedInfraId).replace("__DEPLOYMENT_ID__", sanitizedDeploymentId).replace("__K8S_DEPLOYMENT_ID__", sanitizedK8sDeploymentId).replace("__RESOURCE_SECTION__", resourceSection).replace("__NB_REPLICAS__", "" + this.deployment.deploymentScaling.initialReplicas).replace("__PROGRESS_DEADLINE_SECONDS__", "" + this.deployment.deploymentScaling.progressDeadlineSeconds).replace("__IMAGE_TAG__", finalImageTag).replace("__SERVICE_ISALIVE_PROBE_PATH__", "/monitoring/api/" + targetServiceId + "/isAliveSimple").replace("__DKU_TMPDIR__", this.k8sConfig.DKU_TMPDIR);
                    List<String> auditLoggingForCloudVolumeLines = null;
                    List<String> auditLoggingForCloudVolumeMountLines = null;
                    if (isCloudAuditLoggingEnabled && cloudAuditLoggingContainerSettings != null) {
                        K8SAPIDeploymentInfra.K8SContainerLimits cloudContainerLimits = Objects.requireNonNullElse(cloudAuditLoggingContainerSettings.containerLimits, K8SAPIDeploymentInfra.K8SContainerLimits.forCloud());
                        spec = spec.replace("__DKU_KUBERNETES_AUDIT_IMAGE_NAME__", StringUtils.defaultString((String)cloudAuditLoggingContainerSettings.dockerImageName)).replace("__AUDIT_LOGGING_CONTAINER_RESOURCE_SECTION__", SingleK8SDeploymentManager.buildResourceSection(cloudContainerLimits));
                        auditLoggingForCloudVolumeLines = List.of("- name: audit-volume\n", "  emptyDir: {}\n");
                        auditLoggingForCloudVolumeMountLines = List.of("- name: audit-volume\n", "  mountPath: /home/dataiku/data/run/audit\n");
                    }
                    spec = KubernetesExecUtils.fillLabelsAndAnnotations(laa, spec);
                    spec = KubernetesExecUtils.fillResources(containerLimits, spec);
                    spec = KubernetesExecUtils.fillSecurityContext(this.k8sConfig, spec);
                    spec = KubernetesExecUtils.fillInitContainers(this.k8sConfig, spec, finalImageTag);
                    spec = KubernetesExecUtils.fillVolumes(this.k8sConfig, spec, auditLoggingForCloudVolumeLines, auditLoggingForCloudVolumeMountLines);
                    if (StringUtils.isNotBlank((String)this.k8sConfig.serviceAccountName)) {
                        spec = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_SERVICE_ACCOUNT_NAME__", "serviceAccountName: " + this.k8sConfig.serviceAccountName, spec);
                    }
                    spec = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_NODESELECTOR__", this.deployment.containerLimits.nodeSelector, spec);
                    spec = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_AFFINITY__", this.deployment.containerLimits.affinity, spec);
                    spec = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOLERATIONS__", this.deployment.containerLimits.tolerations, spec);
                    spec = KubernetesExecUtils.fillPotentiallyMultipleReplacement("__DKU_KUBERNETES_TOPOLOGY_SPREAD_CONSTRAINTS__", this.deployment.deploymentTopologySpreadConstraints, spec);
                    spec = KubernetesExecUtils.setupImagePullSecretsManifestSection(this.infra.imagePullSecretName, spec);
                    Collection<SimpleKeyValue> additionalEnvVars = this.deployment.getAdditionalEnvVars(this.infra);
                    if (!additionalEnvVars.isEmpty()) {
                        spec = !this.infra.useSecretToDefineEnvVars ? this.setAdditionalEnvVars(additionalEnvVars, spec, globalContext, deploymentSpec.getAbsolutePath()) : this.setAdditionalEnvVarsWithSecret(additionalEnvVars, spec, deploymentSpec.getAbsolutePath(), sanitizedK8sDeploymentId);
                    }
                    logger.info((Object)("final deployment:\n" + spec));
                    if (this.deployment.deploymentModifier != null && StringUtils.isNotBlank((String)this.deployment.deploymentModifier.runnableType)) {
                        spec = this.applyModification(this.authCtx, this.k8sConfig, spec, this.deployment.deploymentModifier, tmpDir);
                    }
                    DKUFileUtils.writeFileUTF8((File)expandedDeploymentSpec, (String)spec);
                    neverEverDeployed.remove(this.getDeployment().id);
                    try {
                        if (this.canI("delete", "hpa")) {
                            logger.info((Object)"Attempt to delete previous HPA (horizontal pod autoscaler), if any");
                            List<String> deleteHpaCommand = this.getK8SCommand(List.of("delete", "hpa", k8sDeploymentId, "--ignore-not-found=true"));
                            this.handleDeploymentActionResults(deleteHpaCommand, this.executeKubectlCommand(deleteHpaCommand, logTailBuilder));
                        } else {
                            logger.debug((Object)"Current service account lacks permission to delete hpa. Not trying.");
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to remove HPA", (Throwable)e);
                    }
                    List<String> applyDeploymentSpecCommand = this.getK8SCommand(List.of("apply", "-f", expandedDeploymentSpec.getAbsolutePath()));
                    this.handleDeploymentActionResults(applyDeploymentSpecCommand, this.executeKubectlCommand(applyDeploymentSpecCommand, logTailBuilder));
                    try {
                        if (this.canI("delete", "pdb")) {
                            logger.info((Object)"Attempt to delete previous PDB (pod disruption budget), if any");
                            List<String> deletePdbCommand = this.getK8SCommand(List.of("delete", "pdb", k8sDeploymentId, "--ignore-not-found=true"));
                            this.handleDeploymentActionResults(deletePdbCommand, this.executeKubectlCommand(deletePdbCommand, logTailBuilder));
                        } else {
                            logger.debug((Object)"Current service account lacks permission to delete pdb. Not trying.");
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to remove PDB", (Throwable)e);
                    }
                    try {
                        if (this.canI("delete", "secret")) {
                            logger.info((Object)"Attempt to delete previous secret, if any");
                            List<String> deleteSecretCommand = this.getK8SCommand(List.of("delete", "secret", k8sDeploymentId, "--ignore-not-found=true"));
                            this.handleDeploymentActionResults(deleteSecretCommand, this.executeKubectlCommand(deleteSecretCommand, logTailBuilder));
                        } else {
                            logger.debug((Object)"Current service account lacks permission to delete secret. Not trying.");
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to remove secret", (Throwable)e);
                    }
                    if (this.deployment.deploymentScaling.hpa) {
                        File autoscalerSpecFile = DKUApp.getResourceFile((String[])new String[]{"api-deployer", "kubernetes", "autoscaler.yaml.template"});
                        File expandedAutoscalerSpecFile = new File(tmpDir, "hpa-" + imageNameTags.deploymentVersion + ".yaml");
                        String hpaSpec = this.buildK8SHPASpec(autoscalerSpecFile, sanitizedInfraId, k8sDeploymentId, sanitizedDeploymentId, deploymentApiVersion);
                        logger.info((Object)("final hpa:\n" + hpaSpec));
                        logger.info((Object)"Applying HPA (horizontal pod autoscaler) configuration");
                        DKUFileUtils.writeFileUTF8((File)expandedAutoscalerSpecFile, (String)hpaSpec);
                        List<String> applyAutoscalerSpecCommand = this.getK8SCommand(List.of("apply", "-f", expandedAutoscalerSpecFile.getAbsolutePath()));
                        this.handleDeploymentActionResults(applyAutoscalerSpecCommand, this.executeKubectlCommand(applyAutoscalerSpecCommand, logTailBuilder));
                    }
                    if (this.deployment.deploymentPodDisruptionBudget.enable) {
                        File pdbSpecFile = DKUApp.getResourceFile((String[])new String[]{"api-deployer", "kubernetes", "pdb.yaml.template"});
                        File expandedPdbSpecFile = new File(tmpDir, "pdb-" + imageNameTags.deploymentVersion + ".yaml");
                        String pdbSpec = this.buildK8SPDBSpec(pdbSpecFile, sanitizedInfraId, k8sDeploymentId, sanitizedDeploymentId);
                        logger.info((Object)("final pdb:\n" + pdbSpec));
                        logger.info((Object)"Applying PDB (pod disruption budget) configuration");
                        DKUFileUtils.writeFileUTF8((File)expandedPdbSpecFile, (String)pdbSpec);
                        List<String> applyPdbSpecCommand = this.getK8SCommand(List.of("apply", "-f", expandedPdbSpecFile.getAbsolutePath()));
                        this.handleDeploymentActionResults(applyPdbSpecCommand, this.executeKubectlCommand(applyPdbSpecCommand, logTailBuilder));
                    }
                    if (!additionalEnvVars.isEmpty() && this.infra.useSecretToDefineEnvVars) {
                        File osSpecFile = DKUApp.getResourceFile((String[])new String[]{"api-deployer", "kubernetes", "opaque-secret.yaml.template"});
                        File expandedOsSpecFile = new File(tmpDir, "os-" + imageNameTags.deploymentVersion + ".yaml");
                        String osSpec = this.buildK8SOpaqueSecretSpec(osSpecFile, sanitizedK8sDeploymentId, globalContext, additionalEnvVars);
                        logger.info((Object)("final opaque secret:\n" + osSpec));
                        logger.info((Object)"Applying opaque secret configuration");
                        DKUFileUtils.writeFileUTF8((File)expandedOsSpecFile, (String)osSpec);
                        List<String> applyOsSpecCommand = this.getK8SCommand(List.of("apply", "-f", expandedOsSpecFile.getAbsolutePath()));
                        this.handleDeploymentActionResults(applyOsSpecCommand, this.executeKubectlCommand(applyOsSpecCommand, logTailBuilder));
                    }
                }
                finally {
                    if (ignored2 != null) {
                        ignored2.close();
                    }
                }
            }
            catch (ProcessDiedException e) {
                this.throwDeploymentException(e);
            }
            FutureProgress.incrementState((double)1.0);
            try {
                ignored = FutureProgress.pushAutoCloseableState((String)"Updating Kube service");
                try {
                    ExpositionHandler expositionHandler = expositionMeta.buildHandler(this.authCtx, null, this.k8sConfig, deploymentServiceExposition, deployed);
                    expositionHandler.init(exposable, (IStateLabelAggregator)new StateLabelAggregator());
                    expositionHandler.start((DKUtils.LineSubscriptionAttacher)mainLog, logTailBuilder);
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (ProcessDiedException e) {
                this.throwDeploymentException(e);
            }
            FutureProgress.incrementState((double)1.0);
            ignored = FutureProgress.pushAutoCloseableState((String)"Waiting for rollout to complete");
            try {
                List<String> watchRolloutStatusCommand = this.getK8SCommand(List.of("rollout", "status", "deployment/" + k8sDeploymentId));
                this.handleDeploymentActionResults(watchRolloutStatusCommand, this.executeKubectlCommand(watchRolloutStatusCommand, logTailBuilder));
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
            ignored = FutureProgress.pushAutoCloseableState((String)"Waiting for public IP to be available");
            try {
                int MAX_LOOPS = 10;
                int LOOP_DELAY_MS = 10000;
                for (int i = 0; i < MAX_LOOPS; ++i) {
                    K8SDeploymentHeavyStatus heavyStatus = this.getStatus_Unsafe_NT(false, null);
                    if (heavyStatus.publicURL != null) {
                        break;
                    }
                    Thread.sleep(LOOP_DELAY_MS);
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
        }
        finally {
            DKUFileUtils.deleteDirectory((File)tmpDir);
        }
        return ret;
    }

    private static String buildResourceSection(K8SAPIDeploymentInfra.K8SContainerLimits containerLimits) {
        boolean hasRequests;
        boolean hasLimits = containerLimits.cpuLimit > 0.0 || containerLimits.memLimitMB > 0 || !containerLimits.customLimits.isEmpty();
        boolean bl = hasRequests = containerLimits.cpuRequest > 0.0 || containerLimits.memRequestMB > 0 || !containerLimits.customRequests.isEmpty();
        if (!hasLimits && !hasRequests) {
            return "";
        }
        StringBuilder builder = new StringBuilder("        resources:\n");
        if (hasLimits) {
            builder.append("          limits:\n");
            if (containerLimits.cpuLimit > 0.0) {
                builder.append("            cpu: \"").append(containerLimits.cpuLimit).append("\"\n");
            }
            if (containerLimits.memLimitMB > 0) {
                builder.append("            memory: \"").append(containerLimits.memLimitMB).append("Mi\"\n");
            }
            for (ClusterProperty skv : containerLimits.customLimits) {
                builder.append("            ").append(skv.key).append(": \"").append(skv.value).append("\"\n");
            }
        }
        if (hasRequests) {
            builder.append("          requests:\n");
            if (containerLimits.cpuRequest > 0.0) {
                builder.append("            cpu: \"").append(containerLimits.cpuRequest).append("\"\n");
            }
            if (containerLimits.memRequestMB > 0) {
                builder.append("            memory: \"").append(containerLimits.memRequestMB).append("Mi\"\n");
            }
            for (ClusterProperty skv : containerLimits.customRequests) {
                builder.append("            ").append(skv.key).append(": \"").append(skv.value).append("\"\n");
            }
        }
        return builder.toString();
    }

    private String setAdditionalEnvVars(Collection<SimpleKeyValue> additionalEnvVars, String spec, VariablesContext globalContext, String deploymentSpecPath) {
        if (additionalEnvVars.isEmpty()) {
            return spec;
        }
        Matcher additionalEnvMatcher = Pattern.compile("^(\\s+)#\\s*__ADDITIONAL_ENV_VARS__\n", 8).matcher(spec);
        if (additionalEnvMatcher.find()) {
            String envIndentation = additionalEnvMatcher.group(1);
            StringBuilder formattedEnvVars = new StringBuilder();
            for (SimpleKeyValue envVar : additionalEnvVars) {
                formattedEnvVars.append(String.format("%s- name: %s%n", envIndentation, envVar.key));
                formattedEnvVars.append(String.format("%s  value: \"%s\"%n", envIndentation, globalContext.expandEmptyIfUnresolved(envVar.value)));
            }
            return additionalEnvMatcher.replaceFirst(formattedEnvVars.toString());
        }
        logger.warnV("No __ADDITIONAL_ENV_VARS__ tag found in deployment template %s. Cannot add configured additional environment variables to deployment!", new Object[]{deploymentSpecPath});
        return spec;
    }

    private String setAdditionalEnvVarsWithSecret(Collection<SimpleKeyValue> additionalEnvVars, String spec, String deploymentSpecPath, String sanitizedK8sDeploymentId) {
        if (additionalEnvVars.isEmpty()) {
            return spec;
        }
        Matcher additionalEnvMatcher = Pattern.compile("^(\\s+)#\\s*__ADDITIONAL_ENV_VARS__\n", 8).matcher(spec);
        if (additionalEnvMatcher.find()) {
            String envIndentation = additionalEnvMatcher.group(1);
            StringBuilder formattedEnvVars = new StringBuilder();
            for (SimpleKeyValue envVar : additionalEnvVars) {
                formattedEnvVars.append(String.format("%s- name: %s%n", envIndentation, envVar.key));
                formattedEnvVars.append(String.format("%s  valueFrom:%n", envIndentation));
                formattedEnvVars.append(String.format("%s    secretKeyRef:%n", envIndentation));
                formattedEnvVars.append(String.format("%s      name: %s%n", envIndentation, sanitizedK8sDeploymentId));
                formattedEnvVars.append(String.format("%s      key: %s%n", envIndentation, envVar.key));
            }
            return additionalEnvMatcher.replaceFirst(formattedEnvVars.toString());
        }
        logger.warnV("No __ADDITIONAL_ENV_VARS__ tag found in deployment template %s. Cannot add configured additional environment variables to deployment!", new Object[]{deploymentSpecPath});
        return spec;
    }

    private DKUtils.ExecutionResults executeKubectlCommand(List<String> args) throws IOException, DKUSecurityException, InterruptedException {
        return DKUtils.execAndGetOutputAndErrors((String[])args.toArray(new String[0]), this.getBaseK8SEnv());
    }

    private DKUtils.ExecutionResults executeKubectlCommand(List<String> args, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, DKUSecurityException, InterruptedException {
        return DKUtils.execAndGetOutputAndErrors((String[])args.toArray(new String[0]), this.getBaseK8SEnv(), (DKUtils.SmartLogTailBuilder)logTailBuilder);
    }

    private void handleDeploymentActionResults(List<String> args, DKUtils.ExecutionResults commandResults) throws DeploymentException {
        String argsAsString = String.join((CharSequence)" ", args);
        if (commandResults.rv != 0) {
            String message = String.format("kubectl failed (exit code: %d)", commandResults.rv);
            String adminMessage = String.format("command '%s' failed: %s", argsAsString, commandResults.err);
            logger.errorV("%s: %s", new Object[]{message, adminMessage});
            throw new DeploymentException(message, adminMessage);
        }
        String details = StringUtils.isBlank((String)commandResults.out) ? "" : " Output: " + commandResults.out;
        logger.debug((Object)String.format("Command '%s' succeeded.%s", argsAsString, details));
    }

    private void throwDeploymentException(ProcessDiedException e) {
        SmartLogTail logTail = e.getLogTail();
        if (logTail == null || logTail.getMaxLevelLines().isEmpty()) {
            logger.error((Object)e.getMessage());
            throw new DeploymentException(e.getMessage(), null);
        }
        List log = logTail.getMaxLevelLines();
        String adminMessage = (String)log.get(log.size() - 1);
        logger.errorV("%s: %s", new Object[]{e.getMessage(), adminMessage});
        throw new DeploymentException(e.getMessage(), adminMessage);
    }

    private String buildK8SHPASpec(File autoscalerSpecFile, String sanitizedInfraId, String k8sDeploymentId, String sanitizedDeploymentId, String deploymentApiVersion) throws IOException {
        String hpaApiVersion = KubernetesExecUtils.getAutoscalerApiVersion(this.k8sConfig);
        String scalingCondition = KubernetesExecUtils.buildScalingCondition(this.deployment.deploymentScaling, hpaApiVersion);
        HashMap<String, String> annotations = new HashMap<String, String>();
        for (SimpleKeyValue kv : this.deployment.deploymentScaling.hpaAnnotations) {
            annotations.put(kv.key, kv.value);
        }
        String annotationsBlock = KubernetesExecUtils.makeLabelsOrAnnotationsMap("annotations", annotations, "  ");
        return DKUFileUtils.readFileToStringUTF8((File)autoscalerSpecFile).replace("__INFRA_ID__", sanitizedInfraId).replace("__K8S_DEPLOYMENT_ID__", k8sDeploymentId).replace("__DEPLOYMENT_ID__", sanitizedDeploymentId).replace("__API_VERSION__", hpaApiVersion).replace("__DEPLOYMENT_API_VERSION__", deploymentApiVersion).replace("__ANNOTATIONS__", annotationsBlock).replace("__NB_REPLICAS__", Integer.toString(this.deployment.deploymentScaling.initialReplicas)).replace("__MIN_PODS__", Integer.toString(this.deployment.deploymentScaling.hpaMinPods)).replace("__MAX_PODS__", Integer.toString(this.deployment.deploymentScaling.hpaMaxPods)).replace("__SCALING_CONDITION__", scalingCondition);
    }

    private String buildK8SPDBSpec(File pdbSpecFile, String sanitizedInfraId, String k8sDeploymentId, String sanitizedDeploymentId) throws IOException {
        String pdbCondition = this.deployment.deploymentPodDisruptionBudget.isMaxUnavailable ? "maxUnavailable: " + this.deployment.deploymentPodDisruptionBudget.maxUnavailable : "minAvailable: " + this.deployment.deploymentPodDisruptionBudget.minAvailable;
        return DKUFileUtils.readFileToStringUTF8((File)pdbSpecFile).replace("__DEPLOYMENT_ID__", sanitizedDeploymentId).replace("__PDB_CONDITION__", pdbCondition).replace("__INFRA_ID__", sanitizedInfraId).replace("__K8S_DEPLOYMENT_ID__", k8sDeploymentId);
    }

    private String buildK8SOpaqueSecretSpec(File pdbSpecFile, String sanitizedK8sDeploymentId, VariablesContext globalContext, Collection<SimpleKeyValue> additionalEnvVars) throws IOException {
        String secretMap = additionalEnvVars.stream().map(kv -> "  %s: %s".formatted(kv.key, Base64.encodeBase64String((byte[])globalContext.expandEmptyIfUnresolved(kv.value).getBytes(StandardCharsets.UTF_8)))).collect(Collectors.joining("\n"));
        return DKUFileUtils.readFileToStringUTF8((File)pdbSpecFile).replace("__SECRET_MAP__", secretMap).replace("__K8S_DEPLOYMENT_ID__", sanitizedK8sDeploymentId);
    }

    private VariablesContext buildVariablesContext() {
        VariablesContext variablesContext = this.variablesService.getForGlobal();
        if (variablesContext instanceof HierarchicalVariablesContext) {
            ((HierarchicalVariablesContext)variablesContext).addLevel(this.deployment.variables);
        }
        if (variablesContext instanceof HierarchicalVariablesContext) {
            JsonObject variables = new JsonObject();
            variables.addProperty("k8sDeploymentId", this.k8sDeploymentId());
            variables.addProperty("apiDeploymentId", this.deployment.id);
            variables.addProperty("k8sFriendlyApiDeploymentId", APIDeployerImageBuilderService.sanitizeDeploymentId(this.deployment.id));
            variables.addProperty("infraId", this.infra.id);
            variables.addProperty("k8sFriendlyInfraId", APIDeployerImageBuilderService.sanitizeDeploymentId(this.infra.id));
            variables.addProperty("publishedServiceId", this.deployment.publishedServiceId);
            variables.addProperty("k8sFriendlyPublishedServiceId", APIDeployerImageBuilderService.sanitizeDeploymentId(this.deployment.publishedServiceId));
            String deployedServiceId = StringUtils.defaultIfBlank((String)this.deployment.deployedServiceId, (String)this.deployment.publishedServiceId);
            variables.addProperty("deployedServiceId", deployedServiceId);
            variables.addProperty("k8sFriendlyDeployedServiceId", APIDeployerImageBuilderService.sanitizeDeploymentId(deployedServiceId));
            ((HierarchicalVariablesContext)variablesContext).addLevel(variables);
        }
        return variablesContext;
    }

    private String applyModification(AuthCtx authCtx, ContainerExecRuntimeConfig k8sConfig, String yaml, K8SAPIDeploymentInfra.K8SYamlModifier modifier, File tmpDir) throws Exception {
        JsonObject ctx = new JsonObject();
        ctx.addProperty("usage", "api_deployer");
        ctx.addProperty("metricsJsonPath", "/metrics-json");
        ctx.addProperty("metricsPrometheusPath", "/metrics-prometheus");
        ctx.addProperty("metricsPort", "13000");
        return KubernetesExecUtils.applyYamlModifier(authCtx, "__DKU_ANY_PROJECT__", k8sConfig, yaml, modifier, tmpDir, ctx);
    }

    @Override
    FutureResponse<String> startDiagnosis() throws Exception {
        final SmartLogTail logTail = new SmartLogTail();
        SimpleFutureThread<String> ft = new SimpleFutureThread<String>(this.authCtx){

            @Override
            protected String compute() throws Exception {
                try (FutureProgress.AutocloseableFutureProgressState fps = FutureProgress.pushAutoCloseableState((String)"Diagnosing deployment on Kubernetes", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    String string = SingleK8SDeploymentManager.this.diagnosis(logTail, this);
                    return string;
                }
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"diag_k8s_api_deployment", (String)("Get diagnostic of Kubernetes deployment: " + SingleK8SDeploymentManager.this.deployment.id));
            }

            public SmartLogTail getLog() {
                return logTail.snapshot();
            }
        };
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<String>>(){});
    }

    private String diagnosis(SmartLogTail logTail, FutureThreadBase<?> future) throws Exception {
        String fileFriendlyLocalNow = DKUDateUtils.isoFormatFileFriendlyLocalNow();
        File tmpDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer_diag", this.deployment.id, "dss-api-diag-" + fileFriendlyLocalNow});
        DKUFileUtils.mkdirs((File)tmpDir);
        ExtraLogFileAppender.setupIfNeeded();
        ExtraLogFileAppender.startLoggingToExtraFile(new File(tmpDir, "diag.log"));
        try {
            String string;
            try (AutoSmartLogTailRedirect asltr = new AutoSmartLogTailRedirect(logTail);){
                string = this.diagnosisInternal(tmpDir, fileFriendlyLocalNow, future);
            }
            return string;
        }
        finally {
            ExtraLogFileAppender.stopLoggingToExtraFile();
        }
    }

    private String diagnosisInternal(File tmpDir, final String fileFriendlyLocalNow, FutureThreadBase<?> future) throws Exception {
        List<String> args;
        FileOutputStream fos;
        logger.infoV("Generating diagnostic of  %s...", new Object[]{this.deployment.id});
        JSON.prettyToFile((Object)this.deployment, (File)new File(tmpDir, "deployment.json"));
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.debug((Object)"Diagnosis requested by a user with admin permissions on infra. Including infra.json configuration file.");
            JSON.prettyToFile((Object)this.infra, (File)new File(tmpDir, "infra.json"));
        } else {
            logger.debug((Object)"Diagnosis requested by a user without admin permissions on infra. Not including configuration file infra.json.");
        }
        this.ensureK8SBases();
        String k8sDeploymentId = this.k8sDeploymentId();
        String k8sFriendlyInfraId = KubernetesExecUtils.sanitizeLabelValue(this.infra.id, false);
        String k8sFriendlyDeploymentId = KubernetesExecUtils.sanitizeLabelValue(this.deployment.id, false);
        String labelsFilter = "dataiku.com/dku-apideployer-deployment-id=" + k8sFriendlyDeploymentId + ",dataiku.com/dku-apideployer-infra-id=" + k8sFriendlyInfraId;
        logger.info((Object)"Collect descriptions of K8S objects");
        String serviceAccountName = null;
        boolean isDeploymentFound = false;
        logger.info((Object)"Check K8S deployment presence");
        List<String> args2 = this.getBaseK8SCommand();
        args2.add("get");
        args2.add("deployment");
        args2.add(k8sDeploymentId);
        args2.add("--ignore-not-found=true");
        args2.add("-o");
        args2.add("json");
        byte[] deploymentOutput = DKUtils.execAndGetOutput((String[])args2.toArray(new String[0]), this.getBaseK8SEnv());
        if (deploymentOutput != null && deploymentOutput.length > 0) {
            isDeploymentFound = true;
            JsonObject deploymentCmdOutput = (JsonObject)JSON.parse((byte[])deploymentOutput, JsonObject.class);
            if (!deploymentCmdOutput.has("metadata")) {
                throw new Exception("Deployment isn't active on K8S");
            }
            if (deploymentCmdOutput.has("spec") && deploymentCmdOutput.getAsJsonObject("spec").has("template") && deploymentCmdOutput.getAsJsonObject("spec").getAsJsonObject("template").has("spec") && deploymentCmdOutput.getAsJsonObject("spec").getAsJsonObject("template").getAsJsonObject("spec").has("serviceAccountName")) {
                serviceAccountName = deploymentCmdOutput.getAsJsonObject("spec").getAsJsonObject("template").getAsJsonObject("spec").get("serviceAccountName").getAsString();
            }
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        if (StringUtils.isNotBlank(serviceAccountName)) {
            logger.infoV("serviceAccountName %s is configured. Retrieving its details.", new Object[]{serviceAccountName});
            List<String> argsGet = this.getBaseK8SCommand();
            argsGet.add("get");
            argsGet.add("sa");
            argsGet.add(serviceAccountName);
            argsGet.add("--ignore-not-found=true");
            byte[] saGetOutput = DKUtils.execAndGetOutput((String[])argsGet.toArray(new String[0]), this.getBaseK8SEnv());
            if (saGetOutput == null || saGetOutput.length == 0) {
                logger.warnV("Service account %s not found. This may prevent proper deployment.", new Object[]{serviceAccountName});
            } else {
                File f = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"describe-sa.txt"});
                List<String> argsDescribe = this.getBaseK8SCommand();
                argsDescribe.add("describe");
                argsDescribe.add("sa");
                argsDescribe.add(serviceAccountName);
                try (FileOutputStream fos2 = new FileOutputStream(f);){
                    DKUtils.execAndWriteOutput((String[])argsDescribe.toArray(new String[0]), this.getBaseK8SEnv(), (File)tmpDir, (OutputStream)fos2);
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Error requesting description of k8s service account %s", new Object[]{serviceAccountName});
                }
            }
            if (future.isAborted()) {
                throw new InterruptedException("Diagnosis aborted");
            }
        }
        if (isDeploymentFound) {
            logger.info((Object)"Get K8S deployment state");
            fos = new FileOutputStream(new File(tmpDir, "describe-deployment.txt"));
            try {
                args = this.getBaseK8SCommand();
                args.add("describe");
                args.add("deployment");
                args.add(k8sDeploymentId);
                DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), this.getBaseK8SEnv(), (File)tmpDir, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
            if (future.isAborted()) {
                throw new InterruptedException("Diagnosis aborted");
            }
        }
        logger.info((Object)"Get K8S replica sets state");
        fos = new FileOutputStream(new File(tmpDir, "describe-rs.txt"));
        try {
            args = this.getBaseK8SCommand();
            args.add("describe");
            args.add("rs");
            args.add("-l");
            args.add(labelsFilter);
            DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), this.getBaseK8SEnv(), (File)tmpDir, (OutputStream)fos);
        }
        finally {
            fos.close();
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        logger.info((Object)"Get K8S pods state");
        fos = new FileOutputStream(new File(tmpDir, "describe-pods.txt"));
        try {
            args = this.getBaseK8SCommand();
            args.add("describe");
            args.add("pod");
            args.add("-l");
            args.add(labelsFilter);
            DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), this.getBaseK8SEnv(), (File)tmpDir, (OutputStream)fos);
        }
        finally {
            fos.close();
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        logger.info((Object)"Get K8S services state");
        fos = new FileOutputStream(new File(tmpDir, "describe-services.txt"));
        try {
            args = this.getBaseK8SCommand();
            args.add("describe");
            args.add("service");
            args.add("-l");
            args.add(labelsFilter);
            DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), this.getBaseK8SEnv(), (File)tmpDir, (OutputStream)fos);
        }
        finally {
            fos.close();
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        logger.info((Object)"Get K8S ingresses state");
        fos = new FileOutputStream(new File(tmpDir, "describe-ingresses.txt"));
        try {
            args = this.getBaseK8SCommand();
            args.add("describe");
            args.add("ingress");
            args.add("-l");
            args.add(labelsFilter);
            DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), this.getBaseK8SEnv(), (File)tmpDir, (OutputStream)fos);
        }
        finally {
            fos.close();
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Get the pod names");
        ArrayList podNames = Lists.newArrayList();
        args = this.getBaseK8SCommand();
        args.add("get");
        args.add("pods");
        args.add("-l");
        args.add(labelsFilter);
        args.add("-o");
        args.add("json");
        byte[] podsOutput = DKUtils.execAndGetOutput((String[])args.toArray(new String[0]), this.getBaseK8SEnv());
        JsonObject podsCmdOutput = (JsonObject)JSON.parse((byte[])podsOutput, JsonObject.class);
        JsonArray pods = podsCmdOutput.getAsJsonArray("items");
        Iterator iterator = pods.iterator();
        while (iterator.hasNext()) {
            JsonElement jsonElement = (JsonElement)iterator.next();
            JsonObject metadata = jsonElement.getAsJsonObject().getAsJsonObject("metadata");
            podNames.add(metadata.getAsJsonPrimitive("name").getAsString());
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        logger.info((Object)("Deployment " + this.deployment.id + " has " + podNames.size() + " pods registered"));
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Generate diagnostics");
        final ExecutorService executorService = Executors.newFixedThreadPool(2);
        final ConcurrentMap diagnosticFutures = Maps.newConcurrentMap();
        try (FutureAborter.AutoCloseableAbortHook aborted = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Abort required, stop generating diagnostics");
                executorService.shutdownNow();
                for (Future diagnosticFuture : diagnosticFutures.values()) {
                    diagnosticFuture.cancel(true);
                }
            }
        });){
            for (Object podName : podNames) {
                diagnosticFutures.put(podName, executorService.submit(new Callable<String>(){
                    final /* synthetic */ String val$podName;
                    final /* synthetic */ File val$tmpDir;
                    final /* synthetic */ FutureThreadBase val$future;
                    {
                        this.val$podName = string2;
                        this.val$tmpDir = file;
                        this.val$future = futureThreadBase;
                    }

                    @Override
                    public String call() throws Exception {
                        String diagnosticLocalName;
                        block20: {
                            List<String> args;
                            String diagnosticPodPath = "/home/dataiku/data/tmp/diag-" + fileFriendlyLocalNow + ".zip";
                            diagnosticLocalName = "diag-" + this.val$podName + ".zip";
                            logger.info((Object)("Generate diag in pod " + this.val$podName));
                            try (FileOutputStream fos = new FileOutputStream(new File(this.val$tmpDir, "gen-diag-" + this.val$podName + ".log"));){
                                args = SingleK8SDeploymentManager.this.getBaseK8SCommand();
                                args.add("exec");
                                args.add(this.val$podName);
                                args.add("--");
                                args.add("/home/dataiku/data/bin/dssadmin");
                                args.add("run-diagnosis");
                                args.add("-c");
                                args.add("-i");
                                args.add("-v");
                                args.add("-s");
                                args.add("-f");
                                args.add("-l");
                                args.add(diagnosticPodPath);
                                DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), SingleK8SDeploymentManager.this.getBaseK8SEnv(), (File)this.val$tmpDir, (OutputStream)fos);
                            }
                            if (this.val$future.isAborted()) {
                                throw new InterruptedException("Diagnosis aborted");
                            }
                            logger.info((Object)("Retrieve diag from pod " + this.val$podName));
                            fos = new FileOutputStream(new File(this.val$tmpDir, diagnosticLocalName));
                            try {
                                args = SingleK8SDeploymentManager.this.getBaseK8SCommand();
                                args.add("exec");
                                args.add(this.val$podName);
                                args.add("--");
                                args.add("cat");
                                args.add(diagnosticPodPath);
                                DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), SingleK8SDeploymentManager.this.getBaseK8SEnv(), (File)this.val$tmpDir, (OutputStream)fos);
                            }
                            finally {
                                fos.close();
                            }
                            logger.info((Object)("Got diag " + diagnosticLocalName));
                            logger.info((Object)("Checking GPU in " + this.val$podName + ", if any"));
                            try {
                                fos = new FileOutputStream(new File(this.val$tmpDir, "nvidia-smi-" + this.val$podName + ".txt"));
                                try {
                                    args = SingleK8SDeploymentManager.this.getBaseK8SCommand();
                                    args.add("exec");
                                    args.add(this.val$podName);
                                    args.add("--");
                                    args.add("nvidia-smi");
                                    DKUtils.execAndWriteOutput((String[])args.toArray(new String[0]), SingleK8SDeploymentManager.this.getBaseK8SEnv(), (File)this.val$tmpDir, (OutputStream)fos);
                                }
                                finally {
                                    fos.close();
                                }
                            }
                            catch (Exception e) {
                                logger.info((Object)"Could not check GPU in the pod, there's probably none");
                                if (!this.val$future.isAborted()) break block20;
                                throw e;
                            }
                        }
                        return diagnosticLocalName;
                    }
                }));
            }
            HashMap diagnostics = Maps.newHashMap();
            for (Map.Entry entry : diagnosticFutures.entrySet()) {
                String podName = (String)entry.getKey();
                try {
                    String diagnostic = (String)((Future)entry.getValue()).get();
                    diagnostics.put(podName, diagnostic);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to get diagnostic from " + podName), (Throwable)e);
                }
            }
            logger.info((Object)("Generated " + diagnostics.size() + " diagnostics on pods"));
            FutureProgress.incrementState((double)1.0);
        }
        executorService.shutdown();
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"User has infra admin permissions ; adding deployment logs");
            File logsDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"deployment-logs"});
            DKUFileUtils.mkdirs((File)logsDir);
            for (Path path : this.apiServiceDeploymentsService.listLogFiles(this.deployment)) {
                FileUtils.copyFileToDirectory((File)path.toFile(), (File)logsDir);
            }
        } else {
            logger.info((Object)"User does not have infra admin permissions ; not adding deployment logs");
        }
        return tmpDir.getName();
    }

    @Override
    void getDiagnosis(HttpServletResponse resp, String diagnosticName) throws Exception {
        File runDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer_diag", this.deployment.id, diagnosticName});
        if (runDir.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + diagnosticName + ".zip\"");
            resp.setStatus(200);
            try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                ZipUnzipDir.zipDirectoryToStream(runDir, bos);
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("Diagnostic dir not found");
        }
    }

    private class SingleK8SDeploymentExposable
    implements Exposables.KubernetesExposable {
        private final File tmpDir;
        private final AuthCtx authCtx;

        public SingleK8SDeploymentExposable(File tmpDir, AuthCtx authCtx) {
            this.tmpDir = tmpDir;
            this.authCtx = authCtx;
        }

        @Override
        public int getContainerizedPort() {
            return 12000;
        }

        @Override
        public String getExposedService() {
            return null;
        }

        @Override
        public File getTmpDir() {
            return this.tmpDir;
        }

        @Override
        public String getNamePrefix() {
            return "dku-mad";
        }

        @Override
        public String getExecutionId() {
            return SingleK8SDeploymentManager.this.k8sExecutionId();
        }

        @Override
        public Map<String, String> getLabels() {
            HashMap<String, String> l = new HashMap<String, String>();
            l.put("dataiku.com/dku-apideployer-infra-id", KubernetesExecUtils.sanitizeLabelValue(SingleK8SDeploymentManager.this.infra.id, false));
            l.put("dataiku.com/dku-apideployer-deployment-id", KubernetesExecUtils.sanitizeLabelValue(SingleK8SDeploymentManager.this.deployment.id, false));
            return l;
        }

        @Override
        public Map<String, String> getAnnotations() {
            HashMap<String, String> l = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)SingleK8SDeploymentManager.this.deployment.annotations)) {
                for (String line : SingleK8SDeploymentManager.this.deployment.annotations.split("\\n")) {
                    try {
                        if (line.contains(":")) {
                            String[] splitLine = line.split(":", 2);
                            l.put(splitLine[0].trim(), splitLine[1].trim());
                            continue;
                        }
                        logger.warnV("Unable to parse/add custom annotation line '%s'", new Object[]{line});
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Unable to parse/add custom annotation line '%s'", new Object[]{line});
                    }
                }
            }
            l.put("dataiku.com/dku-execution-type", ComputeResourceUsageContext.ComputeResourceUsageContextType.API_DEPLOYER_DEPLOYMENT.name());
            l.put("dataiku.com/dku-exec-submitter", this.authCtx.getIdentifier());
            l.put("dataiku.com/dku-install-id", DKUApp.getInstallId());
            l.put("dataiku.com/dku-apideployer-deployment-id", SingleK8SDeploymentManager.this.deployment.id);
            return l;
        }

        @Override
        public Map<String, String> getSelectors() {
            HashMap<String, String> l = new HashMap<String, String>();
            l.put("dataiku.com/dku-apideployer-infra-id", KubernetesExecUtils.sanitizeLabelValue(SingleK8SDeploymentManager.this.infra.id, false));
            l.put("dataiku.com/dku-apideployer-deployment-id", KubernetesExecUtils.sanitizeLabelValue(SingleK8SDeploymentManager.this.deployment.id, false));
            l.put("dataiku.com/dku-execution-type", KubernetesExecUtils.sanitizeLabelValue(ComputeResourceUsageContext.ComputeResourceUsageContextType.API_DEPLOYER_DEPLOYMENT.toString(), false));
            return l;
        }

        @Override
        public String getPropertiesPrefix() {
            return "deployment";
        }

        @Override
        public List<SimpleKeyValue> getProperties() {
            return SingleK8SDeploymentManager.this.deployment.properties;
        }

        @Override
        public String getExposedServiceId() {
            return SingleK8SDeploymentManager.this.deployment.getPublishedItemId();
        }
    }
}

