/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.component;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.PythonPluginCodeStudioCommonUtils;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockService;
import com.dataiku.dip.codestudio.component.LoadedPythonPluginCodeStudioTemplate;
import com.dataiku.dip.codestudio.component.PythonPluginCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.component.PythonPluginCodeStudioTemplateService;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateParams;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PythonPluginCodeStudioTemplateMeta
implements CodeStudioMeta,
IPluginifiedMeta {
    private final LoadedPythonPluginCodeStudioTemplate loadedDesc;
    private final String pluginId;

    public PythonPluginCodeStudioTemplateMeta(String pluginId, LoadedPythonPluginCodeStudioTemplate loadedDesc) {
        this.pluginId = pluginId;
        this.loadedDesc = loadedDesc;
    }

    public LoadedPythonPluginCodeStudioTemplate getDesc() {
        return this.loadedDesc;
    }

    @Override
    public String getType() {
        return this.loadedDesc.elementType;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loadedDesc;
    }

    @Override
    public CodeStudioTemplate.CodeStudioTemplateType getTemplateType() {
        CodeStudioTemplate.CodeStudioTemplateType ret = new CodeStudioTemplate.CodeStudioTemplateType();
        ret.type = this.loadedDesc.elementType;
        ret.label = (String)StringUtils.defaultIfBlank((CharSequence)this.loadedDesc.desc.meta.label, (CharSequence)ret.type);
        ret.description = this.loadedDesc.desc.meta.description;
        return ret;
    }

    @Override
    public CodeStudioObject.CodeStudioObjectType getCodeStudioType(CodeStudioTemplate template) {
        CodeStudioObject.CodeStudioObjectType ret = new CodeStudioObject.CodeStudioObjectType();
        ret.type = this.loadedDesc.elementType;
        ret.templateId = template.id;
        ret.label = template.getLabel();
        ret.shortDesc = template.shortDesc;
        ret.icon = (String)StringUtils.defaultIfBlank((CharSequence)template.icon, this.loadedDesc.desc.meta != null ? this.loadedDesc.desc.meta.icon : null);
        return ret;
    }

    @Override
    public Class<? extends CodeStudioTemplateParams> templateParamsClass() {
        return PythonPluginCodeStudioTemplateParams.class;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec getBuildSpec(AuthCtx authCtx, CodeStudioTemplate template, final CodeStudioMeta.ImageBuildEnv buildEnv) throws Exception {
        PythonPluginCodeStudioTemplateParams params = template.getParamsAs(PythonPluginCodeStudioTemplateParams.class);
        String projectKey = "__DKU_ANY_PROJECT__";
        File tmpDir = new File(buildEnv.workingDir);
        JsonObject config = params.config;
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        APITicketService.Ticket ticket = apiTicketService.createTicket(authCtx, "dss_code_studio:" + this.getType(), (Object)this);
        try {
            switch (this.loadedDesc.desc.mode) {
                case BLOCK_LIST_PROVIDER: {
                    CodeStudioTemplate blockBased = this.computeBlockBasedCodeStudioTemplate(authCtx, projectKey, tmpDir, config, ticket.getSecret(), buildEnv, null, null);
                    CodeStudioMeta.ImageBuildSpec imageBuildSpec = CodeStudioRegistry.getMeta(blockBased).getBuildSpec(authCtx, blockBased, buildEnv);
                    return imageBuildSpec;
                }
                case SPEC_COMPUTER: {
                    PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.ImageBuildSpec> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.ImageBuildSpec>(){

                        @Override
                        public CodeStudioMeta.ImageBuildSpec run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                            PythonPluginCodeStudioCommonUtils.ImageBuildSpecReq req = new PythonPluginCodeStudioCommonUtils.ImageBuildSpecReq();
                            req.code = code;
                            req.codeDefinesBlock = false;
                            req.config = resolvedSettings.config;
                            req.pluginConfig = resolvedSettings.pluginConfig;
                            req.env = buildEnv;
                            req.in = new CodeStudioMeta.ImageBuildSpec();
                            return (CodeStudioMeta.ImageBuildSpec)link.execute((Object)req, CodeStudioMeta.ImageBuildSpec.class, "Failed to compute template");
                        }
                    };
                    PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioTemplateService.class));
                    CodeStudioMeta.ImageBuildSpec imageBuildSpec = utils.run(authCtx, projectKey, tmpDir, ticket.getSecret(), config, command);
                    return imageBuildSpec;
                }
            }
            throw new IllegalArgumentException("Mode not set on template definition");
        }
        finally {
            apiTicketService.expireTicket(ticket);
        }
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec getLaunchSpec(AuthCtx authCtx, CodeStudioTemplate template, final CodeStudioMeta.CodeStudioLaunchEnv launchEnv) throws Exception {
        PythonPluginCodeStudioTemplateParams params = template.getParamsAs(PythonPluginCodeStudioTemplateParams.class);
        String projectKey = launchEnv.projectKey;
        File tmpDir = new File(launchEnv.workingDir);
        JsonObject config = params.config;
        switch (this.loadedDesc.desc.mode) {
            case BLOCK_LIST_PROVIDER: {
                CodeStudioTemplate blockBased = this.computeBlockBasedCodeStudioTemplate(authCtx, projectKey, tmpDir, config, launchEnv.apiTicket, null, launchEnv, null);
                return CodeStudioRegistry.getMeta(blockBased).getLaunchSpec(authCtx, blockBased, launchEnv);
            }
            case SPEC_COMPUTER: {
                PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CodeStudioLaunchSpec> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CodeStudioLaunchSpec>(){

                    @Override
                    public CodeStudioMeta.CodeStudioLaunchSpec run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                        PythonPluginCodeStudioCommonUtils.CodeStudioLaunchSpecReq req = new PythonPluginCodeStudioCommonUtils.CodeStudioLaunchSpecReq();
                        req.code = code;
                        req.codeDefinesBlock = false;
                        req.config = resolvedSettings.config;
                        req.pluginConfig = resolvedSettings.pluginConfig;
                        req.env = launchEnv;
                        req.in = new CodeStudioMeta.CodeStudioLaunchSpec();
                        return (CodeStudioMeta.CodeStudioLaunchSpec)link.execute((Object)req, CodeStudioMeta.CodeStudioLaunchSpec.class, "Failed to compute template");
                    }
                };
                PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioBlockService.class));
                return utils.run(authCtx, projectKey, tmpDir, launchEnv.apiTicket, config, command);
            }
        }
        throw new IllegalArgumentException("Mode not set on template definition");
    }

    @Override
    public CodeStudioMeta.CreationSpec getCreationSpec(AuthCtx authCtx, CodeStudioTemplate template, final CodeStudioMeta.CreationEnv creationEnv) throws Exception {
        PythonPluginCodeStudioTemplateParams params = template.getParamsAs(PythonPluginCodeStudioTemplateParams.class);
        String projectKey = "__DKU_ANY_PROJECT__";
        File tmpDir = new File(creationEnv.tmpDir);
        JsonObject config = params.config;
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        APITicketService.Ticket ticket = apiTicketService.createTicket(authCtx, "dss_code_studio:" + this.getType(), (Object)this);
        try {
            switch (this.loadedDesc.desc.mode) {
                case BLOCK_LIST_PROVIDER: {
                    CodeStudioTemplate blockBased = this.computeBlockBasedCodeStudioTemplate(authCtx, projectKey, tmpDir, config, ticket.getSecret(), null, null, creationEnv);
                    CodeStudioMeta.CreationSpec creationSpec = CodeStudioRegistry.getMeta(blockBased).getCreationSpec(authCtx, blockBased, creationEnv);
                    return creationSpec;
                }
                case SPEC_COMPUTER: {
                    PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CreationSpec> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<CodeStudioMeta.CreationSpec>(){

                        @Override
                        public CodeStudioMeta.CreationSpec run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                            PythonPluginCodeStudioCommonUtils.CreationSpecReq req = new PythonPluginCodeStudioCommonUtils.CreationSpecReq();
                            req.code = code;
                            req.codeDefinesBlock = false;
                            req.config = resolvedSettings.config;
                            req.pluginConfig = resolvedSettings.pluginConfig;
                            req.env = creationEnv;
                            req.in = new CodeStudioMeta.CreationSpec();
                            return (CodeStudioMeta.CreationSpec)link.execute((Object)req, CodeStudioMeta.CreationSpec.class, "Failed to compute template");
                        }
                    };
                    PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioTemplateService.class));
                    CodeStudioMeta.CreationSpec creationSpec = utils.run(authCtx, projectKey, tmpDir, ticket.getSecret(), config, command);
                    return creationSpec;
                }
            }
            throw new IllegalArgumentException("Mode not set on template definition");
        }
        finally {
            apiTicketService.expireTicket(ticket);
        }
    }

    private CodeStudioTemplate computeBlockBasedCodeStudioTemplate(AuthCtx authCtx, String projectKey, File tmpDir, JsonObject config, String ticketSecret, final CodeStudioMeta.ImageBuildEnv buildEnv, final CodeStudioMeta.CodeStudioLaunchEnv launchEnv, final CodeStudioMeta.CreationEnv creationEnv) throws IOException {
        PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<BlockBasedCodeStudioTemplateParams> command = new PythonPluginCodeStudioCommonUtils.CodeStudioKernelCommand<BlockBasedCodeStudioTemplateParams>(){

            @Override
            public BlockBasedCodeStudioTemplateParams run(PluginSettingsResolver.ResolvedSettings resolvedSettings, String code, SingleCommandKernelLink link) throws IOException {
                PythonPluginCodeStudioCommonUtils.CodeStudioBlockListReq req = new PythonPluginCodeStudioCommonUtils.CodeStudioBlockListReq();
                req.code = code;
                req.codeDefinesBlock = false;
                req.config = resolvedSettings.config;
                req.pluginConfig = resolvedSettings.pluginConfig;
                req.buildEnv = buildEnv;
                req.launchEnv = launchEnv;
                req.creationEnv = creationEnv;
                return (BlockBasedCodeStudioTemplateParams)link.execute((Object)req, BlockBasedCodeStudioTemplateParams.class, "Failed to compute template");
            }
        };
        PythonPluginCodeStudioCommonUtils utils = new PythonPluginCodeStudioCommonUtils(this.pluginId, this.getType(), (CustomPythonElementService)SpringUtils.getBean(PythonPluginCodeStudioTemplateService.class));
        CodeStudioTemplate blockBasedTemplate = new CodeStudioTemplate();
        blockBasedTemplate.type = "block_based";
        blockBasedTemplate.id = "__not_used__";
        blockBasedTemplate.params = utils.run(authCtx, projectKey, tmpDir, ticketSecret, config, command);
        return blockBasedTemplate;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportTemplate(AuthCtx authCtx, CodeStudioTemplate template) throws Exception {
        throw new UnsupportedOperationException("Cannot export plugin templates");
    }

    @Override
    public CodeStudioTemplate importTemplate(AuthCtx authCtx, CodeStudioTemplate srcTemplate, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) throws Exception {
        throw new UnsupportedOperationException("Cannot import plugin templates");
    }
}

