/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.common.krb.Krb5KeytabLoginContext;
import com.dataiku.common.krb.Krb5KeytabLoginContextCache;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.KerberizableConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SynapseSQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SQLServerConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials,
KerberizableConnection {
    private static final long TOKEN_MIN_VALIDITY = 600000L;
    public static final String connectionType = "SQLServer";
    public Params params = new Params();
    private static SQLServerSQLDialect dialect;
    private static SynapseSQLDialect dwhDialect;
    private static Logger logger;

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.isOAuthLoginEnabled() && (this.getGrantType() == GrantType.AUTHORIZATION_CODE || this.getGrantType() == GrantType.DEVICE_CODE);
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.refreshTokenRotation;
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        Object scope = "https://database.windows.net/.default";
        if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
            scope = (String)scope + " offline_access";
        }
        return new OAuth2Client.Builder().authorizationEndpoint(this.params.azureOAuth2AuthorizationEndpoint).tokenEndpoint(this.params.azureOAuth2TokenEndpoint).clientId(this.params.azureOAuthLoginClientId).clientSecret(this.params.azureOAuthLoginClientSecret).scope((String)scope).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAzureAccessToken(authCtx, this.getProxySettings()));
    }

    private String getAzureAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
            logger.info((Object)"Exchanging user's refresh token for an access token");
            try {
                OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
                OAuth2Client.AccessTokenResult result = this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
                return result.getAccessToken();
            }
            catch (DKUSecurityException e) {
                throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
            }
            catch (ParseException | IOException | URISyntaxException e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
            }
        }
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            OAuth2Client.AccessTokenResult accessTokenResult = oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
            String string = accessTokenResult.getAccessToken();
            return string;
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "Failed to get access token", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    public GrantType getGrantType() {
        return this.params.grantType;
    }

    public boolean isOAuthLoginEnabled() {
        return this.params.azureOAuthLoginEnabled;
    }

    public int getPort() {
        return this.params.port;
    }

    private static void initSQLDialect() {
        if (dialect == null) {
            dialect = new SQLServerSQLDialect();
        }
    }

    private static void initDWHDialect() {
        if (dwhDialect == null) {
            dwhDialect = new SynapseSQLDialect();
        }
    }

    @Override
    public SQLServerSQLDialect getDialect() {
        if (this.params.azureDWH) {
            SQLServerConnection.initDWHDialect();
            return dwhDialect;
        }
        SQLServerConnection.initSQLDialect();
        return dialect;
    }

    @Override
    String getJarsDirectory() {
        switch (this.params.driverMode) {
            case MANAGED: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-sqlserver"}).getAbsolutePath();
            }
            case CUSTOM: {
                return this.params.jarsDirectory;
            }
        }
        throw new Error("unreachable");
    }

    protected ConnectionUtils.SQLConnectionType getSQLConnectionType() {
        return ConnectionUtils.SQLConnectionType.SQLSERVER;
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException {
        SQLConnectionProvider.GenericSQLConnectionData cd;
        SerializableSQLServerCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableSQLServerCredentials.class);
        String proxyUserNameStashName = "dku.params.proxyUserName";
        if (this.isKerberosLoginEnabled()) {
            logger.info((Object)("Log using kerberos, as " + this.params.dssPrincipal + " (proxy=" + this.params.proxyUserName + ")"));
            cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getSQLConnectionType(), this.getDialect(), this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory()){

                @Override
                protected Subject getDoAs() throws Exception {
                    return Krb5KeytabLoginContextCache.get(SQLServerConnection.this.params.dssPrincipal, SQLServerConnection.this.params.dssKeytabPath).getSubject();
                }

                @Override
                protected void addProxyUserProperties(AuthCtx authCtx, Properties props, Map<String, String> hiddenProps, Subject doAs) throws Exception {
                    String expandedProxyUserName = hiddenProps.get("dku.params.proxyUserName");
                    if (StringUtils.isNotBlank((String)expandedProxyUserName)) {
                        props.remove("dku.params.proxyUserName");
                        props.put("gsscredential", Krb5KeytabLoginContext.getImpersonatedCredential(doAs, expandedProxyUserName));
                    }
                }
            };
        } else {
            cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getSQLConnectionType(), (SQLDialect)this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        }
        this.fillConnectionData(cd);
        if (this.actuallyHasBasicCredential() && creds != null) {
            if (creds.user != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
            }
            if (creds.password != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
            }
        }
        if (this.getPort() > 0) {
            cd.withProperty("portNumber", String.valueOf(this.getPort()));
        }
        cd.withHiddenProperty("dku.params.proxyUserName", this.params.proxyUserName);
        cd.withPropertyIfNotBlank("instanceName", this.params.instance);
        cd.withPropertyIfNotBlank("databaseName", this.params.db);
        if (this.isOAuthLoginEnabled()) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("accessToken", creds.oauth2AccessToken, true));
        }
        return cd;
    }

    @Override
    String getDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"SQL server connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return "jdbc:sqlserver://" + this.params.host;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public boolean isKerberosLoginEnabled() {
        return this.params.kerberosLoginEnabled;
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return !this.isKerberosLoginEnabled() && !this.isOAuthLoginEnabled();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.azureOAuthLoginClientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.azureOAuthLoginClientSecret);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.azureOAuthLoginClientSecret = cryptoService.decryptIfEncrypted(this.params.azureOAuthLoginClientSecret);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableSQLServerCredentials.class));
        SerializableSQLServerCredentials creds = new SerializableSQLServerCredentials();
        if (this.isKerberosLoginEnabled()) {
            creds.authType = AuthType.KERBEROS;
        } else if (this.isOAuthLoginEnabled()) {
            creds.authType = AuthType.OAUTH2;
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            try {
                creds.oauth2AccessToken = this.getAzureAccessToken(ctx.authCtx, this.getProxySettings());
            }
            catch (Exception e) {
                throw new SQLException("OAuth authentication failure", e);
            }
            finally {
                executorService.shutdown();
            }
        } else {
            creds.authType = AuthType.PASSWORD;
            ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
            creds.user = basicCreds != null ? basicCreds.user : null;
            creds.password = basicCreds != null ? basicCreds.password : null;
        }
        return clazz.cast(creds);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (this.isKerberosLoginEnabled()) {
            ret.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Kerberos login isn't compatible with direct access from Spark");
        }
        if (this.isOAuthLoginEnabled()) {
            ret.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "OAuth login isn't compatible with direct access from Spark");
        }
        return ret;
    }

    static {
        logger = Logger.getLogger((String)"dip.connections.sqlserver");
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = -1;
        public String instance;
        public SQLServerDriverMode driverMode = SQLServerDriverMode.MANAGED;
        public boolean azureDWH;
        public boolean azureOAuthLoginEnabled;
        public GrantType grantType = GrantType.AUTHORIZATION_CODE;
        public String azureOAuth2AuthorizationEndpoint;
        public String azureOAuth2TokenEndpoint;
        public String azureOAuthLoginClientId;
        public String azureOAuthLoginClientSecret;
        public boolean refreshTokenRotation;
        public boolean kerberosLoginEnabled;
        public String dssPrincipal;
        public String dssKeytabPath;
        public String proxyUserName;
        public boolean useAutoFastPath;
        public String autoFastPathConnection;
        public String autoFastPathConnectionPath;
        public boolean useManagedIdentityForFastPath;

        @Override
        public void expandInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
            super.expandInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
            this.instance = vc.expand(this.instance);
        }
    }

    public static enum GrantType {
        AUTHORIZATION_CODE,
        DEVICE_CODE;

    }

    public static enum SQLServerDriverMode {
        MANAGED,
        CUSTOM;

    }

    public class SerializableSQLServerCredentials
    implements ICredentialsService.BasicCredentialConvertible {
        public AuthType authType;
        public String user;
        public String password;
        public String oauth2RefreshToken;
        public String oauth2AccessToken;

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.user, this.password);
        }

        public ICredentialsService.OAuth2Credential toOAuth2Credential() {
            return new ICredentialsService.OAuth2Credential(this.oauth2AccessToken);
        }
    }

    public static enum AuthType {
        PASSWORD,
        KERBEROS,
        OAUTH2;

    }
}

