/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TwitterConnection
extends DSSConnection
implements ConnectionWithEncryptedFields {
    public Params params = new Params();
    public static final String connectionType = "Twitter";

    public TwitterConnection() {
    }

    public TwitterConnection(String name) {
        this.name = name;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.api_key = vc.expand(this.params.api_key);
        this.params.api_secret = vc.expand(this.params.api_secret);
        this.params.token_key = vc.expand(this.params.token_key);
        this.params.token_secret = vc.expand(this.params.token_secret);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableTwitterCredentials.class));
        SerializableTwitterCredentials creds = new SerializableTwitterCredentials();
        creds.api_key = this.params.api_key;
        creds.api_secret = this.params.api_secret;
        creds.token_key = this.params.token_key;
        creds.token_secret = this.params.token_secret;
        return clazz.cast(creds);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.api_secret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.api_secret);
        this.params.token_secret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.token_secret);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.api_secret = cryptoService.decryptIfEncrypted(this.params.api_secret);
        this.params.token_secret = cryptoService.decryptIfEncrypted(this.params.token_secret);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testTwitter(this);
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public String api_key;
        public String api_secret;
        public String token_key;
        public String token_secret;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }

    public static class SerializableTwitterCredentials {
        public String api_key;
        public String api_secret;
        public String token_key;
        public String token_secret;
    }
}

