/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimpleResult {
    public final Schema schema;
    public final List<Row> rows = new ArrayList<Row>();

    public SimpleResult() {
        this.schema = new Schema();
    }

    public SimpleResult(Schema schema) {
        this.schema = schema;
    }

    public Row newRow() {
        Row row = new Row(this.schema);
        this.rows.add(row);
        return row;
    }

    public static class Schema {
        public final List<Column> columns = new ArrayList<Column>();

        public Schema withColumn(String columnName) {
            this.columns.add(new Column(columnName, 12));
            return this;
        }

        public Schema withColumn(String columnName, int columnType) {
            this.columns.add(new Column(columnName, columnType));
            return this;
        }

        public int findColumn(String columnName) {
            int columnsSize = this.columns.size();
            for (int i = 0; i < columnsSize; ++i) {
                Column column = this.columns.get(i);
                if (!Objects.equals(column.name, columnName)) continue;
                return i + 1;
            }
            return 0;
        }
    }

    public static class Row {
        public final Schema schema;
        public final Map<String, Object> values = new HashMap<String, Object>();

        public Row(Schema schema) {
            Preconditions.checkNotNull((Object)schema, (Object)"schema");
            this.schema = schema;
        }

        public Row withValue(String column, Object value) {
            Preconditions.checkArgument((this.schema.findColumn(column) > 0 ? 1 : 0) != 0, (Object)("Invalid column name: " + column));
            this.values.put(column, value);
            return this;
        }
    }

    public static class Column {
        public final String name;
        public final int type;

        public Column(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

