/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.containers.exec.KubernetesNamespacesService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.CloseShieldOutputStream;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class KubectlHelper {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.k8s");

    private static DKUtils.ExecutionResults executeKubectl(ContainerExecUtils.KubernetesAwareContainerConfig ks, boolean jsonOutput, String ... args) throws IOException, InterruptedException {
        DKUtils.ExecutionResults er = KubectlHelper.executeKubectlToExecResults(ks, jsonOutput, args);
        if (er.rv != 0) {
            throw new IOException("kubectl failed with code=" + er.rv + " out=" + er.out + " err=" + er.err);
        }
        return er;
    }

    public static DKUtils.ExecutionResults executeKubectlToExecResults(ContainerExecUtils.KubernetesAwareContainerConfig ks, boolean jsonOutput, String ... args) throws IOException, InterruptedException {
        ProcessBuilder pb = KubectlHelper.makeProcessBuilder(ks, jsonOutput, args);
        logger.debug((Object)("Running kubectl (KUBECONFIG=" + pb.environment().get("KUBECONFIG") + "): " + StringUtils.join(pb.command(), (String)" ")));
        return DKUtils.execAndGetOutputAndErrors((ProcessBuilder)pb);
    }

    public static void logKubectl(ContainerExecUtils.KubernetesAwareContainerConfig ks, boolean jsonOutput, File to, String ... args) throws IOException, InterruptedException {
        ProcessBuilder pb = KubectlHelper.makeProcessBuilder(ks, jsonOutput, args);
        if (to == null) {
            DKUtils.execAndLogThrows((ProcessBuilder)pb);
        } else {
            DKUtils.execAndLogToFileThrows((ProcessBuilder)pb, (File)to);
        }
    }

    private static ProcessBuilder makeProcessBuilder(ContainerExecUtils.KubernetesAwareContainerConfig ks, boolean jsonOutput, String ... args) {
        if (ks.noImplicitK8sClusterAndNoDefaultClusterId) {
            throw new RuntimeException("No default Kubernetes cluster selected and option `use builtin Kubernetes cluster` is disabled");
        }
        ArrayList argsList = Lists.newArrayList();
        argsList.add("kubectl");
        if (StringUtils.isNotBlank((String)ks.kubeCtlContext)) {
            argsList.add("--context");
            argsList.add(ks.kubeCtlContext);
        }
        argsList.addAll(Lists.newArrayList((Object[])args));
        if (jsonOutput) {
            argsList.add("-o");
            argsList.add("json");
        }
        ProcessBuilder pb = new ProcessBuilder(argsList);
        if (StringUtils.isNotBlank((String)ks.kubeConfigPath)) {
            pb.environment().put("KUBECONFIG", ks.kubeConfigPath);
        }
        return pb;
    }

    public static JsonObject executeKubectlToJSON(ContainerExecUtils.KubernetesAwareContainerConfig ks, String ... args) throws IOException, InterruptedException {
        DKUtils.ExecutionResults er = KubectlHelper.executeKubectl(ks, true, args);
        return (JsonObject)JSON.parse((String)er.out, JsonObject.class);
    }

    public static String executeKubectlToJSONString(ContainerExecUtils.KubernetesAwareContainerConfig ks, String ... args) throws InterruptedException, IOException {
        DKUtils.ExecutionResults er = KubectlHelper.executeKubectl(ks, true, args);
        return er.out;
    }

    public static String executeKubectlToRawString(ContainerExecUtils.KubernetesAwareContainerConfig ks, String ... args) throws InterruptedException, IOException {
        DKUtils.ExecutionResults er = KubectlHelper.executeKubectl(ks, false, args);
        return er.out;
    }

    public static void executeKubectlToVoid(ContainerExecUtils.KubernetesAwareContainerConfig ks, String ... args) throws InterruptedException, IOException {
        KubectlHelper.executeKubectl(ks, false, args);
    }

    public static String[] parseCommand(String commandArgs) {
        ArrayList<String> commandParts = new ArrayList<String>();
        Pattern regex = Pattern.compile("(?<=(^|\\s{1,99999}))(\\S*'[^']+'|\\S*\"[^\"]+\"|[\\S]*)(?=(\\s{1,99999}|$))");
        Matcher regexMatcher = regex.matcher(commandArgs);
        while (regexMatcher.find()) {
            String arg = regexMatcher.group();
            if (!StringUtils.isNotBlank((String)arg)) continue;
            commandParts.add(arg);
        }
        KubectlHelper.sanitizeCommandArgs(commandParts);
        return commandParts.toArray(new String[0]);
    }

    private static void sanitizeCommandArgs(List<String> commandArgs) {
        if (commandArgs.isEmpty()) {
            return;
        }
        if ("kubectl".equals(commandArgs.get(0))) {
            commandArgs.remove(0);
        }
        Pattern argsWithQuotes = Pattern.compile("^-{0,2}[a-zA-Z-]*=?([\"']).*[\"']$");
        for (int i = 0; i < commandArgs.size(); ++i) {
            String current = commandArgs.get(i);
            Matcher matchArgsWithQuotes = argsWithQuotes.matcher(current);
            if (!matchArgsWithQuotes.matches()) continue;
            String quote = matchArgsWithQuotes.group(1);
            int lastQuoteIndex = current.lastIndexOf(quote);
            current = current.substring(0, lastQuoteIndex).replaceFirst(quote, "");
            commandArgs.set(i, current);
        }
    }

    @Nullable
    public static KubectlLoopCommandRunner createPodDescriber(AuthCtx authCtx, String projectKey, JobActivity activity, ContainerExecRuntimeConfig containerConfig, String executionId) throws IOException {
        ArrayList commandArgs = Lists.newArrayList((Object[])new String[]{"describe", "pods", "-l", "dataiku.com/dku-execution-id=" + executionId});
        return KubectlHelper.createPodCommandRunner(authCtx, projectKey, activity, containerConfig, "description", "describe", commandArgs);
    }

    @Nullable
    public static KubectlLoopCommandRunner createPodTopper(AuthCtx authCtx, String projectKey, JobActivity activity, ContainerExecRuntimeConfig containerConfig, String executionId) throws IOException {
        ArrayList commandArgs = Lists.newArrayList((Object[])new String[]{"top", "pods", "-l", "dataiku.com/dku-execution-id=" + executionId});
        return KubectlHelper.createPodCommandRunner(authCtx, projectKey, activity, containerConfig, "top", "top", commandArgs);
    }

    @Nullable
    public static KubectlLoopCommandRunner createPodCommandRunner(AuthCtx authCtx, String projectKey, JobActivity activity, ContainerExecRuntimeConfig containerConfig, String label, String verb, List<String> commandArgs) throws IOException {
        String capitalizedVerb;
        String propertyKey;
        Params dkuParams = ProjectsUtils.getMandatoryUnsafe_AutoTXN(projectKey).getDkuPropertiesAsParams(true);
        if (!dkuParams.getBoolParam("dku.code.k8s." + (propertyKey = "gatherPods" + (capitalizedVerb = StringUtils.capitalize((String)verb)) + "sDuringJobs") + ".enabled", true)) {
            logger.infoV("Kubernetes pods %s is disabled", new Object[]{label});
            return null;
        }
        long intervalMS = dkuParams.getLongParam("dku.code.k8s." + propertyKey + ".intervalMS", 60000L);
        logger.infoV("Gathering Kubernetes pods %s every %d ms", new Object[]{label, intervalMS});
        File outputFile = FlowJobUtils.getJobTouchedFile("code-k8s-recipe", "pods-" + verb + ".log");
        activity.getStatus().addStatutOutput("Pods " + capitalizedVerb + "s", outputFile, "text/plain");
        ArrayList fullCommandArgs = Lists.newArrayList(commandArgs);
        String namespace = KubernetesNamespacesService.getNamespace(authCtx, projectKey, containerConfig);
        if (StringUtils.isNotBlank((String)namespace)) {
            fullCommandArgs.add("--namespace=" + namespace);
        }
        return new KubectlLoopCommandRunner(label, containerConfig, outputFile, new KubernetesExecUtils.PodEventsSniffer(), intervalMS, fullCommandArgs.toArray(new String[0]));
    }

    public static class KubectlLoopCommandRunner
    extends KubectlLoopCaller {
        private final String label;
        private final String[] args;
        private final long interval;
        private final DKUtils.LineSubscription lineHandler;

        public KubectlLoopCommandRunner(String label, ContainerExecUtils.KubernetesAwareContainerConfig ks, File outputFile, DKUtils.LineSubscription lineHandler, long interval, String ... args) {
            this.label = label;
            this.ks = ks;
            this.outputFile = outputFile;
            this.args = args;
            this.interval = interval;
            this.lineHandler = lineHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    DKUtils.ExecBuilder eb = null;
                    OutputStream fos = null;
                    KubectlLoopCommandRunner kubectlLoopCommandRunner = this;
                    synchronized (kubectlLoopCommandRunner) {
                        if (this.aborted) {
                            return;
                        }
                        ProcessBuilder pb = KubectlHelper.makeProcessBuilder(this.ks, false, this.args);
                        fos = DKUFileUtils.writeWithAutoCompress((File)this.outputFile, (boolean)true);
                        try (OutputStreamWriter owr = new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(fos));){
                            owr.write("*************************************************************\n");
                            owr.write(DKUDateUtils.isoFormatLocalNow() + ": " + this.label + " (" + StringUtils.join((Object[])this.args, (String)" ") + ")\n");
                            owr.write("*************************************************************\n");
                        }
                        eb = this.makeEB(pb, fos, this.lineHandler);
                    }
                    eb.exec();
                    try (OutputStreamWriter owr = new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(fos));){
                        owr.write("\n\n");
                    }
                    kubectlLoopCommandRunner = this;
                    synchronized (kubectlLoopCommandRunner) {
                        fos.close();
                        this.killer = null;
                    }
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Sleep interrupted, stopping thread");
                    return;
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to run command on pods", (Throwable)e);
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Sleep interrupted, stopping thread");
                    return;
                }
            }
        }
    }

    public static class KubectlLoopLogger
    extends KubectlLoopCaller {
        private final DKUtils.LineSubscription lineHandler;
        private final List<String> baseArgs;
        private final long interval;

        public KubectlLoopLogger(ContainerExecUtils.KubernetesAwareContainerConfig ks, File outputFile, String namespace, String selector, DKUtils.LineSubscription lineHandler, long interval) {
            this.ks = ks;
            this.outputFile = outputFile;
            this.lineHandler = lineHandler;
            this.interval = interval;
            this.baseArgs = Lists.newArrayList((Object[])new String[]{"logs", "--namespace=" + namespace, "--all-containers", "--max-log-requests", "1000", "--timestamps", "--tail", "400", "-l", selector});
            if (DKUApp.getParams().getBoolParam("dku.k8s.kubectl.supportsPrefix", false)) {
                this.baseArgs.add("--prefix");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long previousLoopTime = 0L;
            while (true) {
                try {
                    DKUtils.ExecBuilder eb = null;
                    OutputStream fos = null;
                    KubectlLoopLogger kubectlLoopLogger = this;
                    synchronized (kubectlLoopLogger) {
                        if (this.aborted) {
                            return;
                        }
                        long now = System.currentTimeMillis();
                        ArrayList args = Lists.newArrayList(this.baseArgs);
                        if (previousLoopTime > 0L) {
                            long sinceTimeSeconds = (now - previousLoopTime) / 1000L;
                            args.add("--since=" + sinceTimeSeconds + "s");
                        }
                        previousLoopTime = now;
                        ProcessBuilder pb = KubectlHelper.makeProcessBuilder(this.ks, false, args.toArray(new String[0]));
                        fos = DKUFileUtils.writeWithAutoCompress((File)this.outputFile, (boolean)true);
                        try (OutputStreamWriter owr = new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(fos));){
                            owr.write("*************************************************************\n");
                            owr.write(DKUDateUtils.isoFormatLocalNow() + ": pod logs (" + StringUtils.join((Collection)args, (String)" ") + ")\n");
                            owr.write("*************************************************************\n");
                        }
                        eb = this.makeEB(pb, fos, this.lineHandler);
                    }
                    eb.exec();
                    try (OutputStreamWriter owr = new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(fos));){
                        owr.write("\n\n");
                    }
                    kubectlLoopLogger = this;
                    synchronized (kubectlLoopLogger) {
                        fos.close();
                        fos = null;
                        eb = null;
                        this.killer = null;
                    }
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Sleep interrupted, stopping thread");
                    return;
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to get pods logs", (Throwable)e);
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Sleep interrupted, stopping thread");
                    return;
                }
            }
        }
    }

    public static abstract class KubectlLoopCaller
    extends Thread {
        protected boolean aborted;
        protected DKUtils.ExecKiller killer;
        protected File outputFile;
        protected ContainerExecUtils.KubernetesAwareContainerConfig ks;

        public synchronized void cancel() {
            this.aborted = true;
            if (this.killer != null) {
                this.killer.kill();
            }
        }

        protected DKUtils.ExecBuilder makeEB(ProcessBuilder pb, OutputStream targetStream, DKUtils.LineSubscription lineHandler) {
            DKUtils.ExecBuilder eb = new DKUtils.ExecBuilder().withProcessBuilder(pb).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription(targetStream, false)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription(targetStream, false)).withCompletionHandler((DKUtils.ExecCompletionHandler)new DKUtils.SimpleExceptionExecCompletionHandler(pb.command()));
            if (lineHandler != null) {
                eb.withOutputConsumer((DKUtils.ExecSubscription)lineHandler);
                eb.withErrorConsumer((DKUtils.ExecSubscription)lineHandler);
            }
            this.killer = eb.makeNiceThenEvilKiller();
            return eb;
        }
    }
}

