/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import java.util.Map;

public interface IPersistentNotificationsInternalDB {
    public void insert(String var1, String var2, DSSEvent var3, boolean var4);

    public void update(String var1, String var2, long var3, DSSEvent var5);

    public Map<String, List<PersistentNotification>> getForAllUsers();

    public List<PersistentNotification> getForUser(String var1);

    public int getUnreadCountForUser(String var1) throws Exception;

    public void updateTask(String var1, DSSEvent var2);

    public void deleteForUser(String var1);

    public void create() throws CodedSQLException;

    public boolean acknowledge(String var1, long var2);

    public boolean acknowledgeObject(String var1, String var2);

    public PersistentNotification getLatestForUserAndObject(String var1, String var2);

    public static class PersistentNotification {
        public long timestamp;
        public String evtType;
        public boolean unread;
        public UserEvent evt;
        public Object details;

        public PersistentNotification() {
        }

        public PersistentNotification(PersistentNotification other) {
            this.timestamp = other.timestamp;
            this.evtType = other.evtType;
            this.evt = other.evt;
            this.unread = other.unread;
        }

        public String toHumanReadableString(MarkupFormatter links) {
            if (this.evt instanceof EventWithHumanReadableString) {
                EventWithHumanReadableString hrevt = (EventWithHumanReadableString)((Object)this.evt);
                return hrevt.toHumanReadableString(links);
            }
            return JSON.json((Object)this.evt);
        }
    }
}

