/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacollections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionColumnsCustomization;
import com.dataiku.dip.datacollections.DataCollectionDataset;
import com.dataiku.dip.datacollections.DataCollectionsByItem;
import com.dataiku.dip.datacollections.DataCollectionsDAO;
import com.dataiku.dip.datacollections.UIDataCollection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.DataCollectionPermissionsService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.PermissionsWatchersService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.datasets.DataStewardService;
import com.dataiku.dip.server.notifications.backend.DataCollectionChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataCollectionsService {
    private static final String[] DATA_COLLECTION_STOCK_COLORS = new String[]{"#540d6e", "#ee4266", "#ffd23f", "#3bceac", "#43aa8b", "#118ab2", "#073b4c"};
    private static final int RECENT_DATASET_LIMIT = 25;
    @Autowired
    private DataCollectionsDAO dataCollectionsDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDBService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private DataCollectionPermissionsService dataCollectionPermissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PermissionsWatchersService permissionsWatchersService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    private DataStewardService dataStewardService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.data-collections");

    public static boolean isValidDataCollectionId(String dataCollectionId) {
        return StringUtils.isNotBlank((String)dataCollectionId) && dataCollectionId.matches("^[A-Za-z0-9]{8}$");
    }

    public DataCollection createDataCollection(DSSAuthCtx authCtx, UIDataCollection.CreationInfo creationInfo) throws IOException, DKUSecurityException {
        return this.createDataCollection(authCtx, new DataCollection(creationInfo));
    }

    public DataCollection createDataCollection(DSSAuthCtx authCtx, DataCollection dataCollection) throws IOException, DKUSecurityException {
        Preconditions.checkNotNull((Object)dataCollection, (Object)"Data collection cannot be null");
        Preconditions.checkArgument((!StringUtils.isBlank((String)dataCollection.getId()) ? 1 : 0) != 0, (Object)"Data collection id cannot be null or empty");
        Preconditions.checkArgument((!this.dataCollectionsDAO.exists(dataCollection.getId()) ? 1 : 0) != 0, (Object)"A data collection with the specified id already exists.");
        Preconditions.checkArgument((!StringUtils.isBlank((String)dataCollection.getDisplayName()) ? 1 : 0) != 0, (Object)"Data collection name cannot be empty");
        if (StringUtils.isBlank((String)dataCollection.description)) {
            String associatedDSSUser = authCtx.getAssociatedDSSUser();
            String userDisplayName = associatedDSSUser != null ? this.usersService.getPublicUser((String)associatedDSSUser).displayName : authCtx.getIdentifier();
            dataCollection.description = "The data collection *" + dataCollection.displayName + "* was created by " + userDisplayName + " on " + ProjectsService.getDateForShortDesc();
        }
        if (StringUtils.isBlank((String)dataCollection.color) || !dataCollection.color.startsWith("#")) {
            dataCollection.color = DATA_COLLECTION_STOCK_COLORS[Math.abs(dataCollection.id.hashCode() % DATA_COLLECTION_STOCK_COLORS.length)];
        }
        String userId = authCtx.getIdentifier();
        dataCollection.permissions.add(BasePermissions.PermissionItem.ofUser(userId, true, true, true));
        this.dataCollectionPermissionsService.checkAllUserGroupCanBeAdded(dataCollection);
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_CREATE, dataCollection.items);
        return dataCollection;
    }

    public Set<String> listAllTags() throws IOException {
        HashSet<String> tags = new HashSet<String>();
        for (DataCollection dataCollection : this.dataCollectionsDAO.listUnsafe()) {
            if (dataCollection == null || dataCollection.tags == null) continue;
            tags.addAll(dataCollection.tags);
        }
        return tags;
    }

    public UIDataCollection.AddObjectsResponse addDatasets(String dataCollectionId, List<TaggableObjectsService.TaggableObjectRef> objectsToAdd) throws IOException {
        Preconditions.checkNotNull((Object)dataCollectionId, (Object)"Data collection id cannot be null");
        Preconditions.checkArgument((boolean)this.dataCollectionsDAO.exists(dataCollectionId), (Object)"Data collection doesn't exist");
        Preconditions.checkNotNull(objectsToAdd, (Object)"No objects to add to Data Collection");
        Preconditions.checkArgument((!objectsToAdd.contains(null) ? 1 : 0) != 0, (Object)"Data collection cannot contain null objects");
        for (TaggableObjectsService.TaggableObjectRef objectToAdd2 : objectsToAdd) {
            Preconditions.checkArgument((boolean)this.datasetsDAO.exists(objectToAdd2.projectKey, objectToAdd2.id), (Object)("Dataset doesn't exist: " + objectToAdd2.id));
        }
        DataCollection dataCollection = this.dataCollectionsDAO.getMandatory(dataCollectionId);
        Set<AbstractDataCollectionItem> itemsToAdd = objectsToAdd.stream().map(objectToAdd -> new DataCollectionDataset(objectToAdd.getLoc(), System.currentTimeMillis())).filter(dataCollectionDataset -> !dataCollection.contains(dataCollectionDataset.getRef())).collect(Collectors.toSet());
        boolean isAnyItemAdded = dataCollection.items.addAll(itemsToAdd);
        boolean allDataStewardsDefined = true;
        for (TaggableObjectsService.TaggableObjectRef objectToAdd3 : objectsToAdd) {
            boolean noDataStewardNotEvenDefault;
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(objectToAdd3.projectKey, objectToAdd3.id);
            boolean bl = noDataStewardNotEvenDefault = sd.getDataSteward() == null && this.dataStewardService.getDefaultDataStewardLogin(sd) == null;
            if (noDataStewardNotEvenDefault) {
                allDataStewardsDefined = false;
                break;
            }
            if (dataCollection.metadataCompletenessChecks.longDescriptionCheck == DataCollection.CompletenessCheckType.ERROR && StringUtils.isBlank((String)sd.description)) {
                throw new IOException("Missing Dataset long description for " + sd.name + " to be able to publish on this data collection");
            }
            if (dataCollection.metadataCompletenessChecks.columnsDescriptionCheck != DataCollection.CompletenessCheckType.ERROR) continue;
            Schema sdSchema = sd.getSchema();
            if (sdSchema != null) {
                for (SchemaColumn column : sdSchema.getColumns()) {
                    if (!StringUtils.isBlank((String)column.comment)) continue;
                    throw new IOException("Missing Column description for " + sd.name + " to be able to publish on this data collection");
                }
                continue;
            }
            throw new IOException("Invalid Schema for " + sd.name + " cannot publish on this data collection");
        }
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_EDIT_ITEMS, itemsToAdd);
        return new UIDataCollection.AddObjectsResponse(isAnyItemAdded, allDataStewardsDefined);
    }

    public boolean saveDatasetAuthorizationAndSharing_T(String projectKey, Collection<UIDataCollection.AddObject> items) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        SerializedProject project = null;
        boolean hasReaderAuthBeenChanged = false;
        boolean hasExposedBeenChanged = false;
        project = this.projectsService.getMandatory(projectKey);
        for (UIDataCollection.AddObject item : items) {
            if (item.requestedReaderAuthorizations != null && !item.requestedReaderAuthorizations.isEmpty()) {
                hasReaderAuthBeenChanged |= project.dashboardAuthorizations.addAuthorization(new SmartObjectRef(item.ref.type, item.ref.id), item.requestedReaderAuthorizations);
            }
            if (!item.requestQuickSharing) continue;
            TaggableObjectsService.TaggableObjectRef tor = item.ref;
            hasExposedBeenChanged |= project.exposedObjects.setQuickSharing(tor.type, tor.id, true);
        }
        if (hasExposedBeenChanged) {
            TaggableObjectChangedEvent.ProjectEditSubtype changeType = hasReaderAuthBeenChanged ? TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN : TaggableObjectChangedEvent.ProjectEditSubtype.QUICK_SHARE_ONLY;
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(projectKey);
            this.projectsService.save(project, changeType);
            pw.stop();
        } else if (hasReaderAuthBeenChanged) {
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
        }
        return hasExposedBeenChanged || hasReaderAuthBeenChanged;
    }

    public UIDataCollection.DataCollectionInfo getDataCollectionInfo_NT(AuthCtx authCtx, String collectionId) throws IOException, DKUSecurityException {
        DataCollection dataCollection;
        TransactionContext.assertNoAttachedTransaction();
        Preconditions.checkNotNull((Object)collectionId);
        AbstractDataCollectionItem.SummarizeContext context = new AbstractDataCollectionItem.SummarizeContext();
        BasePermissions.Permissions currentUserPermissions = new BasePermissions.Permissions();
        try (Transaction t = this.transactionService.beginRead();){
            dataCollection = this.dataCollectionsDAO.getMandatoryUnsafe(collectionId);
            for (AbstractDataCollectionItem item2 : dataCollection.items) {
                if (!(item2 instanceof DataCollectionDataset)) continue;
                AnyLoc loc = ((DataCollectionDataset)item2).reference;
                if (!context.projects.containsKey(loc.getProjectKey())) {
                    context.projects.put(loc.getProjectKey(), this.projectsDAO.getOrNullUnsafe(loc.getProjectKey()));
                }
                context.datasets.put(loc, (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc));
                context.datasetVisibility.put(loc, this.projectsService.getDataCollectionObjectVisibility(authCtx, loc.getProjectKey(), ITaggingService.TaggableType.DATASET, loc.getId()));
            }
            currentUserPermissions.admin = this.dataCollectionPermissionsService.hasDataCollectionPrivileges(authCtx, dataCollection, Privileges.DataCollectionLevelPrivilegeType.ADMIN);
            currentUserPermissions.write = currentUserPermissions.admin || this.dataCollectionPermissionsService.hasDataCollectionPrivileges(authCtx, dataCollection, Privileges.DataCollectionLevelPrivilegeType.WRITE);
            currentUserPermissions.read = currentUserPermissions.write || this.dataCollectionPermissionsService.hasDataCollectionPrivileges(authCtx, dataCollection, Privileges.DataCollectionLevelPrivilegeType.READ);
        }
        context.datasets.entrySet().stream().filter(dataset -> dataset.getValue() != null).forEach(dataset -> {
            try {
                context.datasetQualityStatuses.put((AnyLoc)dataset.getKey(), this.dataQualityService.getDatasetStatusLast_NT((SerializedDataset)dataset.getValue()));
                int emptyColumns = 0;
                Schema sdSchema = ((SerializedDataset)dataset.getValue()).getSchema();
                if (sdSchema != null) {
                    for (SchemaColumn column : sdSchema.getColumns()) {
                        if (!StringUtils.isBlank((String)column.comment)) continue;
                        ++emptyColumns;
                    }
                }
                context.emptyDescriptionColumnsCount.put((AnyLoc)dataset.getKey(), emptyColumns);
            }
            catch (SQLException e) {
                logger.warn((Object)("Failed to compute aggregated checks for dataset " + ((SerializedDataset)dataset.getValue()).getFullName()), (Throwable)e);
            }
        });
        try {
            context.lastBuildTimes = this.jobsDBService.getLatestBuildTimeForDatasets(context.datasets.keySet());
        }
        catch (SQLException e) {
            logger.warn((Object)("Failed to get last build time for data collection " + collectionId), (Throwable)e);
        }
        List<UIDataCollection.AbstractDataCollectionItemInfo> summarizedItems = dataCollection.items.stream().map(item -> item.summarize(context)).filter(Objects::nonNull).collect(Collectors.toList());
        return new UIDataCollection.DataCollectionInfo(dataCollection, summarizedItems, currentUserPermissions);
    }

    public List<AbstractDataCollectionItem> getDataCollectionItemsFiltered(AuthCtx authCtx, DataCollection dataCollection) throws IOException, DKUSecurityException {
        ArrayList<AbstractDataCollectionItem> result = new ArrayList<AbstractDataCollectionItem>();
        for (AbstractDataCollectionItem item : dataCollection.items) {
            AnyLoc loc;
            boolean isDatasetVisible;
            if (!(item instanceof DataCollectionDataset) || !(isDatasetVisible = this.projectsService.hasPermissionRegardlessOfContext(authCtx, (loc = ((DataCollectionDataset)item).reference).getProjectKey(), ITaggingService.TaggableType.DATASET, loc.getId(), SerializedProject.ReaderAuthorization.Mode.DISCOVER))) continue;
            result.add(item);
        }
        return result;
    }

    public void updateMetadata(DataCollection dataCollection, UIDataCollection.MetadataInfo metadata) throws IOException {
        Preconditions.checkArgument((boolean)this.dataCollectionsDAO.exists(dataCollection.id));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metadata.displayName), (Object)"Data collection name cannot be empty");
        Preconditions.checkNotNull((Object)metadata.description, (Object)"Data collection description cannot be null");
        Preconditions.checkNotNull((Object)metadata.color, (Object)"Data collection color cannot be null");
        Preconditions.checkNotNull(metadata.tags, (Object)"Data collection tags cannot be null");
        dataCollection.displayName = metadata.displayName;
        dataCollection.description = metadata.description;
        dataCollection.tags = metadata.tags;
        dataCollection.color = metadata.color;
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_EDIT, Set.of());
    }

    public void updateColumnsCustomization(DataCollection dataCollection, DataCollectionColumnsCustomization columnsCustomizationSettings) throws IOException {
        Preconditions.checkArgument((boolean)this.dataCollectionsDAO.exists(dataCollection.id));
        Preconditions.checkNotNull((Object)columnsCustomizationSettings, (Object)"Data collection column customization settings cannot be null");
        dataCollection.columnsCustomizationSettings = columnsCustomizationSettings;
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_EDIT, Set.of());
    }

    public void updateMetadataCompletenessChecks(DataCollection dataCollection, UIDataCollection.MetadataCompletenessChecks metadataCompletenessChecks) throws IOException {
        Preconditions.checkArgument((boolean)this.dataCollectionsDAO.exists(dataCollection.id));
        Preconditions.checkNotNull((Object)metadataCompletenessChecks, (Object)"Data collection metadata completeness cannot be null");
        Preconditions.checkNotNull((Object)((Object)metadataCompletenessChecks.longDescriptionCheck), (Object)"Long description check cannot be null");
        Preconditions.checkNotNull((Object)((Object)metadataCompletenessChecks.columnsDescriptionCheck), (Object)"Columns description check cannot be null");
        dataCollection.metadataCompletenessChecks = new DataCollection.MetadataCompletenessChecks(metadataCompletenessChecks);
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_EDIT, Set.of());
    }

    public void renameDatasetInDataCollection(String dataCollectionId, AbstractDataCollectionItemRef.DatasetRef oldDataset, AbstractDataCollectionItemRef.DatasetRef newDataset) throws IOException {
        DataCollection dataCollection = this.getOrNull(dataCollectionId);
        if (dataCollection == null) {
            return;
        }
        dataCollection.items.stream().filter(oldDataset::refersTo).findFirst().map(item -> (DataCollectionDataset)item).ifPresent(foundDataset -> {
            foundDataset.reference = new AnyLoc(newDataset.projectKey, newDataset.id);
        });
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_EDIT_ITEMS, Set.of());
    }

    public void updatePermissions(DataCollection dataCollection, List<BasePermissions.PermissionItem> permissions) throws IOException, DKUSecurityException {
        dataCollection.permissions = permissions;
        if (dataCollection.permissions.stream().noneMatch(permission -> (permission.user != null || permission.group != null) && permission.admin)) {
            throw new ApplicativeException("Configuration error", "A data collection must have at least one administrator.");
        }
        this.dataCollectionPermissionsService.checkAllUserGroupCanBeAdded(dataCollection);
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_EDIT, Set.of());
    }

    List<BasePermissions.PermissionItem> mergePermissions(List<BasePermissions.PermissionItem> permissions) {
        LinkedHashMap<Pair, BasePermissions.PermissionItem> result = new LinkedHashMap<Pair, BasePermissions.PermissionItem>();
        if (permissions != null) {
            for (BasePermissions.PermissionItem item : permissions) {
                Pair pair;
                if (item == null) continue;
                item.write |= item.admin;
                item.read |= item.write;
                if (StringUtils.isNotBlank((String)item.user)) {
                    pair = new Pair((Object)"USER", (Object)item.user);
                } else {
                    if (!StringUtils.isNotBlank((String)item.group)) continue;
                    pair = new Pair((Object)"GROUP", (Object)item.group);
                }
                BasePermissions.PermissionItem existing = (BasePermissions.PermissionItem)result.get(pair);
                if (existing == null) {
                    result.put(pair, item);
                    continue;
                }
                existing.admin |= item.admin;
                existing.write = existing.write | (item.write || existing.admin);
                existing.read = existing.read | (item.read || existing.write);
            }
        }
        return new ArrayList<BasePermissions.PermissionItem>(result.values());
    }

    public void removeItemFromAllCollections(AbstractDataCollectionItemRef itemRef) throws IOException {
        for (DataCollection dataCollection : this.listUnsafe()) {
            if (!dataCollection.contains(itemRef)) continue;
            this.removeItem(this.getMandatory(dataCollection.getId()), itemRef);
        }
    }

    public void removeItem(DataCollection dataCollection, AbstractDataCollectionItemRef itemRef) throws IOException {
        AbstractDataCollectionItem itemToRemove = dataCollection.items.stream().filter(itemRef::refersTo).findFirst().orElse(null);
        if (itemToRemove == null) {
            return;
        }
        dataCollection.items.remove(itemToRemove);
        this.saveInternal(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_EDIT_ITEMS, Set.of(itemToRemove));
    }

    public void delete(DataCollection dataCollection) throws IOException {
        Preconditions.checkArgument((dataCollection != null ? 1 : 0) != 0);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.dataCollectionsDAO.delete(dataCollection.id);
        this.pubSub.publishAfterTransaction(new DataCollectionChangedEvent(dataCollection, TaggableObjectChangedEvent.ActionType.DATA_COLLECTION_DELETE, dataCollection.items));
    }

    private void saveInternal(DataCollection dataCollection, TaggableObjectChangedEvent.ActionType action, Set<AbstractDataCollectionItem> impactedItems) throws IOException {
        Preconditions.checkArgument((boolean)dataCollection.permissions.stream().noneMatch(permission -> StringUtils.isNotBlank((String)permission.pendingUserEmail)), (Object)"A data collection cannot have pending email permissions.");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        DataCollection preExisting = this.dataCollectionsDAO.getOrNullUnsafe(dataCollection.id);
        dataCollection.permissions = this.mergePermissions(dataCollection.permissions);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(dataCollection, preExisting);
        this.dataCollectionsDAO.save(dataCollection);
        this.pubSub.publishAfterTransaction(new DataCollectionChangedEvent(dataCollection, action, impactedItems));
    }

    public void computeDeletionImpact(TaggableObjectsDeletionService.DeletionImpact di, AbstractDataCollectionItemRef itemRef, AuthCtx authCtx) throws IOException, DKUSecurityException {
        for (DataCollection dataCollection : this.listUnsafe()) {
            if (!dataCollection.items.stream().anyMatch(itemRef::refersTo)) continue;
            if (this.dataCollectionPermissionsService.hasDataCollectionPrivileges(authCtx, dataCollection, Privileges.DataCollectionLevelPrivilegeType.READ)) {
                di.impactedDataCollections.add(new TaggableObjectsDeletionService.ImpactedDataCollection(dataCollection.id, dataCollection.displayName));
                continue;
            }
            di.impactedUnaccessibleDataCollections.add(DKUtils.md5Base64((String)dataCollection.id));
        }
    }

    public List<DataCollection> list() throws IOException {
        return this.dataCollectionsDAO.list();
    }

    public List<DataCollection> listUnsafe() throws IOException {
        return this.dataCollectionsDAO.listUnsafe();
    }

    public List<DataCollection> listAccessibleUnsafe(AuthCtx authCtx, Privileges.DataCollectionLevelPrivilegeType privilege) throws IOException {
        return this.listUnsafe().stream().filter(dataCollection -> this.dataCollectionPermissionsService.filterOnHasDataCollectionPrivileges(authCtx, (DataCollection)dataCollection, privilege)).collect(Collectors.toList());
    }

    public List<DataCollection> listReadableUnsafe(AuthCtx authCtx) throws IOException {
        return this.listAccessibleUnsafe(authCtx, Privileges.DataCollectionLevelPrivilegeType.READ);
    }

    public List<DataCollection> listForItemUnsafe(AbstractDataCollectionItemRef itemRef) throws IOException {
        return this.listUnsafe().stream().filter(dataCollection -> dataCollection.contains(itemRef)).collect(Collectors.toList());
    }

    public DataCollectionsByItem listByItemUnsafe() throws IOException {
        List<DataCollection> allDataCollections = this.listUnsafe();
        HashMap<AbstractDataCollectionItemRef, List<DataCollection>> dataCollectionsByItem = new HashMap<AbstractDataCollectionItemRef, List<DataCollection>>();
        this.listUnsafe().forEach(dataCollection -> dataCollection.items.forEach(dataCollectionItem -> {
            dataCollectionsByItem.putIfAbsent(dataCollectionItem.getRef(), new LinkedList());
            ((List)dataCollectionsByItem.get(dataCollectionItem.getRef())).add(dataCollection);
        }));
        return new DataCollectionsByItem(allDataCollections, dataCollectionsByItem);
    }

    public List<UIDataCollection.RecentDatasetInfo> listRecentDatasetsUnsafe(AuthCtx authCtx) throws IOException, DKUSecurityException {
        HashMap<String, SerializedProject> serializedProjectMap = new HashMap<String, SerializedProject>();
        Map<String, UIDataCollection.RecentDatasetInfo> recentDatasetInfoMap = this.listAllDatasetFromReadableCollections(authCtx);
        List<UIDataCollection.RecentDatasetInfo> recentDatasetOrdered = recentDatasetInfoMap.values().stream().sorted(Comparator.comparing(dataset -> -dataset.lastAddedOnDataCollection)).toList();
        ArrayList<UIDataCollection.RecentDatasetInfo> res = new ArrayList<UIDataCollection.RecentDatasetInfo>();
        for (UIDataCollection.RecentDatasetInfo recentDatasetInfo : recentDatasetOrdered) {
            ProjectsService.ObjectVisibility visibility = this.projectsService.getDataCollectionObjectVisibility(authCtx, recentDatasetInfo.sourceProjectKey, ITaggingService.TaggableType.DATASET, recentDatasetInfo.name, false, true);
            if (visibility.equals((Object)ProjectsService.ObjectVisibility.NONE)) continue;
            if (!serializedProjectMap.containsKey(recentDatasetInfo.sourceProjectKey)) {
                serializedProjectMap.put(recentDatasetInfo.sourceProjectKey, this.projectsService.getMandatoryUnsafe(recentDatasetInfo.sourceProjectKey));
            }
            SerializedProject sp = (SerializedProject)serializedProjectMap.get(recentDatasetInfo.sourceProjectKey);
            recentDatasetInfo.setProjectName(sp.name);
            recentDatasetInfo.hasAnyProjectAccess = this.permissionsService.hasAnyProjectAccess(authCtx, sp);
            recentDatasetInfo.objectAuthorizations = this.exposedObjectsService.getObjectAuthorizations(recentDatasetInfo.sourceProjectKey, recentDatasetInfo.name, ITaggingService.TaggableType.DATASET, authCtx, visibility.equals((Object)ProjectsService.ObjectVisibility.READ));
            recentDatasetInfo.canRequestAccess = this.projectsService.isAccessRequestsEnabled(sp, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN());
            res.add(recentDatasetInfo);
            if (res.size() < 25) continue;
            break;
        }
        return res;
    }

    private Map<String, UIDataCollection.RecentDatasetInfo> listAllDatasetFromReadableCollections(AuthCtx authCtx) throws IOException {
        HashMap<String, UIDataCollection.RecentDatasetInfo> recentDatasetInfoMap = new HashMap<String, UIDataCollection.RecentDatasetInfo>();
        this.listAccessibleUnsafe(authCtx, Privileges.DataCollectionLevelPrivilegeType.READ).forEach(dataCollection -> dataCollection.items.forEach(dataCollectionItem -> {
            if (!(dataCollectionItem instanceof DataCollectionDataset)) {
                return;
            }
            DataCollectionDataset dataCollectionDataset = (DataCollectionDataset)dataCollectionItem;
            try {
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(dataCollectionDataset.reference.getProjectKey(), dataCollectionDataset.reference.getId());
                long dataCollectionAddedOn = dataCollectionDataset.dataCollectionAddedOn != null ? dataCollectionDataset.dataCollectionAddedOn : (sd.creationTag != null ? sd.creationTag.getLastModifiedOn() : 0L);
                recentDatasetInfoMap.putIfAbsent(sd.getFullName(), new UIDataCollection.RecentDatasetInfo(sd, sd.getProjectKey()));
                ((UIDataCollection.RecentDatasetInfo)recentDatasetInfoMap.get(sd.getFullName())).addDatasetDataCollection((DataCollection)dataCollection, dataCollectionAddedOn);
            }
            catch (IOException e) {
                logger.error((Object)("Issue while reading information of the dataset: " + dataCollectionDataset.reference.getFullName()), (Throwable)e);
            }
        }));
        return recentDatasetInfoMap;
    }

    public DataCollection getOrNull(String id) throws IOException {
        return this.dataCollectionsDAO.getOrNull(id);
    }

    public DataCollection getOrNullUnsafe(String id) throws IOException {
        return this.dataCollectionsDAO.getOrNullUnsafe(id);
    }

    public DataCollection getOrNullNoThrowsUnsafe(String id) {
        try {
            return this.getOrNullUnsafe(id);
        }
        catch (IOException e) {
            logger.errorV((Throwable)e, "Failed to retrieve data collection [%s]", new Object[]{id});
            return null;
        }
    }

    public DataCollection getMandatoryUnsafe(String id) throws IOException {
        return this.dataCollectionsDAO.getMandatoryUnsafe(id);
    }

    public DataCollection getMandatory(String id) throws IOException {
        return this.dataCollectionsDAO.getMandatory(id);
    }

    public void checkPerm(AuthCtx authCtx, String id, Privileges.DataCollectionLevelPrivilegeType privilege) throws IOException, DKUSecurityException {
        this.dataCollectionPermissionsService.checkDataCollectionPrivileges(authCtx, this.getMandatoryUnsafe(id), privilege);
    }
}

